/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Date and time input values.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DateTimeInput extends com.google.api.client.json.GenericJson {

  /**
   * Whether the `datetime` input includes a calendar date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasDate;

  /**
   * Whether the `datetime` input includes a timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasTime;

  /**
   * Time since epoch time, in milliseconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long msSinceEpoch;

  /**
   * Whether the `datetime` input includes a calendar date.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasDate() {
    return hasDate;
  }

  /**
   * Whether the `datetime` input includes a calendar date.
   * @param hasDate hasDate or {@code null} for none
   */
  public DateTimeInput setHasDate(java.lang.Boolean hasDate) {
    this.hasDate = hasDate;
    return this;
  }

  /**
   * Whether the `datetime` input includes a timestamp.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasTime() {
    return hasTime;
  }

  /**
   * Whether the `datetime` input includes a timestamp.
   * @param hasTime hasTime or {@code null} for none
   */
  public DateTimeInput setHasTime(java.lang.Boolean hasTime) {
    this.hasTime = hasTime;
    return this;
  }

  /**
   * Time since epoch time, in milliseconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMsSinceEpoch() {
    return msSinceEpoch;
  }

  /**
   * Time since epoch time, in milliseconds.
   * @param msSinceEpoch msSinceEpoch or {@code null} for none
   */
  public DateTimeInput setMsSinceEpoch(java.lang.Long msSinceEpoch) {
    this.msSinceEpoch = msSinceEpoch;
    return this;
  }

  @Override
  public DateTimeInput set(String fieldName, Object value) {
    return (DateTimeInput) super.set(fieldName, value);
  }

  @Override
  public DateTimeInput clone() {
    return (DateTimeInput) super.clone();
  }

}
