/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Response message for listing messages.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMessagesResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * You can send a token as `pageToken` to retrieve the next page of results. If empty, there are
   * no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of messages.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * List of messages.
   * @param messages messages or {@code null} for none
   */
  public ListMessagesResponse setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * You can send a token as `pageToken` to retrieve the next page of results. If empty, there are
   * no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * You can send a token as `pageToken` to retrieve the next page of results. If empty, there are
   * no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMessagesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListMessagesResponse set(String fieldName, Object value) {
    return (ListMessagesResponse) super.set(fieldName, value);
  }

  @Override
  public ListMessagesResponse clone() {
    return (ListMessagesResponse) super.clone();
  }

}
