/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A matched URL in a Chat message. Chat apps can preview matched URLs. For more information, see
 * [Preview links](https://developers.google.com/chat/how-tos/preview-links).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MatchedUrl extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The URL that was matched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * Output only. The URL that was matched.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * Output only. The URL that was matched.
   * @param url url or {@code null} for none
   */
  public MatchedUrl setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public MatchedUrl set(String fieldName, Object value) {
    return (MatchedUrl) super.set(fieldName, value);
  }

  @Override
  public MatchedUrl clone() {
    return (MatchedUrl) super.clone();
  }

}
