/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * An event that represents a change or activity in a Google Chat space. To learn more, see [Work
 * with events from Google Chat](https://developers.google.com/workspace/chat/events-overview).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SpaceEvent extends com.google.api.client.json.GenericJson {

  /**
   * Time when the event occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String eventTime;

  /**
   * Type of space event. Each event type has a batch version, which represents multiple instances
   * of the event type that occur in a short period of time. For `spaceEvents.list()` requests, omit
   * batch event types in your query filter. By default, the server returns both event type and its
   * batch version. Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   * * New message: `google.workspace.chat.message.v1.created` * Updated message:
   * `google.workspace.chat.message.v1.updated` * Deleted message:
   * `google.workspace.chat.message.v1.deleted` * Multiple new messages:
   * `google.workspace.chat.message.v1.batchCreated` * Multiple updated messages:
   * `google.workspace.chat.message.v1.batchUpdated` * Multiple deleted messages:
   * `google.workspace.chat.message.v1.batchDeleted` Supported event types for [memberships](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members): * New membership:
   * `google.workspace.chat.membership.v1.created` * Updated membership:
   * `google.workspace.chat.membership.v1.updated` * Deleted membership:
   * `google.workspace.chat.membership.v1.deleted` * Multiple new memberships:
   * `google.workspace.chat.membership.v1.batchCreated` * Multiple updated memberships:
   * `google.workspace.chat.membership.v1.batchUpdated` * Multiple deleted memberships:
   * `google.workspace.chat.membership.v1.batchDeleted` Supported event types for [reactions](https:
   * //developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions): * New
   * reaction: `google.workspace.chat.reaction.v1.created` * Deleted reaction:
   * `google.workspace.chat.reaction.v1.deleted` * Multiple new reactions:
   * `google.workspace.chat.reaction.v1.batchCreated` * Multiple deleted reactions:
   * `google.workspace.chat.reaction.v1.batchDeleted` Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces): * Updated
   * space: `google.workspace.chat.space.v1.updated` * Multiple space updates:
   * `google.workspace.chat.space.v1.batchUpdated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventType;

  /**
   * Event payload for multiple new memberships. Event type:
   * `google.workspace.chat.membership.v1.batchCreated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipBatchCreatedEventData membershipBatchCreatedEventData;

  /**
   * Event payload for multiple deleted memberships. Event type:
   * `google.workspace.chat.membership.v1.batchDeleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipBatchDeletedEventData membershipBatchDeletedEventData;

  /**
   * Event payload for multiple updated memberships. Event type:
   * `google.workspace.chat.membership.v1.batchUpdated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipBatchUpdatedEventData membershipBatchUpdatedEventData;

  /**
   * Event payload for a new membership. Event type: `google.workspace.chat.membership.v1.created`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipCreatedEventData membershipCreatedEventData;

  /**
   * Event payload for a deleted membership. Event type:
   * `google.workspace.chat.membership.v1.deleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipDeletedEventData membershipDeletedEventData;

  /**
   * Event payload for an updated membership. Event type:
   * `google.workspace.chat.membership.v1.updated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipUpdatedEventData membershipUpdatedEventData;

  /**
   * Event payload for multiple new messages. Event type:
   * `google.workspace.chat.message.v1.batchCreated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageBatchCreatedEventData messageBatchCreatedEventData;

  /**
   * Event payload for multiple deleted messages. Event type:
   * `google.workspace.chat.message.v1.batchDeleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageBatchDeletedEventData messageBatchDeletedEventData;

  /**
   * Event payload for multiple updated messages. Event type:
   * `google.workspace.chat.message.v1.batchUpdated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageBatchUpdatedEventData messageBatchUpdatedEventData;

  /**
   * Event payload for a new message. Event type: `google.workspace.chat.message.v1.created`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageCreatedEventData messageCreatedEventData;

  /**
   * Event payload for a deleted message. Event type: `google.workspace.chat.message.v1.deleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageDeletedEventData messageDeletedEventData;

  /**
   * Event payload for an updated message. Event type: `google.workspace.chat.message.v1.updated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MessageUpdatedEventData messageUpdatedEventData;

  /**
   * Resource name of the space event. Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Event payload for multiple new reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchCreated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReactionBatchCreatedEventData reactionBatchCreatedEventData;

  /**
   * Event payload for multiple deleted reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchDeleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReactionBatchDeletedEventData reactionBatchDeletedEventData;

  /**
   * Event payload for a new reaction. Event type: `google.workspace.chat.reaction.v1.created`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReactionCreatedEventData reactionCreatedEventData;

  /**
   * Event payload for a deleted reaction. Event type: `google.workspace.chat.reaction.v1.deleted`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReactionDeletedEventData reactionDeletedEventData;

  /**
   * Event payload for multiple updates to a space. Event type:
   * `google.workspace.chat.space.v1.batchUpdated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpaceBatchUpdatedEventData spaceBatchUpdatedEventData;

  /**
   * Event payload for a space update. Event type: `google.workspace.chat.space.v1.updated`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpaceUpdatedEventData spaceUpdatedEventData;

  /**
   * Time when the event occurred.
   * @return value or {@code null} for none
   */
  public String getEventTime() {
    return eventTime;
  }

  /**
   * Time when the event occurred.
   * @param eventTime eventTime or {@code null} for none
   */
  public SpaceEvent setEventTime(String eventTime) {
    this.eventTime = eventTime;
    return this;
  }

  /**
   * Type of space event. Each event type has a batch version, which represents multiple instances
   * of the event type that occur in a short period of time. For `spaceEvents.list()` requests, omit
   * batch event types in your query filter. By default, the server returns both event type and its
   * batch version. Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   * * New message: `google.workspace.chat.message.v1.created` * Updated message:
   * `google.workspace.chat.message.v1.updated` * Deleted message:
   * `google.workspace.chat.message.v1.deleted` * Multiple new messages:
   * `google.workspace.chat.message.v1.batchCreated` * Multiple updated messages:
   * `google.workspace.chat.message.v1.batchUpdated` * Multiple deleted messages:
   * `google.workspace.chat.message.v1.batchDeleted` Supported event types for [memberships](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members): * New membership:
   * `google.workspace.chat.membership.v1.created` * Updated membership:
   * `google.workspace.chat.membership.v1.updated` * Deleted membership:
   * `google.workspace.chat.membership.v1.deleted` * Multiple new memberships:
   * `google.workspace.chat.membership.v1.batchCreated` * Multiple updated memberships:
   * `google.workspace.chat.membership.v1.batchUpdated` * Multiple deleted memberships:
   * `google.workspace.chat.membership.v1.batchDeleted` Supported event types for [reactions](https:
   * //developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions): * New
   * reaction: `google.workspace.chat.reaction.v1.created` * Deleted reaction:
   * `google.workspace.chat.reaction.v1.deleted` * Multiple new reactions:
   * `google.workspace.chat.reaction.v1.batchCreated` * Multiple deleted reactions:
   * `google.workspace.chat.reaction.v1.batchDeleted` Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces): * Updated
   * space: `google.workspace.chat.space.v1.updated` * Multiple space updates:
   * `google.workspace.chat.space.v1.batchUpdated`
   * @return value or {@code null} for none
   */
  public java.lang.String getEventType() {
    return eventType;
  }

  /**
   * Type of space event. Each event type has a batch version, which represents multiple instances
   * of the event type that occur in a short period of time. For `spaceEvents.list()` requests, omit
   * batch event types in your query filter. By default, the server returns both event type and its
   * batch version. Supported event types for
   * [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
   * * New message: `google.workspace.chat.message.v1.created` * Updated message:
   * `google.workspace.chat.message.v1.updated` * Deleted message:
   * `google.workspace.chat.message.v1.deleted` * Multiple new messages:
   * `google.workspace.chat.message.v1.batchCreated` * Multiple updated messages:
   * `google.workspace.chat.message.v1.batchUpdated` * Multiple deleted messages:
   * `google.workspace.chat.message.v1.batchDeleted` Supported event types for [memberships](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members): * New membership:
   * `google.workspace.chat.membership.v1.created` * Updated membership:
   * `google.workspace.chat.membership.v1.updated` * Deleted membership:
   * `google.workspace.chat.membership.v1.deleted` * Multiple new memberships:
   * `google.workspace.chat.membership.v1.batchCreated` * Multiple updated memberships:
   * `google.workspace.chat.membership.v1.batchUpdated` * Multiple deleted memberships:
   * `google.workspace.chat.membership.v1.batchDeleted` Supported event types for [reactions](https:
   * //developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions): * New
   * reaction: `google.workspace.chat.reaction.v1.created` * Deleted reaction:
   * `google.workspace.chat.reaction.v1.deleted` * Multiple new reactions:
   * `google.workspace.chat.reaction.v1.batchCreated` * Multiple deleted reactions:
   * `google.workspace.chat.reaction.v1.batchDeleted` Supported event types about the
   * [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces): * Updated
   * space: `google.workspace.chat.space.v1.updated` * Multiple space updates:
   * `google.workspace.chat.space.v1.batchUpdated`
   * @param eventType eventType or {@code null} for none
   */
  public SpaceEvent setEventType(java.lang.String eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * Event payload for multiple new memberships. Event type:
   * `google.workspace.chat.membership.v1.batchCreated`
   * @return value or {@code null} for none
   */
  public MembershipBatchCreatedEventData getMembershipBatchCreatedEventData() {
    return membershipBatchCreatedEventData;
  }

  /**
   * Event payload for multiple new memberships. Event type:
   * `google.workspace.chat.membership.v1.batchCreated`
   * @param membershipBatchCreatedEventData membershipBatchCreatedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipBatchCreatedEventData(MembershipBatchCreatedEventData membershipBatchCreatedEventData) {
    this.membershipBatchCreatedEventData = membershipBatchCreatedEventData;
    return this;
  }

  /**
   * Event payload for multiple deleted memberships. Event type:
   * `google.workspace.chat.membership.v1.batchDeleted`
   * @return value or {@code null} for none
   */
  public MembershipBatchDeletedEventData getMembershipBatchDeletedEventData() {
    return membershipBatchDeletedEventData;
  }

  /**
   * Event payload for multiple deleted memberships. Event type:
   * `google.workspace.chat.membership.v1.batchDeleted`
   * @param membershipBatchDeletedEventData membershipBatchDeletedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipBatchDeletedEventData(MembershipBatchDeletedEventData membershipBatchDeletedEventData) {
    this.membershipBatchDeletedEventData = membershipBatchDeletedEventData;
    return this;
  }

  /**
   * Event payload for multiple updated memberships. Event type:
   * `google.workspace.chat.membership.v1.batchUpdated`
   * @return value or {@code null} for none
   */
  public MembershipBatchUpdatedEventData getMembershipBatchUpdatedEventData() {
    return membershipBatchUpdatedEventData;
  }

  /**
   * Event payload for multiple updated memberships. Event type:
   * `google.workspace.chat.membership.v1.batchUpdated`
   * @param membershipBatchUpdatedEventData membershipBatchUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipBatchUpdatedEventData(MembershipBatchUpdatedEventData membershipBatchUpdatedEventData) {
    this.membershipBatchUpdatedEventData = membershipBatchUpdatedEventData;
    return this;
  }

  /**
   * Event payload for a new membership. Event type: `google.workspace.chat.membership.v1.created`
   * @return value or {@code null} for none
   */
  public MembershipCreatedEventData getMembershipCreatedEventData() {
    return membershipCreatedEventData;
  }

  /**
   * Event payload for a new membership. Event type: `google.workspace.chat.membership.v1.created`
   * @param membershipCreatedEventData membershipCreatedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipCreatedEventData(MembershipCreatedEventData membershipCreatedEventData) {
    this.membershipCreatedEventData = membershipCreatedEventData;
    return this;
  }

  /**
   * Event payload for a deleted membership. Event type:
   * `google.workspace.chat.membership.v1.deleted`
   * @return value or {@code null} for none
   */
  public MembershipDeletedEventData getMembershipDeletedEventData() {
    return membershipDeletedEventData;
  }

  /**
   * Event payload for a deleted membership. Event type:
   * `google.workspace.chat.membership.v1.deleted`
   * @param membershipDeletedEventData membershipDeletedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipDeletedEventData(MembershipDeletedEventData membershipDeletedEventData) {
    this.membershipDeletedEventData = membershipDeletedEventData;
    return this;
  }

  /**
   * Event payload for an updated membership. Event type:
   * `google.workspace.chat.membership.v1.updated`
   * @return value or {@code null} for none
   */
  public MembershipUpdatedEventData getMembershipUpdatedEventData() {
    return membershipUpdatedEventData;
  }

  /**
   * Event payload for an updated membership. Event type:
   * `google.workspace.chat.membership.v1.updated`
   * @param membershipUpdatedEventData membershipUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setMembershipUpdatedEventData(MembershipUpdatedEventData membershipUpdatedEventData) {
    this.membershipUpdatedEventData = membershipUpdatedEventData;
    return this;
  }

  /**
   * Event payload for multiple new messages. Event type:
   * `google.workspace.chat.message.v1.batchCreated`
   * @return value or {@code null} for none
   */
  public MessageBatchCreatedEventData getMessageBatchCreatedEventData() {
    return messageBatchCreatedEventData;
  }

  /**
   * Event payload for multiple new messages. Event type:
   * `google.workspace.chat.message.v1.batchCreated`
   * @param messageBatchCreatedEventData messageBatchCreatedEventData or {@code null} for none
   */
  public SpaceEvent setMessageBatchCreatedEventData(MessageBatchCreatedEventData messageBatchCreatedEventData) {
    this.messageBatchCreatedEventData = messageBatchCreatedEventData;
    return this;
  }

  /**
   * Event payload for multiple deleted messages. Event type:
   * `google.workspace.chat.message.v1.batchDeleted`
   * @return value or {@code null} for none
   */
  public MessageBatchDeletedEventData getMessageBatchDeletedEventData() {
    return messageBatchDeletedEventData;
  }

  /**
   * Event payload for multiple deleted messages. Event type:
   * `google.workspace.chat.message.v1.batchDeleted`
   * @param messageBatchDeletedEventData messageBatchDeletedEventData or {@code null} for none
   */
  public SpaceEvent setMessageBatchDeletedEventData(MessageBatchDeletedEventData messageBatchDeletedEventData) {
    this.messageBatchDeletedEventData = messageBatchDeletedEventData;
    return this;
  }

  /**
   * Event payload for multiple updated messages. Event type:
   * `google.workspace.chat.message.v1.batchUpdated`
   * @return value or {@code null} for none
   */
  public MessageBatchUpdatedEventData getMessageBatchUpdatedEventData() {
    return messageBatchUpdatedEventData;
  }

  /**
   * Event payload for multiple updated messages. Event type:
   * `google.workspace.chat.message.v1.batchUpdated`
   * @param messageBatchUpdatedEventData messageBatchUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setMessageBatchUpdatedEventData(MessageBatchUpdatedEventData messageBatchUpdatedEventData) {
    this.messageBatchUpdatedEventData = messageBatchUpdatedEventData;
    return this;
  }

  /**
   * Event payload for a new message. Event type: `google.workspace.chat.message.v1.created`
   * @return value or {@code null} for none
   */
  public MessageCreatedEventData getMessageCreatedEventData() {
    return messageCreatedEventData;
  }

  /**
   * Event payload for a new message. Event type: `google.workspace.chat.message.v1.created`
   * @param messageCreatedEventData messageCreatedEventData or {@code null} for none
   */
  public SpaceEvent setMessageCreatedEventData(MessageCreatedEventData messageCreatedEventData) {
    this.messageCreatedEventData = messageCreatedEventData;
    return this;
  }

  /**
   * Event payload for a deleted message. Event type: `google.workspace.chat.message.v1.deleted`
   * @return value or {@code null} for none
   */
  public MessageDeletedEventData getMessageDeletedEventData() {
    return messageDeletedEventData;
  }

  /**
   * Event payload for a deleted message. Event type: `google.workspace.chat.message.v1.deleted`
   * @param messageDeletedEventData messageDeletedEventData or {@code null} for none
   */
  public SpaceEvent setMessageDeletedEventData(MessageDeletedEventData messageDeletedEventData) {
    this.messageDeletedEventData = messageDeletedEventData;
    return this;
  }

  /**
   * Event payload for an updated message. Event type: `google.workspace.chat.message.v1.updated`
   * @return value or {@code null} for none
   */
  public MessageUpdatedEventData getMessageUpdatedEventData() {
    return messageUpdatedEventData;
  }

  /**
   * Event payload for an updated message. Event type: `google.workspace.chat.message.v1.updated`
   * @param messageUpdatedEventData messageUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setMessageUpdatedEventData(MessageUpdatedEventData messageUpdatedEventData) {
    this.messageUpdatedEventData = messageUpdatedEventData;
    return this;
  }

  /**
   * Resource name of the space event. Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the space event. Format: `spaces/{space}/spaceEvents/{spaceEvent}`
   * @param name name or {@code null} for none
   */
  public SpaceEvent setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Event payload for multiple new reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchCreated`
   * @return value or {@code null} for none
   */
  public ReactionBatchCreatedEventData getReactionBatchCreatedEventData() {
    return reactionBatchCreatedEventData;
  }

  /**
   * Event payload for multiple new reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchCreated`
   * @param reactionBatchCreatedEventData reactionBatchCreatedEventData or {@code null} for none
   */
  public SpaceEvent setReactionBatchCreatedEventData(ReactionBatchCreatedEventData reactionBatchCreatedEventData) {
    this.reactionBatchCreatedEventData = reactionBatchCreatedEventData;
    return this;
  }

  /**
   * Event payload for multiple deleted reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchDeleted`
   * @return value or {@code null} for none
   */
  public ReactionBatchDeletedEventData getReactionBatchDeletedEventData() {
    return reactionBatchDeletedEventData;
  }

  /**
   * Event payload for multiple deleted reactions. Event type:
   * `google.workspace.chat.reaction.v1.batchDeleted`
   * @param reactionBatchDeletedEventData reactionBatchDeletedEventData or {@code null} for none
   */
  public SpaceEvent setReactionBatchDeletedEventData(ReactionBatchDeletedEventData reactionBatchDeletedEventData) {
    this.reactionBatchDeletedEventData = reactionBatchDeletedEventData;
    return this;
  }

  /**
   * Event payload for a new reaction. Event type: `google.workspace.chat.reaction.v1.created`
   * @return value or {@code null} for none
   */
  public ReactionCreatedEventData getReactionCreatedEventData() {
    return reactionCreatedEventData;
  }

  /**
   * Event payload for a new reaction. Event type: `google.workspace.chat.reaction.v1.created`
   * @param reactionCreatedEventData reactionCreatedEventData or {@code null} for none
   */
  public SpaceEvent setReactionCreatedEventData(ReactionCreatedEventData reactionCreatedEventData) {
    this.reactionCreatedEventData = reactionCreatedEventData;
    return this;
  }

  /**
   * Event payload for a deleted reaction. Event type: `google.workspace.chat.reaction.v1.deleted`
   * @return value or {@code null} for none
   */
  public ReactionDeletedEventData getReactionDeletedEventData() {
    return reactionDeletedEventData;
  }

  /**
   * Event payload for a deleted reaction. Event type: `google.workspace.chat.reaction.v1.deleted`
   * @param reactionDeletedEventData reactionDeletedEventData or {@code null} for none
   */
  public SpaceEvent setReactionDeletedEventData(ReactionDeletedEventData reactionDeletedEventData) {
    this.reactionDeletedEventData = reactionDeletedEventData;
    return this;
  }

  /**
   * Event payload for multiple updates to a space. Event type:
   * `google.workspace.chat.space.v1.batchUpdated`
   * @return value or {@code null} for none
   */
  public SpaceBatchUpdatedEventData getSpaceBatchUpdatedEventData() {
    return spaceBatchUpdatedEventData;
  }

  /**
   * Event payload for multiple updates to a space. Event type:
   * `google.workspace.chat.space.v1.batchUpdated`
   * @param spaceBatchUpdatedEventData spaceBatchUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setSpaceBatchUpdatedEventData(SpaceBatchUpdatedEventData spaceBatchUpdatedEventData) {
    this.spaceBatchUpdatedEventData = spaceBatchUpdatedEventData;
    return this;
  }

  /**
   * Event payload for a space update. Event type: `google.workspace.chat.space.v1.updated`
   * @return value or {@code null} for none
   */
  public SpaceUpdatedEventData getSpaceUpdatedEventData() {
    return spaceUpdatedEventData;
  }

  /**
   * Event payload for a space update. Event type: `google.workspace.chat.space.v1.updated`
   * @param spaceUpdatedEventData spaceUpdatedEventData or {@code null} for none
   */
  public SpaceEvent setSpaceUpdatedEventData(SpaceUpdatedEventData spaceUpdatedEventData) {
    this.spaceUpdatedEventData = spaceUpdatedEventData;
    return this;
  }

  @Override
  public SpaceEvent set(String fieldName, Object value) {
    return (SpaceEvent) super.set(fieldName, value);
  }

  @Override
  public SpaceEvent clone() {
    return (SpaceEvent) super.clone();
  }

}
