/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Data for Chat space links.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChatSpaceLinkData extends com.google.api.client.json.GenericJson {

  /**
   * The message of the linked Chat space resource. Format: `spaces/{space}/messages/{message}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * The space of the linked Chat space resource. Format: `spaces/{space}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String space;

  /**
   * The thread of the linked Chat space resource. Format: `spaces/{space}/threads/{thread}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thread;

  /**
   * The message of the linked Chat space resource. Format: `spaces/{space}/messages/{message}`
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * The message of the linked Chat space resource. Format: `spaces/{space}/messages/{message}`
   * @param message message or {@code null} for none
   */
  public ChatSpaceLinkData setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  /**
   * The space of the linked Chat space resource. Format: `spaces/{space}`
   * @return value or {@code null} for none
   */
  public java.lang.String getSpace() {
    return space;
  }

  /**
   * The space of the linked Chat space resource. Format: `spaces/{space}`
   * @param space space or {@code null} for none
   */
  public ChatSpaceLinkData setSpace(java.lang.String space) {
    this.space = space;
    return this;
  }

  /**
   * The thread of the linked Chat space resource. Format: `spaces/{space}/threads/{thread}`
   * @return value or {@code null} for none
   */
  public java.lang.String getThread() {
    return thread;
  }

  /**
   * The thread of the linked Chat space resource. Format: `spaces/{space}/threads/{thread}`
   * @param thread thread or {@code null} for none
   */
  public ChatSpaceLinkData setThread(java.lang.String thread) {
    this.thread = thread;
    return this;
  }

  @Override
  public ChatSpaceLinkData set(String fieldName, Object value) {
    return (ChatSpaceLinkData) super.set(fieldName, value);
  }

  @Override
  public ChatSpaceLinkData clone() {
    return (ChatSpaceLinkData) super.clone();
  }

}
