/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The number of people who reacted to a message with a specific emoji.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmojiReactionSummary extends com.google.api.client.json.GenericJson {

  /**
   * Emoji associated with the reactions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Emoji emoji;

  /**
   * The total number of reactions using the associated emoji.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer reactionCount;

  /**
   * Emoji associated with the reactions.
   * @return value or {@code null} for none
   */
  public Emoji getEmoji() {
    return emoji;
  }

  /**
   * Emoji associated with the reactions.
   * @param emoji emoji or {@code null} for none
   */
  public EmojiReactionSummary setEmoji(Emoji emoji) {
    this.emoji = emoji;
    return this;
  }

  /**
   * The total number of reactions using the associated emoji.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getReactionCount() {
    return reactionCount;
  }

  /**
   * The total number of reactions using the associated emoji.
   * @param reactionCount reactionCount or {@code null} for none
   */
  public EmojiReactionSummary setReactionCount(java.lang.Integer reactionCount) {
    this.reactionCount = reactionCount;
    return this;
  }

  @Override
  public EmojiReactionSummary set(String fieldName, Object value) {
    return (EmojiReactionSummary) super.set(fieldName, value);
  }

  @Override
  public EmojiReactionSummary clone() {
    return (EmojiReactionSummary) super.clone();
  }

}
