/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The style options for the border of a card or widget, including the border type and color.
 * [Google Workspace Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1BorderStyle extends com.google.api.client.json.GenericJson {

  /**
   * The corner radius for the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer cornerRadius;

  /**
   * The colors to use when the type is `BORDER_TYPE_STROKE`. To set the stroke color, specify a
   * value for the `red`, `green`, and `blue` fields. The value must be a float number between 0 and
   * 1 based on the RGB color value, where `0` (0/255) represents the absence of color and `1`
   * (255/255) represents the maximum intensity of the color. For example, the following sets the
   * color to red at its maximum intensity: ``` "color": { "red": 1, "green": 0, "blue": 0, } ```
   * The `alpha` field is unavailable for stroke color. If specified, this field is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color strokeColor;

  /**
   * The border type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The corner radius for the border.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCornerRadius() {
    return cornerRadius;
  }

  /**
   * The corner radius for the border.
   * @param cornerRadius cornerRadius or {@code null} for none
   */
  public GoogleAppsCardV1BorderStyle setCornerRadius(java.lang.Integer cornerRadius) {
    this.cornerRadius = cornerRadius;
    return this;
  }

  /**
   * The colors to use when the type is `BORDER_TYPE_STROKE`. To set the stroke color, specify a
   * value for the `red`, `green`, and `blue` fields. The value must be a float number between 0 and
   * 1 based on the RGB color value, where `0` (0/255) represents the absence of color and `1`
   * (255/255) represents the maximum intensity of the color. For example, the following sets the
   * color to red at its maximum intensity: ``` "color": { "red": 1, "green": 0, "blue": 0, } ```
   * The `alpha` field is unavailable for stroke color. If specified, this field is ignored.
   * @return value or {@code null} for none
   */
  public Color getStrokeColor() {
    return strokeColor;
  }

  /**
   * The colors to use when the type is `BORDER_TYPE_STROKE`. To set the stroke color, specify a
   * value for the `red`, `green`, and `blue` fields. The value must be a float number between 0 and
   * 1 based on the RGB color value, where `0` (0/255) represents the absence of color and `1`
   * (255/255) represents the maximum intensity of the color. For example, the following sets the
   * color to red at its maximum intensity: ``` "color": { "red": 1, "green": 0, "blue": 0, } ```
   * The `alpha` field is unavailable for stroke color. If specified, this field is ignored.
   * @param strokeColor strokeColor or {@code null} for none
   */
  public GoogleAppsCardV1BorderStyle setStrokeColor(Color strokeColor) {
    this.strokeColor = strokeColor;
    return this;
  }

  /**
   * The border type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The border type.
   * @param type type or {@code null} for none
   */
  public GoogleAppsCardV1BorderStyle setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public GoogleAppsCardV1BorderStyle set(String fieldName, Object value) {
    return (GoogleAppsCardV1BorderStyle) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1BorderStyle clone() {
    return (GoogleAppsCardV1BorderStyle) super.clone();
  }

}
