/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Response with a list of spaces corresponding to the search spaces request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchSpacesResponse extends com.google.api.client.json.GenericJson {

  /**
   * A token that can be used to retrieve the next page. If this field is empty, there are no
   * subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A page of the requested spaces.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Space> spaces;

  /**
   * The total number of spaces that match the query, across all pages. If the result is over 10,000
   * spaces, this value is an estimate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * A token that can be used to retrieve the next page. If this field is empty, there are no
   * subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token that can be used to retrieve the next page. If this field is empty, there are no
   * subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public SearchSpacesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A page of the requested spaces.
   * @return value or {@code null} for none
   */
  public java.util.List<Space> getSpaces() {
    return spaces;
  }

  /**
   * A page of the requested spaces.
   * @param spaces spaces or {@code null} for none
   */
  public SearchSpacesResponse setSpaces(java.util.List<Space> spaces) {
    this.spaces = spaces;
    return this;
  }

  /**
   * The total number of spaces that match the query, across all pages. If the result is over 10,000
   * spaces, this value is an estimate.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The total number of spaces that match the query, across all pages. If the result is over 10,000
   * spaces, this value is an estimate.
   * @param totalSize totalSize or {@code null} for none
   */
  public SearchSpacesResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  @Override
  public SearchSpacesResponse set(String fieldName, Object value) {
    return (SearchSpacesResponse) super.set(fieldName, value);
  }

  @Override
  public SearchSpacesResponse clone() {
    return (SearchSpacesResponse) super.clone();
  }

}
