/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A space in Google Chat. Spaces are conversations between two or more users or 1:1 messages
 * between a user and a Chat app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Space extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Specifies the [access setting](https://support.google.com/chat/answer/11971020) of
   * the space. Only populated when the `space_type` is `SPACE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccessSettings accessSettings;

  /**
   * Output only. For direct message (DM) spaces with a Chat app, whether the space was created by a
   * Google Workspace administrator. Administrators can install and set up a direct message with a
   * Chat app on behalf of users in their organization. To support admin install, your Chat app must
   * feature direct messaging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminInstalled;

  /**
   * Optional. Immutable. For spaces created in Chat, the time the space was created. This field is
   * output only, except when used in import mode spaces. For import mode spaces, set this field to
   * the historical timestamp at which the space was created in the source in order to preserve the
   * original creation time. Only populated in the output when `spaceType` is `GROUP_CHAT` or
   * `SPACE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create) with a
   * `spaceType` of `SPACE`. If you receive the error message `ALREADY_EXISTS` when creating a space
   * or updating the `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name. For direct messages, this
   * field might be empty. Supports up to 128 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. Omit this field when creating spaces in the following
   * conditions: * The authenticated user uses a consumer account (unmanaged user account). By
   * default, a space created by a consumer account permits any Google Chat user. For existing
   * spaces, this field is output only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean externalUserAllowed;

  /**
   * Optional. Whether this space is created in `Import Mode` as part of a data migration into
   * Google Workspace. While spaces are being imported, they aren't visible to users until the
   * import is complete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean importMode;

  /**
   * Output only. Timestamp of the last message in the space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastActiveTime;

  /**
   * Output only. The count of joined memberships grouped by member type. Populated when the
   * `space_type` is `SPACE`, `DIRECT_MESSAGE` or `GROUP_CHAT`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipCount membershipCount;

  /**
   * Resource name of the space. Format: `spaces/{space}` Where `{space}` represents the system-
   * assigned ID for the space. You can obtain the space ID by calling the [`spaces.list()`](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list) method or from the
   * space URL. For example, if the space URL is
   * `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID is `AAAAAAAAA`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean singleUserBotDm;

  /**
   * Details about the space including description and rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpaceDetails spaceDetails;

  /**
   * The message history state for messages and threads in this space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceHistoryState;

  /**
   * Output only. The threading state in the Chat space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceThreadingState;

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceType;

  /**
   * Output only. The URI for a user to access the space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaceUri;

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean threaded;

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. Specifies the [access setting](https://support.google.com/chat/answer/11971020) of
   * the space. Only populated when the `space_type` is `SPACE`.
   * @return value or {@code null} for none
   */
  public AccessSettings getAccessSettings() {
    return accessSettings;
  }

  /**
   * Optional. Specifies the [access setting](https://support.google.com/chat/answer/11971020) of
   * the space. Only populated when the `space_type` is `SPACE`.
   * @param accessSettings accessSettings or {@code null} for none
   */
  public Space setAccessSettings(AccessSettings accessSettings) {
    this.accessSettings = accessSettings;
    return this;
  }

  /**
   * Output only. For direct message (DM) spaces with a Chat app, whether the space was created by a
   * Google Workspace administrator. Administrators can install and set up a direct message with a
   * Chat app on behalf of users in their organization. To support admin install, your Chat app must
   * feature direct messaging.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminInstalled() {
    return adminInstalled;
  }

  /**
   * Output only. For direct message (DM) spaces with a Chat app, whether the space was created by a
   * Google Workspace administrator. Administrators can install and set up a direct message with a
   * Chat app on behalf of users in their organization. To support admin install, your Chat app must
   * feature direct messaging.
   * @param adminInstalled adminInstalled or {@code null} for none
   */
  public Space setAdminInstalled(java.lang.Boolean adminInstalled) {
    this.adminInstalled = adminInstalled;
    return this;
  }

  /**
   * Optional. Immutable. For spaces created in Chat, the time the space was created. This field is
   * output only, except when used in import mode spaces. For import mode spaces, set this field to
   * the historical timestamp at which the space was created in the source in order to preserve the
   * original creation time. Only populated in the output when `spaceType` is `GROUP_CHAT` or
   * `SPACE`.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Optional. Immutable. For spaces created in Chat, the time the space was created. This field is
   * output only, except when used in import mode spaces. For import mode spaces, set this field to
   * the historical timestamp at which the space was created in the source in order to preserve the
   * original creation time. Only populated in the output when `spaceType` is `GROUP_CHAT` or
   * `SPACE`.
   * @param createTime createTime or {@code null} for none
   */
  public Space setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create) with a
   * `spaceType` of `SPACE`. If you receive the error message `ALREADY_EXISTS` when creating a space
   * or updating the `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name. For direct messages, this
   * field might be empty. Supports up to 128 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The space's display name. Required when [creating a
   * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create) with a
   * `spaceType` of `SPACE`. If you receive the error message `ALREADY_EXISTS` when creating a space
   * or updating the `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name. For direct messages, this
   * field might be empty. Supports up to 128 characters.
   * @param displayName displayName or {@code null} for none
   */
  public Space setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. Omit this field when creating spaces in the following
   * conditions: * The authenticated user uses a consumer account (unmanaged user account). By
   * default, a space created by a consumer account permits any Google Chat user. For existing
   * spaces, this field is output only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExternalUserAllowed() {
    return externalUserAllowed;
  }

  /**
   * Immutable. Whether this space permits any Google Chat user as a member. Input when creating a
   * space in a Google Workspace organization. Omit this field when creating spaces in the following
   * conditions: * The authenticated user uses a consumer account (unmanaged user account). By
   * default, a space created by a consumer account permits any Google Chat user. For existing
   * spaces, this field is output only.
   * @param externalUserAllowed externalUserAllowed or {@code null} for none
   */
  public Space setExternalUserAllowed(java.lang.Boolean externalUserAllowed) {
    this.externalUserAllowed = externalUserAllowed;
    return this;
  }

  /**
   * Optional. Whether this space is created in `Import Mode` as part of a data migration into
   * Google Workspace. While spaces are being imported, they aren't visible to users until the
   * import is complete.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImportMode() {
    return importMode;
  }

  /**
   * Optional. Whether this space is created in `Import Mode` as part of a data migration into
   * Google Workspace. While spaces are being imported, they aren't visible to users until the
   * import is complete.
   * @param importMode importMode or {@code null} for none
   */
  public Space setImportMode(java.lang.Boolean importMode) {
    this.importMode = importMode;
    return this;
  }

  /**
   * Output only. Timestamp of the last message in the space.
   * @return value or {@code null} for none
   */
  public String getLastActiveTime() {
    return lastActiveTime;
  }

  /**
   * Output only. Timestamp of the last message in the space.
   * @param lastActiveTime lastActiveTime or {@code null} for none
   */
  public Space setLastActiveTime(String lastActiveTime) {
    this.lastActiveTime = lastActiveTime;
    return this;
  }

  /**
   * Output only. The count of joined memberships grouped by member type. Populated when the
   * `space_type` is `SPACE`, `DIRECT_MESSAGE` or `GROUP_CHAT`.
   * @return value or {@code null} for none
   */
  public MembershipCount getMembershipCount() {
    return membershipCount;
  }

  /**
   * Output only. The count of joined memberships grouped by member type. Populated when the
   * `space_type` is `SPACE`, `DIRECT_MESSAGE` or `GROUP_CHAT`.
   * @param membershipCount membershipCount or {@code null} for none
   */
  public Space setMembershipCount(MembershipCount membershipCount) {
    this.membershipCount = membershipCount;
    return this;
  }

  /**
   * Resource name of the space. Format: `spaces/{space}` Where `{space}` represents the system-
   * assigned ID for the space. You can obtain the space ID by calling the [`spaces.list()`](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list) method or from the
   * space URL. For example, if the space URL is
   * `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID is `AAAAAAAAA`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the space. Format: `spaces/{space}` Where `{space}` represents the system-
   * assigned ID for the space. You can obtain the space ID by calling the [`spaces.list()`](https:/
   * /developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list) method or from the
   * space URL. For example, if the space URL is
   * `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID is `AAAAAAAAA`.
   * @param name name or {@code null} for none
   */
  public Space setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSingleUserBotDm() {
    return singleUserBotDm;
  }

  /**
   * Optional. Whether the space is a DM between a Chat app and a single human.
   * @param singleUserBotDm singleUserBotDm or {@code null} for none
   */
  public Space setSingleUserBotDm(java.lang.Boolean singleUserBotDm) {
    this.singleUserBotDm = singleUserBotDm;
    return this;
  }

  /**
   * Details about the space including description and rules.
   * @return value or {@code null} for none
   */
  public SpaceDetails getSpaceDetails() {
    return spaceDetails;
  }

  /**
   * Details about the space including description and rules.
   * @param spaceDetails spaceDetails or {@code null} for none
   */
  public Space setSpaceDetails(SpaceDetails spaceDetails) {
    this.spaceDetails = spaceDetails;
    return this;
  }

  /**
   * The message history state for messages and threads in this space.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceHistoryState() {
    return spaceHistoryState;
  }

  /**
   * The message history state for messages and threads in this space.
   * @param spaceHistoryState spaceHistoryState or {@code null} for none
   */
  public Space setSpaceHistoryState(java.lang.String spaceHistoryState) {
    this.spaceHistoryState = spaceHistoryState;
    return this;
  }

  /**
   * Output only. The threading state in the Chat space.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceThreadingState() {
    return spaceThreadingState;
  }

  /**
   * Output only. The threading state in the Chat space.
   * @param spaceThreadingState spaceThreadingState or {@code null} for none
   */
  public Space setSpaceThreadingState(java.lang.String spaceThreadingState) {
    this.spaceThreadingState = spaceThreadingState;
    return this;
  }

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceType() {
    return spaceType;
  }

  /**
   * The type of space. Required when creating a space or updating the space type of a space. Output
   * only for other usage.
   * @param spaceType spaceType or {@code null} for none
   */
  public Space setSpaceType(java.lang.String spaceType) {
    this.spaceType = spaceType;
    return this;
  }

  /**
   * Output only. The URI for a user to access the space.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaceUri() {
    return spaceUri;
  }

  /**
   * Output only. The URI for a user to access the space.
   * @param spaceUri spaceUri or {@code null} for none
   */
  public Space setSpaceUri(java.lang.String spaceUri) {
    this.spaceUri = spaceUri;
    return this;
  }

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getThreaded() {
    return threaded;
  }

  /**
   * Output only. Deprecated: Use `spaceThreadingState` instead. Whether messages are threaded in
   * this space.
   * @param threaded threaded or {@code null} for none
   */
  public Space setThreaded(java.lang.Boolean threaded) {
    this.threaded = threaded;
    return this;
  }

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Deprecated: Use `space_type` instead. The type of a space.
   * @param type type or {@code null} for none
   */
  public Space setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Space set(String fieldName, Object value) {
    return (Space) super.set(fieldName, value);
  }

  @Override
  public Space clone() {
    return (Space) super.clone();
  }

}
