/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A widget is a UI element that presents text and images.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WidgetMarkup extends com.google.api.client.json.GenericJson {

  /**
   * A list of buttons. Buttons is also `oneof data` and only one of these fields should be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Button> buttons;

  static {
    // hack to force ProGuard to consider Button used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Button.class);
  }

  /**
   * Display an image in this widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * Display a key value item in this widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KeyValue keyValue;

  /**
   * Display a text paragraph in this widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextParagraph textParagraph;

  /**
   * A list of buttons. Buttons is also `oneof data` and only one of these fields should be set.
   * @return value or {@code null} for none
   */
  public java.util.List<Button> getButtons() {
    return buttons;
  }

  /**
   * A list of buttons. Buttons is also `oneof data` and only one of these fields should be set.
   * @param buttons buttons or {@code null} for none
   */
  public WidgetMarkup setButtons(java.util.List<Button> buttons) {
    this.buttons = buttons;
    return this;
  }

  /**
   * Display an image in this widget.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * Display an image in this widget.
   * @param image image or {@code null} for none
   */
  public WidgetMarkup setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * Display a key value item in this widget.
   * @return value or {@code null} for none
   */
  public KeyValue getKeyValue() {
    return keyValue;
  }

  /**
   * Display a key value item in this widget.
   * @param keyValue keyValue or {@code null} for none
   */
  public WidgetMarkup setKeyValue(KeyValue keyValue) {
    this.keyValue = keyValue;
    return this;
  }

  /**
   * Display a text paragraph in this widget.
   * @return value or {@code null} for none
   */
  public TextParagraph getTextParagraph() {
    return textParagraph;
  }

  /**
   * Display a text paragraph in this widget.
   * @param textParagraph textParagraph or {@code null} for none
   */
  public WidgetMarkup setTextParagraph(TextParagraph textParagraph) {
    this.textParagraph = textParagraph;
    return this;
  }

  @Override
  public WidgetMarkup set(String fieldName, Object value) {
    return (WidgetMarkup) super.set(fieldName, value);
  }

  @Override
  public WidgetMarkup clone() {
    return (WidgetMarkup) super.clone();
  }

}
