/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A text, icon, or text and icon chip that users can click. [Google Chat
 * apps](https://developers.google.com/workspace/chat):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Chip extends com.google.api.client.json.GenericJson {

  /**
   * The alternative text that's used for accessibility. Set descriptive text that lets users know
   * what the chip does. For example, if a chip opens a hyperlink, write: "Opens a new browser tab
   * and navigates to the Google Chat developer documentation at
   * https://developers.google.com/workspace/chat".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altText;

  /**
   * Whether the chip is in an inactive state and ignores user actions. Defaults to `false`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Whether the chip is in an active state and responds to user actions. Defaults to `true`.
   * Deprecated. Use `disabled` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * The icon image. If both `icon` and `text` are set, then the icon appears before the text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon icon;

  /**
   * The text displayed inside the chip.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Optional. The action to perform when a user clicks the chip, such as opening a hyperlink or
   * running a custom function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The alternative text that's used for accessibility. Set descriptive text that lets users know
   * what the chip does. For example, if a chip opens a hyperlink, write: "Opens a new browser tab
   * and navigates to the Google Chat developer documentation at
   * https://developers.google.com/workspace/chat".
   * @return value or {@code null} for none
   */
  public java.lang.String getAltText() {
    return altText;
  }

  /**
   * The alternative text that's used for accessibility. Set descriptive text that lets users know
   * what the chip does. For example, if a chip opens a hyperlink, write: "Opens a new browser tab
   * and navigates to the Google Chat developer documentation at
   * https://developers.google.com/workspace/chat".
   * @param altText altText or {@code null} for none
   */
  public GoogleAppsCardV1Chip setAltText(java.lang.String altText) {
    this.altText = altText;
    return this;
  }

  /**
   * Whether the chip is in an inactive state and ignores user actions. Defaults to `false`.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Whether the chip is in an inactive state and ignores user actions. Defaults to `false`.
   * @param disabled disabled or {@code null} for none
   */
  public GoogleAppsCardV1Chip setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Whether the chip is in an active state and responds to user actions. Defaults to `true`.
   * Deprecated. Use `disabled` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether the chip is in an active state and responds to user actions. Defaults to `true`.
   * Deprecated. Use `disabled` instead.
   * @param enabled enabled or {@code null} for none
   */
  public GoogleAppsCardV1Chip setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * The icon image. If both `icon` and `text` are set, then the icon appears before the text.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getIcon() {
    return icon;
  }

  /**
   * The icon image. If both `icon` and `text` are set, then the icon appears before the text.
   * @param icon icon or {@code null} for none
   */
  public GoogleAppsCardV1Chip setIcon(GoogleAppsCardV1Icon icon) {
    this.icon = icon;
    return this;
  }

  /**
   * The text displayed inside the chip.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The text displayed inside the chip.
   * @param label label or {@code null} for none
   */
  public GoogleAppsCardV1Chip setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Optional. The action to perform when a user clicks the chip, such as opening a hyperlink or
   * running a custom function.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * Optional. The action to perform when a user clicks the chip, such as opening a hyperlink or
   * running a custom function.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1Chip setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  @Override
  public GoogleAppsCardV1Chip set(String fieldName, Object value) {
    return (GoogleAppsCardV1Chip) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Chip clone() {
    return (GoogleAppsCardV1Chip) super.clone();
  }

}
