/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represents a space permission setting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PermissionSetting extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Whether spaces managers have this permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean managersAllowed;

  /**
   * Optional. Whether non-manager members have this permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean membersAllowed;

  /**
   * Optional. Whether spaces managers have this permission.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getManagersAllowed() {
    return managersAllowed;
  }

  /**
   * Optional. Whether spaces managers have this permission.
   * @param managersAllowed managersAllowed or {@code null} for none
   */
  public PermissionSetting setManagersAllowed(java.lang.Boolean managersAllowed) {
    this.managersAllowed = managersAllowed;
    return this;
  }

  /**
   * Optional. Whether non-manager members have this permission.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMembersAllowed() {
    return membersAllowed;
  }

  /**
   * Optional. Whether non-manager members have this permission.
   * @param membersAllowed membersAllowed or {@code null} for none
   */
  public PermissionSetting setMembersAllowed(java.lang.Boolean membersAllowed) {
    this.membersAllowed = membersAllowed;
    return this;
  }

  @Override
  public PermissionSetting set(String fieldName, Object value) {
    return (PermissionSetting) super.set(fieldName, value);
  }

  @Override
  public PermissionSetting clone() {
    return (PermissionSetting) super.clone();
  }

}
