/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.chat.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.chat.v1.HangoutsChatRequest;
import com.google.api.services.chat.v1.HangoutsChatRequestInitializer;
import com.google.api.services.chat.v1.model.Attachment;
import com.google.api.services.chat.v1.model.CompleteImportSpaceRequest;
import com.google.api.services.chat.v1.model.CompleteImportSpaceResponse;
import com.google.api.services.chat.v1.model.Empty;
import com.google.api.services.chat.v1.model.ListMembershipsResponse;
import com.google.api.services.chat.v1.model.ListMessagesResponse;
import com.google.api.services.chat.v1.model.ListReactionsResponse;
import com.google.api.services.chat.v1.model.ListSpaceEventsResponse;
import com.google.api.services.chat.v1.model.ListSpacesResponse;
import com.google.api.services.chat.v1.model.Membership;
import com.google.api.services.chat.v1.model.Message;
import com.google.api.services.chat.v1.model.Reaction;
import com.google.api.services.chat.v1.model.SearchSpacesResponse;
import com.google.api.services.chat.v1.model.SetUpSpaceRequest;
import com.google.api.services.chat.v1.model.Space;
import com.google.api.services.chat.v1.model.SpaceEvent;
import com.google.api.services.chat.v1.model.SpaceReadState;
import com.google.api.services.chat.v1.model.ThreadReadState;
import com.google.api.services.chat.v1.model.UploadAttachmentRequest;
import com.google.api.services.chat.v1.model.UploadAttachmentResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class HangoutsChat
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://chat.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://chat.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://chat.googleapis.com/";

    public HangoutsChat(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    HangoutsChat(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Media media() {
        return new Media();
    }

    public Spaces spaces() {
        return new Spaces();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Chat API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return HangoutsChat.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://chat.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), HangoutsChat.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(HangoutsChat.DEFAULT_BATCH_PATH);
        }

        public HangoutsChat build() {
            return new HangoutsChat(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setHangoutsChatRequestInitializer(HangoutsChatRequestInitializer hangoutschatRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)hangoutschatRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Users {
        public Spaces spaces() {
            return new Spaces();
        }

        public class Spaces {
            public GetSpaceReadState getSpaceReadState(String name) throws IOException {
                GetSpaceReadState result = new GetSpaceReadState(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateSpaceReadState updateSpaceReadState(String name, SpaceReadState content) throws IOException {
                UpdateSpaceReadState result = new UpdateSpaceReadState(name, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Threads threads() {
                return new Threads();
            }

            public class Threads {
                public GetThreadReadState getThreadReadState(String name) throws IOException {
                    GetThreadReadState result = new GetThreadReadState(name);
                    HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class GetThreadReadState
                extends HangoutsChatRequest<ThreadReadState> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected GetThreadReadState(String name) {
                        super(HangoutsChat.this, "GET", REST_PATH, null, ThreadReadState.class);
                        this.NAME_PATTERN = Pattern.compile("^users/[^/]+/spaces/[^/]+/threads/[^/]+/threadReadState$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/threads/[^/]+/threadReadState$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetThreadReadState set$Xgafv(String $Xgafv) {
                        return (GetThreadReadState)super.set$Xgafv($Xgafv);
                    }

                    public GetThreadReadState setAccessToken(String accessToken) {
                        return (GetThreadReadState)super.setAccessToken(accessToken);
                    }

                    public GetThreadReadState setAlt(String alt) {
                        return (GetThreadReadState)super.setAlt(alt);
                    }

                    public GetThreadReadState setCallback(String callback) {
                        return (GetThreadReadState)super.setCallback(callback);
                    }

                    public GetThreadReadState setFields(String fields) {
                        return (GetThreadReadState)super.setFields(fields);
                    }

                    public GetThreadReadState setKey(String key) {
                        return (GetThreadReadState)super.setKey(key);
                    }

                    public GetThreadReadState setOauthToken(String oauthToken) {
                        return (GetThreadReadState)super.setOauthToken(oauthToken);
                    }

                    public GetThreadReadState setPrettyPrint(Boolean prettyPrint) {
                        return (GetThreadReadState)super.setPrettyPrint(prettyPrint);
                    }

                    public GetThreadReadState setQuotaUser(String quotaUser) {
                        return (GetThreadReadState)super.setQuotaUser(quotaUser);
                    }

                    public GetThreadReadState setUploadType(String uploadType) {
                        return (GetThreadReadState)super.setUploadType(uploadType);
                    }

                    public GetThreadReadState setUploadProtocol(String uploadProtocol) {
                        return (GetThreadReadState)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GetThreadReadState setName(String name) {
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/threads/[^/]+/threadReadState$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public GetThreadReadState set(String parameterName, Object value) {
                        return (GetThreadReadState)super.set(parameterName, value);
                    }
                }
            }

            public class UpdateSpaceReadState
            extends HangoutsChatRequest<SpaceReadState> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateSpaceReadState(String name, SpaceReadState content) {
                    super(HangoutsChat.this, "PATCH", REST_PATH, (Object)content, SpaceReadState.class);
                    this.NAME_PATTERN = Pattern.compile("^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    }
                }

                public UpdateSpaceReadState set$Xgafv(String $Xgafv) {
                    return (UpdateSpaceReadState)super.set$Xgafv($Xgafv);
                }

                public UpdateSpaceReadState setAccessToken(String accessToken) {
                    return (UpdateSpaceReadState)super.setAccessToken(accessToken);
                }

                public UpdateSpaceReadState setAlt(String alt) {
                    return (UpdateSpaceReadState)super.setAlt(alt);
                }

                public UpdateSpaceReadState setCallback(String callback) {
                    return (UpdateSpaceReadState)super.setCallback(callback);
                }

                public UpdateSpaceReadState setFields(String fields) {
                    return (UpdateSpaceReadState)super.setFields(fields);
                }

                public UpdateSpaceReadState setKey(String key) {
                    return (UpdateSpaceReadState)super.setKey(key);
                }

                public UpdateSpaceReadState setOauthToken(String oauthToken) {
                    return (UpdateSpaceReadState)super.setOauthToken(oauthToken);
                }

                public UpdateSpaceReadState setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateSpaceReadState)super.setPrettyPrint(prettyPrint);
                }

                public UpdateSpaceReadState setQuotaUser(String quotaUser) {
                    return (UpdateSpaceReadState)super.setQuotaUser(quotaUser);
                }

                public UpdateSpaceReadState setUploadType(String uploadType) {
                    return (UpdateSpaceReadState)super.setUploadType(uploadType);
                }

                public UpdateSpaceReadState setUploadProtocol(String uploadProtocol) {
                    return (UpdateSpaceReadState)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateSpaceReadState setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateSpaceReadState setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateSpaceReadState set(String parameterName, Object value) {
                    return (UpdateSpaceReadState)super.set(parameterName, value);
                }
            }

            public class GetSpaceReadState
            extends HangoutsChatRequest<SpaceReadState> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetSpaceReadState(String name) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, SpaceReadState.class);
                    this.NAME_PATTERN = Pattern.compile("^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetSpaceReadState set$Xgafv(String $Xgafv) {
                    return (GetSpaceReadState)super.set$Xgafv($Xgafv);
                }

                public GetSpaceReadState setAccessToken(String accessToken) {
                    return (GetSpaceReadState)super.setAccessToken(accessToken);
                }

                public GetSpaceReadState setAlt(String alt) {
                    return (GetSpaceReadState)super.setAlt(alt);
                }

                public GetSpaceReadState setCallback(String callback) {
                    return (GetSpaceReadState)super.setCallback(callback);
                }

                public GetSpaceReadState setFields(String fields) {
                    return (GetSpaceReadState)super.setFields(fields);
                }

                public GetSpaceReadState setKey(String key) {
                    return (GetSpaceReadState)super.setKey(key);
                }

                public GetSpaceReadState setOauthToken(String oauthToken) {
                    return (GetSpaceReadState)super.setOauthToken(oauthToken);
                }

                public GetSpaceReadState setPrettyPrint(Boolean prettyPrint) {
                    return (GetSpaceReadState)super.setPrettyPrint(prettyPrint);
                }

                public GetSpaceReadState setQuotaUser(String quotaUser) {
                    return (GetSpaceReadState)super.setQuotaUser(quotaUser);
                }

                public GetSpaceReadState setUploadType(String uploadType) {
                    return (GetSpaceReadState)super.setUploadType(uploadType);
                }

                public GetSpaceReadState setUploadProtocol(String uploadProtocol) {
                    return (GetSpaceReadState)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetSpaceReadState setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^users/[^/]+/spaces/[^/]+/spaceReadState$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetSpaceReadState set(String parameterName, Object value) {
                    return (GetSpaceReadState)super.set(parameterName, value);
                }
            }
        }
    }

    public class Spaces {
        public CompleteImport completeImport(String name, CompleteImportSpaceRequest content) throws IOException {
            CompleteImport result = new CompleteImport(name, content);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Space content) throws IOException {
            Create result = new Create(content);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public FindDirectMessage findDirectMessage() throws IOException {
            FindDirectMessage result = new FindDirectMessage();
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, Space content) throws IOException {
            Patch result = new Patch(name, content);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search() throws IOException {
            Search result = new Search();
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setup setup(SetUpSpaceRequest content) throws IOException {
            Setup result = new Setup(content);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Members members() {
            return new Members();
        }

        public Messages messages() {
            return new Messages();
        }

        public SpaceEvents spaceEvents() {
            return new SpaceEvents();
        }

        public class SpaceEvents {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends HangoutsChatRequest<ListSpaceEventsResponse> {
                private static final String REST_PATH = "v1/{+parent}/spaceEvents";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, ListSpaceEventsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends HangoutsChatRequest<SpaceEvent> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, SpaceEvent.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/spaceEvents/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/spaceEvents/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/spaceEvents/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Messages {
            public Create create(String parent, Message content) throws IOException {
                Create result = new Create(parent, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Message content) throws IOException {
                Patch result = new Patch(name, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String name, Message content) throws IOException {
                Update result = new Update(name, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Attachments attachments() {
                return new Attachments();
            }

            public Reactions reactions() {
                return new Reactions();
            }

            public class Reactions {
                public Create create(String parent, Reaction content) throws IOException {
                    Create result = new Create(parent, content);
                    HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends HangoutsChatRequest<ListReactionsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/reactions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(HangoutsChat.this, "GET", REST_PATH, null, ListReactionsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends HangoutsChatRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(HangoutsChat.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+/reactions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends HangoutsChatRequest<Reaction> {
                    private static final String REST_PATH = "v1/{+parent}/reactions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Reaction content) {
                        super(HangoutsChat.this, "POST", REST_PATH, (Object)content, Reaction.class);
                        this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Attachments {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends HangoutsChatRequest<Attachment> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(HangoutsChat.this, "GET", REST_PATH, null, Attachment.class);
                        this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!HangoutsChat.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+/attachments/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends HangoutsChatRequest<Message> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean allowMissing;
                @Key
                private String updateMask;

                protected Update(String name, Message content) {
                    super(HangoutsChat.this, "PUT", REST_PATH, (Object)content, Message.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getAllowMissing() {
                    return this.allowMissing;
                }

                public Update setAllowMissing(Boolean allowMissing) {
                    this.allowMissing = allowMissing;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Update setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends HangoutsChatRequest<Message> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean allowMissing;
                @Key
                private String updateMask;

                protected Patch(String name, Message content) {
                    super(HangoutsChat.this, "PATCH", REST_PATH, (Object)content, Message.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getAllowMissing() {
                    return this.allowMissing;
                }

                public Patch setAllowMissing(Boolean allowMissing) {
                    this.allowMissing = allowMissing;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends HangoutsChatRequest<ListMessagesResponse> {
                private static final String REST_PATH = "v1/{+parent}/messages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Boolean showDeleted;

                protected List(String parent) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, ListMessagesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean showDeleted) {
                    this.showDeleted = showDeleted;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends HangoutsChatRequest<Message> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, Message.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends HangoutsChatRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean force;

                protected Delete(String name) {
                    super(HangoutsChat.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/messages/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/messages/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getForce() {
                    return this.force;
                }

                public Delete setForce(Boolean force) {
                    this.force = force;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends HangoutsChatRequest<Message> {
                private static final String REST_PATH = "v1/{+parent}/messages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String messageId;
                @Key
                private String messageReplyOption;
                @Key
                private String requestId;
                @Key
                private String threadKey;

                protected Create(String parent, Message content) {
                    super(HangoutsChat.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getMessageId() {
                    return this.messageId;
                }

                public Create setMessageId(String messageId) {
                    this.messageId = messageId;
                    return this;
                }

                public String getMessageReplyOption() {
                    return this.messageReplyOption;
                }

                public Create setMessageReplyOption(String messageReplyOption) {
                    this.messageReplyOption = messageReplyOption;
                    return this;
                }

                public String getRequestId() {
                    return this.requestId;
                }

                public Create setRequestId(String requestId) {
                    this.requestId = requestId;
                    return this;
                }

                public String getThreadKey() {
                    return this.threadKey;
                }

                public Create setThreadKey(String threadKey) {
                    this.threadKey = threadKey;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Members {
            public Create create(String parent, Membership content) throws IOException {
                Create result = new Create(parent, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Membership content) throws IOException {
                Patch result = new Patch(name, content);
                HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends HangoutsChatRequest<Membership> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;
                @Key
                private Boolean useAdminAccess;

                protected Patch(String name, Membership content) {
                    super(HangoutsChat.this, "PATCH", REST_PATH, (Object)content, Membership.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/members/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                public Boolean getUseAdminAccess() {
                    return this.useAdminAccess;
                }

                public Patch setUseAdminAccess(Boolean useAdminAccess) {
                    this.useAdminAccess = useAdminAccess;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends HangoutsChatRequest<ListMembershipsResponse> {
                private static final String REST_PATH = "v1/{+parent}/members";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Boolean showGroups;
                @Key
                private Boolean showInvited;
                @Key
                private Boolean useAdminAccess;

                protected List(String parent) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, ListMembershipsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowGroups() {
                    return this.showGroups;
                }

                public List setShowGroups(Boolean showGroups) {
                    this.showGroups = showGroups;
                    return this;
                }

                public Boolean getShowInvited() {
                    return this.showInvited;
                }

                public List setShowInvited(Boolean showInvited) {
                    this.showInvited = showInvited;
                    return this;
                }

                public Boolean getUseAdminAccess() {
                    return this.useAdminAccess;
                }

                public List setUseAdminAccess(Boolean useAdminAccess) {
                    this.useAdminAccess = useAdminAccess;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends HangoutsChatRequest<Membership> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean useAdminAccess;

                protected Get(String name) {
                    super(HangoutsChat.this, "GET", REST_PATH, null, Membership.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/members/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getUseAdminAccess() {
                    return this.useAdminAccess;
                }

                public Get setUseAdminAccess(Boolean useAdminAccess) {
                    this.useAdminAccess = useAdminAccess;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends HangoutsChatRequest<Membership> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean useAdminAccess;

                protected Delete(String name) {
                    super(HangoutsChat.this, "DELETE", REST_PATH, null, Membership.class);
                    this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+/members/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+/members/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getUseAdminAccess() {
                    return this.useAdminAccess;
                }

                public Delete setUseAdminAccess(Boolean useAdminAccess) {
                    this.useAdminAccess = useAdminAccess;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends HangoutsChatRequest<Membership> {
                private static final String REST_PATH = "v1/{+parent}/members";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean useAdminAccess;

                protected Create(String parent, Membership content) {
                    super(HangoutsChat.this, "POST", REST_PATH, (Object)content, Membership.class);
                    this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!HangoutsChat.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getUseAdminAccess() {
                    return this.useAdminAccess;
                }

                public Create setUseAdminAccess(Boolean useAdminAccess) {
                    this.useAdminAccess = useAdminAccess;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Setup
        extends HangoutsChatRequest<Space> {
            private static final String REST_PATH = "v1/spaces:setup";

            protected Setup(SetUpSpaceRequest content) {
                super(HangoutsChat.this, "POST", REST_PATH, (Object)content, Space.class);
            }

            public Setup set$Xgafv(String $Xgafv) {
                return (Setup)super.set$Xgafv($Xgafv);
            }

            public Setup setAccessToken(String accessToken) {
                return (Setup)super.setAccessToken(accessToken);
            }

            public Setup setAlt(String alt) {
                return (Setup)super.setAlt(alt);
            }

            public Setup setCallback(String callback) {
                return (Setup)super.setCallback(callback);
            }

            public Setup setFields(String fields) {
                return (Setup)super.setFields(fields);
            }

            public Setup setKey(String key) {
                return (Setup)super.setKey(key);
            }

            public Setup setOauthToken(String oauthToken) {
                return (Setup)super.setOauthToken(oauthToken);
            }

            public Setup setPrettyPrint(Boolean prettyPrint) {
                return (Setup)super.setPrettyPrint(prettyPrint);
            }

            public Setup setQuotaUser(String quotaUser) {
                return (Setup)super.setQuotaUser(quotaUser);
            }

            public Setup setUploadType(String uploadType) {
                return (Setup)super.setUploadType(uploadType);
            }

            public Setup setUploadProtocol(String uploadProtocol) {
                return (Setup)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Setup set(String parameterName, Object value) {
                return (Setup)super.set(parameterName, value);
            }
        }

        public class Search
        extends HangoutsChatRequest<SearchSpacesResponse> {
            private static final String REST_PATH = "v1/spaces:search";
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private Boolean useAdminAccess;

            protected Search() {
                super(HangoutsChat.this, "GET", REST_PATH, null, SearchSpacesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Search setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public Boolean getUseAdminAccess() {
                return this.useAdminAccess;
            }

            public Search setUseAdminAccess(Boolean useAdminAccess) {
                this.useAdminAccess = useAdminAccess;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class Patch
        extends HangoutsChatRequest<Space> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;
            @Key
            private Boolean useAdminAccess;

            protected Patch(String name, Space content) {
                super(HangoutsChat.this, "PATCH", REST_PATH, (Object)content, Space.class);
                this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            public Boolean getUseAdminAccess() {
                return this.useAdminAccess;
            }

            public Patch setUseAdminAccess(Boolean useAdminAccess) {
                this.useAdminAccess = useAdminAccess;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends HangoutsChatRequest<ListSpacesResponse> {
            private static final String REST_PATH = "v1/spaces";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(HangoutsChat.this, "GET", REST_PATH, null, ListSpacesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends HangoutsChatRequest<Space> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private Boolean useAdminAccess;

            protected Get(String name) {
                super(HangoutsChat.this, "GET", REST_PATH, null, Space.class);
                this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public Boolean getUseAdminAccess() {
                return this.useAdminAccess;
            }

            public Get setUseAdminAccess(Boolean useAdminAccess) {
                this.useAdminAccess = useAdminAccess;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class FindDirectMessage
        extends HangoutsChatRequest<Space> {
            private static final String REST_PATH = "v1/spaces:findDirectMessage";
            @Key
            private String name;

            protected FindDirectMessage() {
                super(HangoutsChat.this, "GET", REST_PATH, null, Space.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public FindDirectMessage set$Xgafv(String $Xgafv) {
                return (FindDirectMessage)super.set$Xgafv($Xgafv);
            }

            public FindDirectMessage setAccessToken(String accessToken) {
                return (FindDirectMessage)super.setAccessToken(accessToken);
            }

            public FindDirectMessage setAlt(String alt) {
                return (FindDirectMessage)super.setAlt(alt);
            }

            public FindDirectMessage setCallback(String callback) {
                return (FindDirectMessage)super.setCallback(callback);
            }

            public FindDirectMessage setFields(String fields) {
                return (FindDirectMessage)super.setFields(fields);
            }

            public FindDirectMessage setKey(String key) {
                return (FindDirectMessage)super.setKey(key);
            }

            public FindDirectMessage setOauthToken(String oauthToken) {
                return (FindDirectMessage)super.setOauthToken(oauthToken);
            }

            public FindDirectMessage setPrettyPrint(Boolean prettyPrint) {
                return (FindDirectMessage)super.setPrettyPrint(prettyPrint);
            }

            public FindDirectMessage setQuotaUser(String quotaUser) {
                return (FindDirectMessage)super.setQuotaUser(quotaUser);
            }

            public FindDirectMessage setUploadType(String uploadType) {
                return (FindDirectMessage)super.setUploadType(uploadType);
            }

            public FindDirectMessage setUploadProtocol(String uploadProtocol) {
                return (FindDirectMessage)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public FindDirectMessage setName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public FindDirectMessage set(String parameterName, Object value) {
                return (FindDirectMessage)super.set(parameterName, value);
            }
        }

        public class Delete
        extends HangoutsChatRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private Boolean useAdminAccess;

            protected Delete(String name) {
                super(HangoutsChat.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public Boolean getUseAdminAccess() {
                return this.useAdminAccess;
            }

            public Delete setUseAdminAccess(Boolean useAdminAccess) {
                this.useAdminAccess = useAdminAccess;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends HangoutsChatRequest<Space> {
            private static final String REST_PATH = "v1/spaces";
            @Key
            private String requestId;

            protected Create(Space content) {
                super(HangoutsChat.this, "POST", REST_PATH, (Object)content, Space.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Create setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class CompleteImport
        extends HangoutsChatRequest<CompleteImportSpaceResponse> {
            private static final String REST_PATH = "v1/{+name}:completeImport";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected CompleteImport(String name, CompleteImportSpaceRequest content) {
                super(HangoutsChat.this, "POST", REST_PATH, (Object)content, CompleteImportSpaceResponse.class);
                this.NAME_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
            }

            public CompleteImport set$Xgafv(String $Xgafv) {
                return (CompleteImport)super.set$Xgafv($Xgafv);
            }

            public CompleteImport setAccessToken(String accessToken) {
                return (CompleteImport)super.setAccessToken(accessToken);
            }

            public CompleteImport setAlt(String alt) {
                return (CompleteImport)super.setAlt(alt);
            }

            public CompleteImport setCallback(String callback) {
                return (CompleteImport)super.setCallback(callback);
            }

            public CompleteImport setFields(String fields) {
                return (CompleteImport)super.setFields(fields);
            }

            public CompleteImport setKey(String key) {
                return (CompleteImport)super.setKey(key);
            }

            public CompleteImport setOauthToken(String oauthToken) {
                return (CompleteImport)super.setOauthToken(oauthToken);
            }

            public CompleteImport setPrettyPrint(Boolean prettyPrint) {
                return (CompleteImport)super.setPrettyPrint(prettyPrint);
            }

            public CompleteImport setQuotaUser(String quotaUser) {
                return (CompleteImport)super.setQuotaUser(quotaUser);
            }

            public CompleteImport setUploadType(String uploadType) {
                return (CompleteImport)super.setUploadType(uploadType);
            }

            public CompleteImport setUploadProtocol(String uploadProtocol) {
                return (CompleteImport)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public CompleteImport setName(String name) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^spaces/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public CompleteImport set(String parameterName, Object value) {
                return (CompleteImport)super.set(parameterName, value);
            }
        }
    }

    public class Media {
        public Download download(String resourceName) throws IOException {
            Download result = new Download(resourceName);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String parent, UploadAttachmentRequest content) throws IOException {
            Upload result = new Upload(parent, content);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String parent, UploadAttachmentRequest content, AbstractInputStreamContent mediaContent) throws IOException {
            Upload result = new Upload(parent, content, mediaContent);
            HangoutsChat.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Upload
        extends HangoutsChatRequest<UploadAttachmentResponse> {
            private static final String REST_PATH = "v1/{+parent}/attachments:upload";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected Upload(String parent, UploadAttachmentRequest content) {
                super(HangoutsChat.this, "POST", REST_PATH, (Object)content, UploadAttachmentResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                }
            }

            protected Upload(String parent, UploadAttachmentRequest content, AbstractInputStreamContent mediaContent) {
                super(HangoutsChat.this, "POST", "/upload/" + HangoutsChat.this.getServicePath() + REST_PATH, (Object)content, UploadAttachmentResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^spaces/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Upload set$Xgafv(String $Xgafv) {
                return (Upload)super.set$Xgafv($Xgafv);
            }

            public Upload setAccessToken(String accessToken) {
                return (Upload)super.setAccessToken(accessToken);
            }

            public Upload setAlt(String alt) {
                return (Upload)super.setAlt(alt);
            }

            public Upload setCallback(String callback) {
                return (Upload)super.setCallback(callback);
            }

            public Upload setFields(String fields) {
                return (Upload)super.setFields(fields);
            }

            public Upload setKey(String key) {
                return (Upload)super.setKey(key);
            }

            public Upload setOauthToken(String oauthToken) {
                return (Upload)super.setOauthToken(oauthToken);
            }

            public Upload setPrettyPrint(Boolean prettyPrint) {
                return (Upload)super.setPrettyPrint(prettyPrint);
            }

            public Upload setQuotaUser(String quotaUser) {
                return (Upload)super.setQuotaUser(quotaUser);
            }

            public Upload setUploadType(String uploadType) {
                return (Upload)super.setUploadType(uploadType);
            }

            public Upload setUploadProtocol(String uploadProtocol) {
                return (Upload)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Upload setParent(String parent) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^spaces/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public Upload set(String parameterName, Object value) {
                return (Upload)super.set(parameterName, value);
            }
        }

        public class Download
        extends HangoutsChatRequest<com.google.api.services.chat.v1.model.Media> {
            private static final String REST_PATH = "v1/media/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String resourceName) {
                super(HangoutsChat.this, "GET", REST_PATH, null, com.google.api.services.chat.v1.model.Media.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String resourceName) {
                if (!HangoutsChat.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }
}

