/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * [Developer Preview](https://developers.google.com/workspace/preview): A card that can be
 * displayed as a carousel item. [Google Chat apps](https://developers.google.com/workspace/chat):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1CarouselCard extends com.google.api.client.json.GenericJson {

  /**
   * A list of widgets displayed at the bottom of the carousel card. The widgets are displayed in
   * the order that they are specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1NestedWidget> footerWidgets;

  /**
   * A list of widgets displayed in the carousel card. The widgets are displayed in the order that
   * they are specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1NestedWidget> widgets;

  /**
   * A list of widgets displayed at the bottom of the carousel card. The widgets are displayed in
   * the order that they are specified.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1NestedWidget> getFooterWidgets() {
    return footerWidgets;
  }

  /**
   * A list of widgets displayed at the bottom of the carousel card. The widgets are displayed in
   * the order that they are specified.
   * @param footerWidgets footerWidgets or {@code null} for none
   */
  public GoogleAppsCardV1CarouselCard setFooterWidgets(java.util.List<GoogleAppsCardV1NestedWidget> footerWidgets) {
    this.footerWidgets = footerWidgets;
    return this;
  }

  /**
   * A list of widgets displayed in the carousel card. The widgets are displayed in the order that
   * they are specified.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1NestedWidget> getWidgets() {
    return widgets;
  }

  /**
   * A list of widgets displayed in the carousel card. The widgets are displayed in the order that
   * they are specified.
   * @param widgets widgets or {@code null} for none
   */
  public GoogleAppsCardV1CarouselCard setWidgets(java.util.List<GoogleAppsCardV1NestedWidget> widgets) {
    this.widgets = widgets;
    return this;
  }

  @Override
  public GoogleAppsCardV1CarouselCard set(String fieldName, Object value) {
    return (GoogleAppsCardV1CarouselCard) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1CarouselCard clone() {
    return (GoogleAppsCardV1CarouselCard) super.clone();
  }

}
