/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * [Permission settings](https://support.google.com/chat/answer/13340792) that you can specify when
 * updating an existing named space. To set permission settings when creating a space, specify the
 * `PredefinedPermissionSettings` field in your request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PermissionSettings extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Setting for managing apps in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting manageApps;

  /**
   * Optional. Setting for managing members and groups in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting manageMembersAndGroups;

  /**
   * Optional. Setting for managing webhooks in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting manageWebhooks;

  /**
   * Optional. Setting for updating space name, avatar, description and guidelines.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting modifySpaceDetails;

  /**
   * Output only. Setting for posting messages in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting postMessages;

  /**
   * Optional. Setting for replying to messages in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting replyMessages;

  /**
   * Optional. Setting for toggling space history on and off.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting toggleHistory;

  /**
   * Optional. Setting for using @all in a space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionSetting useAtMentionAll;

  /**
   * Optional. Setting for managing apps in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getManageApps() {
    return manageApps;
  }

  /**
   * Optional. Setting for managing apps in a space.
   * @param manageApps manageApps or {@code null} for none
   */
  public PermissionSettings setManageApps(PermissionSetting manageApps) {
    this.manageApps = manageApps;
    return this;
  }

  /**
   * Optional. Setting for managing members and groups in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getManageMembersAndGroups() {
    return manageMembersAndGroups;
  }

  /**
   * Optional. Setting for managing members and groups in a space.
   * @param manageMembersAndGroups manageMembersAndGroups or {@code null} for none
   */
  public PermissionSettings setManageMembersAndGroups(PermissionSetting manageMembersAndGroups) {
    this.manageMembersAndGroups = manageMembersAndGroups;
    return this;
  }

  /**
   * Optional. Setting for managing webhooks in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getManageWebhooks() {
    return manageWebhooks;
  }

  /**
   * Optional. Setting for managing webhooks in a space.
   * @param manageWebhooks manageWebhooks or {@code null} for none
   */
  public PermissionSettings setManageWebhooks(PermissionSetting manageWebhooks) {
    this.manageWebhooks = manageWebhooks;
    return this;
  }

  /**
   * Optional. Setting for updating space name, avatar, description and guidelines.
   * @return value or {@code null} for none
   */
  public PermissionSetting getModifySpaceDetails() {
    return modifySpaceDetails;
  }

  /**
   * Optional. Setting for updating space name, avatar, description and guidelines.
   * @param modifySpaceDetails modifySpaceDetails or {@code null} for none
   */
  public PermissionSettings setModifySpaceDetails(PermissionSetting modifySpaceDetails) {
    this.modifySpaceDetails = modifySpaceDetails;
    return this;
  }

  /**
   * Output only. Setting for posting messages in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getPostMessages() {
    return postMessages;
  }

  /**
   * Output only. Setting for posting messages in a space.
   * @param postMessages postMessages or {@code null} for none
   */
  public PermissionSettings setPostMessages(PermissionSetting postMessages) {
    this.postMessages = postMessages;
    return this;
  }

  /**
   * Optional. Setting for replying to messages in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getReplyMessages() {
    return replyMessages;
  }

  /**
   * Optional. Setting for replying to messages in a space.
   * @param replyMessages replyMessages or {@code null} for none
   */
  public PermissionSettings setReplyMessages(PermissionSetting replyMessages) {
    this.replyMessages = replyMessages;
    return this;
  }

  /**
   * Optional. Setting for toggling space history on and off.
   * @return value or {@code null} for none
   */
  public PermissionSetting getToggleHistory() {
    return toggleHistory;
  }

  /**
   * Optional. Setting for toggling space history on and off.
   * @param toggleHistory toggleHistory or {@code null} for none
   */
  public PermissionSettings setToggleHistory(PermissionSetting toggleHistory) {
    this.toggleHistory = toggleHistory;
    return this;
  }

  /**
   * Optional. Setting for using @all in a space.
   * @return value or {@code null} for none
   */
  public PermissionSetting getUseAtMentionAll() {
    return useAtMentionAll;
  }

  /**
   * Optional. Setting for using @all in a space.
   * @param useAtMentionAll useAtMentionAll or {@code null} for none
   */
  public PermissionSettings setUseAtMentionAll(PermissionSetting useAtMentionAll) {
    this.useAtMentionAll = useAtMentionAll;
    return this;
  }

  @Override
  public PermissionSettings set(String fieldName, Object value) {
    return (PermissionSettings) super.set(fieldName, value);
  }

  @Override
  public PermissionSettings clone() {
    return (PermissionSettings) super.clone();
  }

}
