/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Information about a quoted message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QuotedMessageMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The timestamp when the quoted message was created or when the quoted message was
   * last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastUpdateTime;

  /**
   * Output only. Resource name of the quoted message. Format: `spaces/{space}/messages/{message}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The timestamp when the quoted message was created or when the quoted message was
   * last updated.
   * @return value or {@code null} for none
   */
  public String getLastUpdateTime() {
    return lastUpdateTime;
  }

  /**
   * Output only. The timestamp when the quoted message was created or when the quoted message was
   * last updated.
   * @param lastUpdateTime lastUpdateTime or {@code null} for none
   */
  public QuotedMessageMetadata setLastUpdateTime(String lastUpdateTime) {
    this.lastUpdateTime = lastUpdateTime;
    return this;
  }

  /**
   * Output only. Resource name of the quoted message. Format: `spaces/{space}/messages/{message}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of the quoted message. Format: `spaces/{space}/messages/{message}`
   * @param name name or {@code null} for none
   */
  public QuotedMessageMetadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public QuotedMessageMetadata set(String fieldName, Object value) {
    return (QuotedMessageMetadata) super.set(fieldName, value);
  }

  @Override
  public QuotedMessageMetadata clone() {
    return (QuotedMessageMetadata) super.clone();
  }

}
