/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A reaction to a message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Reaction extends com.google.api.client.json.GenericJson {

  /**
   * Required. The emoji used in the reaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Emoji emoji;

  /**
   * Identifier. The resource name of the reaction. Format:
   * `spaces/{space}/messages/{message}/reactions/{reaction}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The user who created the reaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User user;

  /**
   * Required. The emoji used in the reaction.
   * @return value or {@code null} for none
   */
  public Emoji getEmoji() {
    return emoji;
  }

  /**
   * Required. The emoji used in the reaction.
   * @param emoji emoji or {@code null} for none
   */
  public Reaction setEmoji(Emoji emoji) {
    this.emoji = emoji;
    return this;
  }

  /**
   * Identifier. The resource name of the reaction. Format:
   * `spaces/{space}/messages/{message}/reactions/{reaction}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. The resource name of the reaction. Format:
   * `spaces/{space}/messages/{message}/reactions/{reaction}`
   * @param name name or {@code null} for none
   */
  public Reaction setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The user who created the reaction.
   * @return value or {@code null} for none
   */
  public User getUser() {
    return user;
  }

  /**
   * Output only. The user who created the reaction.
   * @param user user or {@code null} for none
   */
  public Reaction setUser(User user) {
    this.user = user;
    return this;
  }

  @Override
  public Reaction set(String fieldName, Object value) {
    return (Reaction) super.set(fieldName, value);
  }

  @Override
  public Reaction clone() {
    return (Reaction) super.clone();
  }

}
