/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * For `selectionInput` widgets, returns autocomplete suggestions for a multiselect menu.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdatedWidget extends com.google.api.client.json.GenericJson {

  /**
   * List of widget autocomplete results
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SelectionItems suggestions;

  /**
   * The ID of the updated widget. The ID must match the one for the widget that triggered the
   * update request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String widget;

  /**
   * List of widget autocomplete results
   * @return value or {@code null} for none
   */
  public SelectionItems getSuggestions() {
    return suggestions;
  }

  /**
   * List of widget autocomplete results
   * @param suggestions suggestions or {@code null} for none
   */
  public UpdatedWidget setSuggestions(SelectionItems suggestions) {
    this.suggestions = suggestions;
    return this;
  }

  /**
   * The ID of the updated widget. The ID must match the one for the widget that triggered the
   * update request.
   * @return value or {@code null} for none
   */
  public java.lang.String getWidget() {
    return widget;
  }

  /**
   * The ID of the updated widget. The ID must match the one for the widget that triggered the
   * update request.
   * @param widget widget or {@code null} for none
   */
  public UpdatedWidget setWidget(java.lang.String widget) {
    this.widget = widget;
    return this;
  }

  @Override
  public UpdatedWidget set(String fieldName, Object value) {
    return (UpdatedWidget) super.set(fieldName, value);
  }

  @Override
  public UpdatedWidget clone() {
    return (UpdatedWidget) super.clone();
  }

}
