/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Model definition for CardHeader.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardHeader extends com.google.api.client.json.GenericJson {

  /**
   * The image's type (for example, square border or circular border).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageStyle;

  /**
   * The URL of the image in the card header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageUrl;

  /**
   * The subtitle of the card header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subtitle;

  /**
   * The title must be specified. The header has a fixed height: if both a title and subtitle is
   * specified, each takes up one line. If only the title is specified, it takes up both lines.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The image's type (for example, square border or circular border).
   * @return value or {@code null} for none
   */
  public java.lang.String getImageStyle() {
    return imageStyle;
  }

  /**
   * The image's type (for example, square border or circular border).
   * @param imageStyle imageStyle or {@code null} for none
   */
  public CardHeader setImageStyle(java.lang.String imageStyle) {
    this.imageStyle = imageStyle;
    return this;
  }

  /**
   * The URL of the image in the card header.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageUrl() {
    return imageUrl;
  }

  /**
   * The URL of the image in the card header.
   * @param imageUrl imageUrl or {@code null} for none
   */
  public CardHeader setImageUrl(java.lang.String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

  /**
   * The subtitle of the card header.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubtitle() {
    return subtitle;
  }

  /**
   * The subtitle of the card header.
   * @param subtitle subtitle or {@code null} for none
   */
  public CardHeader setSubtitle(java.lang.String subtitle) {
    this.subtitle = subtitle;
    return this;
  }

  /**
   * The title must be specified. The header has a fixed height: if both a title and subtitle is
   * specified, each takes up one line. If only the title is specified, it takes up both lines.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title must be specified. The header has a fixed height: if both a title and subtitle is
   * specified, each takes up one line. If only the title is specified, it takes up both lines.
   * @param title title or {@code null} for none
   */
  public CardHeader setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public CardHeader set(String fieldName, Object value) {
    return (CardHeader) super.set(fieldName, value);
  }

  @Override
  public CardHeader clone() {
    return (CardHeader) super.clone();
  }

}
