/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represent an expand and collapse control. [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1CollapseControl extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Define a customizable button to collapse the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Button collapseButton;

  /**
   * Optional. Define a customizable button to expand the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Button expandButton;

  /**
   * The horizontal alignment of the expand and collapse button.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String horizontalAlignment;

  /**
   * Optional. Define a customizable button to collapse the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Button getCollapseButton() {
    return collapseButton;
  }

  /**
   * Optional. Define a customizable button to collapse the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * @param collapseButton collapseButton or {@code null} for none
   */
  public GoogleAppsCardV1CollapseControl setCollapseButton(GoogleAppsCardV1Button collapseButton) {
    this.collapseButton = collapseButton;
    return this;
  }

  /**
   * Optional. Define a customizable button to expand the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Button getExpandButton() {
    return expandButton;
  }

  /**
   * Optional. Define a customizable button to expand the section. Both expand_button and
   * collapse_button field must be set. Only one field set will not take into effect. If this field
   * isn't set, the default button is used.
   * @param expandButton expandButton or {@code null} for none
   */
  public GoogleAppsCardV1CollapseControl setExpandButton(GoogleAppsCardV1Button expandButton) {
    this.expandButton = expandButton;
    return this;
  }

  /**
   * The horizontal alignment of the expand and collapse button.
   * @return value or {@code null} for none
   */
  public java.lang.String getHorizontalAlignment() {
    return horizontalAlignment;
  }

  /**
   * The horizontal alignment of the expand and collapse button.
   * @param horizontalAlignment horizontalAlignment or {@code null} for none
   */
  public GoogleAppsCardV1CollapseControl setHorizontalAlignment(java.lang.String horizontalAlignment) {
    this.horizontalAlignment = horizontalAlignment;
    return this;
  }

  @Override
  public GoogleAppsCardV1CollapseControl set(String fieldName, Object value) {
    return (GoogleAppsCardV1CollapseControl) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1CollapseControl clone() {
    return (GoogleAppsCardV1CollapseControl) super.clone();
  }

}
