/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represents the count of memberships of a space, grouped into categories.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MembershipCount extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Count of human users that have directly joined the space, not counting users
   * joined by having membership in a joined group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer joinedDirectHumanUserCount;

  /**
   * Output only. Count of all groups that have directly joined the space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer joinedGroupCount;

  /**
   * Output only. Count of human users that have directly joined the space, not counting users
   * joined by having membership in a joined group.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getJoinedDirectHumanUserCount() {
    return joinedDirectHumanUserCount;
  }

  /**
   * Output only. Count of human users that have directly joined the space, not counting users
   * joined by having membership in a joined group.
   * @param joinedDirectHumanUserCount joinedDirectHumanUserCount or {@code null} for none
   */
  public MembershipCount setJoinedDirectHumanUserCount(java.lang.Integer joinedDirectHumanUserCount) {
    this.joinedDirectHumanUserCount = joinedDirectHumanUserCount;
    return this;
  }

  /**
   * Output only. Count of all groups that have directly joined the space.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getJoinedGroupCount() {
    return joinedGroupCount;
  }

  /**
   * Output only. Count of all groups that have directly joined the space.
   * @param joinedGroupCount joinedGroupCount or {@code null} for none
   */
  public MembershipCount setJoinedGroupCount(java.lang.Integer joinedGroupCount) {
    this.joinedGroupCount = joinedGroupCount;
    return this;
  }

  @Override
  public MembershipCount set(String fieldName, Object value) {
    return (MembershipCount) super.set(fieldName, value);
  }

  @Override
  public MembershipCount clone() {
    return (MembershipCount) super.clone();
  }

}
