/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The notification setting of a user in a space.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SpaceNotificationSetting extends com.google.api.client.json.GenericJson {

  /**
   * The space notification mute setting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String muteSetting;

  /**
   * Identifier. The resource name of the space notification setting. Format:
   * `users/{user}/spaces/{space}/spaceNotificationSetting`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The notification setting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notificationSetting;

  /**
   * The space notification mute setting.
   * @return value or {@code null} for none
   */
  public java.lang.String getMuteSetting() {
    return muteSetting;
  }

  /**
   * The space notification mute setting.
   * @param muteSetting muteSetting or {@code null} for none
   */
  public SpaceNotificationSetting setMuteSetting(java.lang.String muteSetting) {
    this.muteSetting = muteSetting;
    return this;
  }

  /**
   * Identifier. The resource name of the space notification setting. Format:
   * `users/{user}/spaces/{space}/spaceNotificationSetting`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. The resource name of the space notification setting. Format:
   * `users/{user}/spaces/{space}/spaceNotificationSetting`.
   * @param name name or {@code null} for none
   */
  public SpaceNotificationSetting setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The notification setting.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotificationSetting() {
    return notificationSetting;
  }

  /**
   * The notification setting.
   * @param notificationSetting notificationSetting or {@code null} for none
   */
  public SpaceNotificationSetting setNotificationSetting(java.lang.String notificationSetting) {
    this.notificationSetting = notificationSetting;
    return this;
  }

  @Override
  public SpaceNotificationSetting set(String fieldName, Object value) {
    return (SpaceNotificationSetting) super.set(fieldName, value);
  }

  @Override
  public SpaceNotificationSetting clone() {
    return (SpaceNotificationSetting) super.clone();
  }

}
