/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Metadata about a [Chat app command](https://developers.google.com/workspace/chat/commands).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppCommandMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The ID for the command specified in the Chat API configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer appCommandId;

  /**
   * The type of Chat app command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appCommandType;

  /**
   * The ID for the command specified in the Chat API configuration.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAppCommandId() {
    return appCommandId;
  }

  /**
   * The ID for the command specified in the Chat API configuration.
   * @param appCommandId appCommandId or {@code null} for none
   */
  public AppCommandMetadata setAppCommandId(java.lang.Integer appCommandId) {
    this.appCommandId = appCommandId;
    return this;
  }

  /**
   * The type of Chat app command.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppCommandType() {
    return appCommandType;
  }

  /**
   * The type of Chat app command.
   * @param appCommandType appCommandType or {@code null} for none
   */
  public AppCommandMetadata setAppCommandType(java.lang.String appCommandType) {
    this.appCommandType = appCommandType;
    return this;
  }

  @Override
  public AppCommandMetadata set(String fieldName, Object value) {
    return (AppCommandMetadata) super.set(fieldName, value);
  }

  @Override
  public AppCommandMetadata clone() {
    return (AppCommandMetadata) super.clone();
  }

}
