/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * The common event object is the portion of the overall event object that carries general, host-
 * independent information to the add-on from the user's client. This information includes details
 * such as the user's locale, host app, and platform. In addition to homepage and contextual
 * triggers, add-ons construct and pass event objects to [action callback
 * functions](https://developers.google.com/workspace/add-ons/concepts/actions#callback_functions)
 * when the user interacts with widgets. Your add-on's callback function can query the common event
 * object to determine the contents of open widgets in the user's client. For example, your add-on
 * can locate the text a user has entered into a [TextInput](https://developers.google.com/apps-
 * script/reference/card-service/text-input) widget in the
 * `eventObject.commentEventObject.formInputs` object. For Chat apps, the name of the function that
 * the user invoked when interacting with a widget.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CommonEventObject extends com.google.api.client.json.GenericJson {

  /**
   * A map containing the current values of the widgets in the displayed card. The map keys are the
   * string IDs assigned with each widget. The structure of the map value object is dependent on the
   * widget type: **Note**: The following examples are formatted for Apps Script's V8 runtime. If
   * you're using Rhino runtime, you must add `[""]` after the value. For example, instead of
   * `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`, format the event object as
   * `e.commonEventObject.formInputs.employeeName[""].stringInputs.value[0]`. To learn more about
   * runtimes in Apps Script, see the [V8 Runtime Overview](https://developers.google.com/apps-
   * script/guides/v8-runtime). * Single-valued widgets (for example, a text box): a list of strings
   * (only one element). **Example**: for a text input widget with `employeeName` as its ID, access
   * the text input value with: `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`.
   * * Multi-valued widgets (for example, checkbox groups): a list of strings. **Example**: for a
   * multi-value widget with `participants` as its ID, access the value array with:
   * `e.commonEventObject.formInputs.participants.stringInputs.value`. * **A date-time picker**: a
   * [`DateTimeInput object`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-time-input). **Example**: For a picker with an ID of `myDTPicker`, access the
   * [`DateTimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-objects#date-
   * time-input) object using `e.commonEventObject.formInputs.myDTPicker.dateTimeInput`. * **A date-
   * only picker**: a [`DateInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#date-input). **Example**: For a picker with an ID of `myDatePicker`,
   * access the [`DateInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-input) object using `e.commonEventObject.formInputs.myDatePicker.dateInput`. * **A
   * time-only picker**: a [`TimeInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#time-input). **Example**: For a picker with an ID of `myTimePicker`,
   * access the [`TimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#time-input) object using `e.commonEventObject.formInputs.myTimePicker.timeInput`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Inputs> formInputs;

  /**
   * Indicates the host app the add-on is active in when the event object is generated. Possible
   * values include the following: * `GMAIL` * `CALENDAR` * `DRIVE` * `DOCS` * `SHEETS` * `SLIDES` *
   * `CHAT`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostApp;

  /**
   * Name of the invoked function associated with the widget. Only set for Chat apps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String invokedFunction;

  /**
   * Any additional parameters you supply to an action using
   * [`actionParameters`](https://developers.google.com/workspace/add-
   * ons/reference/rpc/google.apps.card.v1#google.apps.card.v1.Action.ActionParameter) or
   * [`Action.setParameters()`](https://developers.google.com/apps-script/reference/card-
   * service/action#setparametersparameters). **Developer Preview:** For [add-ons that extend Google
   * Chat](https://developers.google.com/workspace/add-ons/chat), to suggest items based on what the
   * users type in multiselect menus, use the value of the `"autocomplete_widget_query"` key
   * (`event.commonEventObject.parameters["autocomplete_widget_query"]`). You can use this value to
   * query a database and suggest selectable items to users as they type. For details, see [Collect
   * and process information from Google Chat users](https://developers.google.com/workspace/add-
   * ons/chat/collect-information).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * The platform enum which indicates the platform where the event originates (`WEB`, `IOS`, or
   * `ANDROID`). Not supported by Chat apps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * **Disabled by default.** The timezone ID and offset from Coordinated Universal Time (UTC). To
   * turn on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details. Only supported for the event types [`CARD_CLICKED`](https://developers.google.com/chat
   * /api/reference/rest/v1/EventType#ENUM_VALUES.CARD_CLICKED) and [`SUBMIT_DIALOG`](https://develo
   * pers.google.com/chat/api/reference/rest/v1/DialogEventType#ENUM_VALUES.SUBMIT_DIALOG).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeZone timeZone;

  /**
   * **Disabled by default.** The user's language and country/region identifier in the format of
   * [ISO 639](https://wikipedia.org/wiki/ISO_639_macrolanguage) language code-[ISO
   * 3166](https://wikipedia.org/wiki/ISO_3166) country/region code. For example, `en-US`. To turn
   * on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userLocale;

  /**
   * A map containing the current values of the widgets in the displayed card. The map keys are the
   * string IDs assigned with each widget. The structure of the map value object is dependent on the
   * widget type: **Note**: The following examples are formatted for Apps Script's V8 runtime. If
   * you're using Rhino runtime, you must add `[""]` after the value. For example, instead of
   * `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`, format the event object as
   * `e.commonEventObject.formInputs.employeeName[""].stringInputs.value[0]`. To learn more about
   * runtimes in Apps Script, see the [V8 Runtime Overview](https://developers.google.com/apps-
   * script/guides/v8-runtime). * Single-valued widgets (for example, a text box): a list of strings
   * (only one element). **Example**: for a text input widget with `employeeName` as its ID, access
   * the text input value with: `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`.
   * * Multi-valued widgets (for example, checkbox groups): a list of strings. **Example**: for a
   * multi-value widget with `participants` as its ID, access the value array with:
   * `e.commonEventObject.formInputs.participants.stringInputs.value`. * **A date-time picker**: a
   * [`DateTimeInput object`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-time-input). **Example**: For a picker with an ID of `myDTPicker`, access the
   * [`DateTimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-objects#date-
   * time-input) object using `e.commonEventObject.formInputs.myDTPicker.dateTimeInput`. * **A date-
   * only picker**: a [`DateInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#date-input). **Example**: For a picker with an ID of `myDatePicker`,
   * access the [`DateInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-input) object using `e.commonEventObject.formInputs.myDatePicker.dateInput`. * **A
   * time-only picker**: a [`TimeInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#time-input). **Example**: For a picker with an ID of `myTimePicker`,
   * access the [`TimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#time-input) object using `e.commonEventObject.formInputs.myTimePicker.timeInput`.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Inputs> getFormInputs() {
    return formInputs;
  }

  /**
   * A map containing the current values of the widgets in the displayed card. The map keys are the
   * string IDs assigned with each widget. The structure of the map value object is dependent on the
   * widget type: **Note**: The following examples are formatted for Apps Script's V8 runtime. If
   * you're using Rhino runtime, you must add `[""]` after the value. For example, instead of
   * `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`, format the event object as
   * `e.commonEventObject.formInputs.employeeName[""].stringInputs.value[0]`. To learn more about
   * runtimes in Apps Script, see the [V8 Runtime Overview](https://developers.google.com/apps-
   * script/guides/v8-runtime). * Single-valued widgets (for example, a text box): a list of strings
   * (only one element). **Example**: for a text input widget with `employeeName` as its ID, access
   * the text input value with: `e.commonEventObject.formInputs.employeeName.stringInputs.value[0]`.
   * * Multi-valued widgets (for example, checkbox groups): a list of strings. **Example**: for a
   * multi-value widget with `participants` as its ID, access the value array with:
   * `e.commonEventObject.formInputs.participants.stringInputs.value`. * **A date-time picker**: a
   * [`DateTimeInput object`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-time-input). **Example**: For a picker with an ID of `myDTPicker`, access the
   * [`DateTimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-objects#date-
   * time-input) object using `e.commonEventObject.formInputs.myDTPicker.dateTimeInput`. * **A date-
   * only picker**: a [`DateInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#date-input). **Example**: For a picker with an ID of `myDatePicker`,
   * access the [`DateInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#date-input) object using `e.commonEventObject.formInputs.myDatePicker.dateInput`. * **A
   * time-only picker**: a [`TimeInput object`](https://developers.google.com/workspace/add-
   * ons/concepts/event-objects#time-input). **Example**: For a picker with an ID of `myTimePicker`,
   * access the [`TimeInput`](https://developers.google.com/workspace/add-ons/concepts/event-
   * objects#time-input) object using `e.commonEventObject.formInputs.myTimePicker.timeInput`.
   * @param formInputs formInputs or {@code null} for none
   */
  public CommonEventObject setFormInputs(java.util.Map<String, Inputs> formInputs) {
    this.formInputs = formInputs;
    return this;
  }

  /**
   * Indicates the host app the add-on is active in when the event object is generated. Possible
   * values include the following: * `GMAIL` * `CALENDAR` * `DRIVE` * `DOCS` * `SHEETS` * `SLIDES` *
   * `CHAT`
   * @return value or {@code null} for none
   */
  public java.lang.String getHostApp() {
    return hostApp;
  }

  /**
   * Indicates the host app the add-on is active in when the event object is generated. Possible
   * values include the following: * `GMAIL` * `CALENDAR` * `DRIVE` * `DOCS` * `SHEETS` * `SLIDES` *
   * `CHAT`
   * @param hostApp hostApp or {@code null} for none
   */
  public CommonEventObject setHostApp(java.lang.String hostApp) {
    this.hostApp = hostApp;
    return this;
  }

  /**
   * Name of the invoked function associated with the widget. Only set for Chat apps.
   * @return value or {@code null} for none
   */
  public java.lang.String getInvokedFunction() {
    return invokedFunction;
  }

  /**
   * Name of the invoked function associated with the widget. Only set for Chat apps.
   * @param invokedFunction invokedFunction or {@code null} for none
   */
  public CommonEventObject setInvokedFunction(java.lang.String invokedFunction) {
    this.invokedFunction = invokedFunction;
    return this;
  }

  /**
   * Any additional parameters you supply to an action using
   * [`actionParameters`](https://developers.google.com/workspace/add-
   * ons/reference/rpc/google.apps.card.v1#google.apps.card.v1.Action.ActionParameter) or
   * [`Action.setParameters()`](https://developers.google.com/apps-script/reference/card-
   * service/action#setparametersparameters). **Developer Preview:** For [add-ons that extend Google
   * Chat](https://developers.google.com/workspace/add-ons/chat), to suggest items based on what the
   * users type in multiselect menus, use the value of the `"autocomplete_widget_query"` key
   * (`event.commonEventObject.parameters["autocomplete_widget_query"]`). You can use this value to
   * query a database and suggest selectable items to users as they type. For details, see [Collect
   * and process information from Google Chat users](https://developers.google.com/workspace/add-
   * ons/chat/collect-information).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * Any additional parameters you supply to an action using
   * [`actionParameters`](https://developers.google.com/workspace/add-
   * ons/reference/rpc/google.apps.card.v1#google.apps.card.v1.Action.ActionParameter) or
   * [`Action.setParameters()`](https://developers.google.com/apps-script/reference/card-
   * service/action#setparametersparameters). **Developer Preview:** For [add-ons that extend Google
   * Chat](https://developers.google.com/workspace/add-ons/chat), to suggest items based on what the
   * users type in multiselect menus, use the value of the `"autocomplete_widget_query"` key
   * (`event.commonEventObject.parameters["autocomplete_widget_query"]`). You can use this value to
   * query a database and suggest selectable items to users as they type. For details, see [Collect
   * and process information from Google Chat users](https://developers.google.com/workspace/add-
   * ons/chat/collect-information).
   * @param parameters parameters or {@code null} for none
   */
  public CommonEventObject setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * The platform enum which indicates the platform where the event originates (`WEB`, `IOS`, or
   * `ANDROID`). Not supported by Chat apps.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * The platform enum which indicates the platform where the event originates (`WEB`, `IOS`, or
   * `ANDROID`). Not supported by Chat apps.
   * @param platform platform or {@code null} for none
   */
  public CommonEventObject setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * **Disabled by default.** The timezone ID and offset from Coordinated Universal Time (UTC). To
   * turn on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details. Only supported for the event types [`CARD_CLICKED`](https://developers.google.com/chat
   * /api/reference/rest/v1/EventType#ENUM_VALUES.CARD_CLICKED) and [`SUBMIT_DIALOG`](https://develo
   * pers.google.com/chat/api/reference/rest/v1/DialogEventType#ENUM_VALUES.SUBMIT_DIALOG).
   * @return value or {@code null} for none
   */
  public TimeZone getTimeZone() {
    return timeZone;
  }

  /**
   * **Disabled by default.** The timezone ID and offset from Coordinated Universal Time (UTC). To
   * turn on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details. Only supported for the event types [`CARD_CLICKED`](https://developers.google.com/chat
   * /api/reference/rest/v1/EventType#ENUM_VALUES.CARD_CLICKED) and [`SUBMIT_DIALOG`](https://develo
   * pers.google.com/chat/api/reference/rest/v1/DialogEventType#ENUM_VALUES.SUBMIT_DIALOG).
   * @param timeZone timeZone or {@code null} for none
   */
  public CommonEventObject setTimeZone(TimeZone timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * **Disabled by default.** The user's language and country/region identifier in the format of
   * [ISO 639](https://wikipedia.org/wiki/ISO_639_macrolanguage) language code-[ISO
   * 3166](https://wikipedia.org/wiki/ISO_3166) country/region code. For example, `en-US`. To turn
   * on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserLocale() {
    return userLocale;
  }

  /**
   * **Disabled by default.** The user's language and country/region identifier in the format of
   * [ISO 639](https://wikipedia.org/wiki/ISO_639_macrolanguage) language code-[ISO
   * 3166](https://wikipedia.org/wiki/ISO_3166) country/region code. For example, `en-US`. To turn
   * on this field, you must set `addOns.common.useLocaleFromApp` to `true` in your add-on's
   * manifest. Your add-on's scope list must also include
   * `https://www.googleapis.com/auth/script.locale`. See [Accessing user locale and
   * timezone](https://developers.google.com/workspace/add-ons/how-tos/access-user-locale) for more
   * details.
   * @param userLocale userLocale or {@code null} for none
   */
  public CommonEventObject setUserLocale(java.lang.String userLocale) {
    this.userLocale = userLocale;
    return this;
  }

  @Override
  public CommonEventObject set(String fieldName, Object value) {
    return (CommonEventObject) super.set(fieldName, value);
  }

  @Override
  public CommonEventObject clone() {
    return (CommonEventObject) super.clone();
  }

}
