/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Payload data for the custom emoji.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomEmojiPayload extends com.google.api.client.json.GenericJson {

  /**
   * Required. Input only. The image used for the custom emoji. The payload must be under 256 KB and
   * the dimension of the image must be square and between 64 and 500 pixels. The restrictions are
   * subject to change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileContent;

  /**
   * Required. Input only. The image file name. Supported file extensions: `.png`, `.jpg`, `.gif`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filename;

  /**
   * Required. Input only. The image used for the custom emoji. The payload must be under 256 KB and
   * the dimension of the image must be square and between 64 and 500 pixels. The restrictions are
   * subject to change.
   * @see #decodeFileContent()
   * @return value or {@code null} for none
   */
  public java.lang.String getFileContent() {
    return fileContent;
  }

  /**
   * Required. Input only. The image used for the custom emoji. The payload must be under 256 KB and
   * the dimension of the image must be square and between 64 and 500 pixels. The restrictions are
   * subject to change.
   * @see #getFileContent()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFileContent() {
    return com.google.api.client.util.Base64.decodeBase64(fileContent);
  }

  /**
   * Required. Input only. The image used for the custom emoji. The payload must be under 256 KB and
   * the dimension of the image must be square and between 64 and 500 pixels. The restrictions are
   * subject to change.
   * @see #encodeFileContent()
   * @param fileContent fileContent or {@code null} for none
   */
  public CustomEmojiPayload setFileContent(java.lang.String fileContent) {
    this.fileContent = fileContent;
    return this;
  }

  /**
   * Required. Input only. The image used for the custom emoji. The payload must be under 256 KB and
   * the dimension of the image must be square and between 64 and 500 pixels. The restrictions are
   * subject to change.
   * @see #setFileContent()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public CustomEmojiPayload encodeFileContent(byte[] fileContent) {
    this.fileContent = com.google.api.client.util.Base64.encodeBase64URLSafeString(fileContent);
    return this;
  }

  /**
   * Required. Input only. The image file name. Supported file extensions: `.png`, `.jpg`, `.gif`.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilename() {
    return filename;
  }

  /**
   * Required. Input only. The image file name. Supported file extensions: `.png`, `.jpg`, `.gif`.
   * @param filename filename or {@code null} for none
   */
  public CustomEmojiPayload setFilename(java.lang.String filename) {
    this.filename = filename;
    return this;
  }

  @Override
  public CustomEmojiPayload set(String fieldName, Object value) {
    return (CustomEmojiPayload) super.set(fieldName, value);
  }

  @Override
  public CustomEmojiPayload clone() {
    return (CustomEmojiPayload) super.clone();
  }

}
