/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A list of chips layed out horizontally, which can either scroll horizontally or wrap to the next
 * line. [Google Workspace add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1ChipList extends com.google.api.client.json.GenericJson {

  /**
   * An array of chips.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCardV1Chip> chips;

  static {
    // hack to force ProGuard to consider GoogleAppsCardV1Chip used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCardV1Chip.class);
  }

  /**
   * Specified chip list layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String layout;

  /**
   * An array of chips.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCardV1Chip> getChips() {
    return chips;
  }

  /**
   * An array of chips.
   * @param chips chips or {@code null} for none
   */
  public GoogleAppsCardV1ChipList setChips(java.util.List<GoogleAppsCardV1Chip> chips) {
    this.chips = chips;
    return this;
  }

  /**
   * Specified chip list layout.
   * @return value or {@code null} for none
   */
  public java.lang.String getLayout() {
    return layout;
  }

  /**
   * Specified chip list layout.
   * @param layout layout or {@code null} for none
   */
  public GoogleAppsCardV1ChipList setLayout(java.lang.String layout) {
    this.layout = layout;
    return this;
  }

  @Override
  public GoogleAppsCardV1ChipList set(String fieldName, Object value) {
    return (GoogleAppsCardV1ChipList) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1ChipList clone() {
    return (GoogleAppsCardV1ChipList) super.clone();
  }

}
