/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * [Developer Preview](https://developers.google.com/workspace/preview): A list of widgets that can
 * be displayed in a containing layout, such as a `CarouselCard`. [Google Chat
 * apps](https://developers.google.com/workspace/chat):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1NestedWidget extends com.google.api.client.json.GenericJson {

  /**
   * A button list widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1ButtonList buttonList;

  /**
   * An image widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Image image;

  /**
   * A text paragraph widget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1TextParagraph textParagraph;

  /**
   * A button list widget.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1ButtonList getButtonList() {
    return buttonList;
  }

  /**
   * A button list widget.
   * @param buttonList buttonList or {@code null} for none
   */
  public GoogleAppsCardV1NestedWidget setButtonList(GoogleAppsCardV1ButtonList buttonList) {
    this.buttonList = buttonList;
    return this;
  }

  /**
   * An image widget.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Image getImage() {
    return image;
  }

  /**
   * An image widget.
   * @param image image or {@code null} for none
   */
  public GoogleAppsCardV1NestedWidget setImage(GoogleAppsCardV1Image image) {
    this.image = image;
    return this;
  }

  /**
   * A text paragraph widget.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1TextParagraph getTextParagraph() {
    return textParagraph;
  }

  /**
   * A text paragraph widget.
   * @param textParagraph textParagraph or {@code null} for none
   */
  public GoogleAppsCardV1NestedWidget setTextParagraph(GoogleAppsCardV1TextParagraph textParagraph) {
    this.textParagraph = textParagraph;
    return this;
  }

  @Override
  public GoogleAppsCardV1NestedWidget set(String fieldName, Object value) {
    return (GoogleAppsCardV1NestedWidget) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1NestedWidget clone() {
    return (GoogleAppsCardV1NestedWidget) super.clone();
  }

}
