/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * An option that users can invoke in an overflow menu. [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1OverflowMenuItem extends com.google.api.client.json.GenericJson {

  /**
   * Whether the menu option is disabled. Defaults to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Required. The action invoked when a menu option is selected. This `OnClick` cannot contain an
   * `OverflowMenu`, any specified `OverflowMenu` is dropped and the menu item disabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1OnClick onClick;

  /**
   * The icon displayed in front of the text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Icon startIcon;

  /**
   * Required. The text that identifies or describes the item to users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Whether the menu option is disabled. Defaults to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Whether the menu option is disabled. Defaults to false.
   * @param disabled disabled or {@code null} for none
   */
  public GoogleAppsCardV1OverflowMenuItem setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Required. The action invoked when a menu option is selected. This `OnClick` cannot contain an
   * `OverflowMenu`, any specified `OverflowMenu` is dropped and the menu item disabled.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1OnClick getOnClick() {
    return onClick;
  }

  /**
   * Required. The action invoked when a menu option is selected. This `OnClick` cannot contain an
   * `OverflowMenu`, any specified `OverflowMenu` is dropped and the menu item disabled.
   * @param onClick onClick or {@code null} for none
   */
  public GoogleAppsCardV1OverflowMenuItem setOnClick(GoogleAppsCardV1OnClick onClick) {
    this.onClick = onClick;
    return this;
  }

  /**
   * The icon displayed in front of the text.
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Icon getStartIcon() {
    return startIcon;
  }

  /**
   * The icon displayed in front of the text.
   * @param startIcon startIcon or {@code null} for none
   */
  public GoogleAppsCardV1OverflowMenuItem setStartIcon(GoogleAppsCardV1Icon startIcon) {
    this.startIcon = startIcon;
    return this;
  }

  /**
   * Required. The text that identifies or describes the item to users.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * Required. The text that identifies or describes the item to users.
   * @param text text or {@code null} for none
   */
  public GoogleAppsCardV1OverflowMenuItem setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public GoogleAppsCardV1OverflowMenuItem set(String fieldName, Object value) {
    return (GoogleAppsCardV1OverflowMenuItem) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1OverflowMenuItem clone() {
    return (GoogleAppsCardV1OverflowMenuItem) super.clone();
  }

}
