/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A response to list custom emojis.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListCustomEmojisResponse extends com.google.api.client.json.GenericJson {

  /**
   * Unordered list. List of custom emojis.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomEmoji> customEmojis;

  static {
    // hack to force ProGuard to consider CustomEmoji used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CustomEmoji.class);
  }

  /**
   * A token that you can send as `pageToken` to retrieve the next page of results. If empty, there
   * are no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Unordered list. List of custom emojis.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomEmoji> getCustomEmojis() {
    return customEmojis;
  }

  /**
   * Unordered list. List of custom emojis.
   * @param customEmojis customEmojis or {@code null} for none
   */
  public ListCustomEmojisResponse setCustomEmojis(java.util.List<CustomEmoji> customEmojis) {
    this.customEmojis = customEmojis;
    return this;
  }

  /**
   * A token that you can send as `pageToken` to retrieve the next page of results. If empty, there
   * are no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token that you can send as `pageToken` to retrieve the next page of results. If empty, there
   * are no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListCustomEmojisResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListCustomEmojisResponse set(String fieldName, Object value) {
    return (ListCustomEmojisResponse) super.set(fieldName, value);
  }

  @Override
  public ListCustomEmojisResponse clone() {
    return (ListCustomEmojisResponse) super.clone();
  }

}
