/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Represents a membership relation in Google Chat, such as whether a user or Chat app is invited
 * to, part of, or absent from a space.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Membership extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Immutable. The creation time of the membership, such as when a member joined or was
   * invited to join a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Optional. Immutable. The deletion time of the membership, such as when a member left or was
   * removed from a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deleteTime;

  /**
   * Optional. The Google Group the membership corresponds to. Reading or mutating memberships for
   * Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Group groupMember;

  /**
   * Optional. The Google Chat user or app the membership corresponds to. If your Chat app
   * [authenticates as a user](https://developers.google.com/workspace/chat/authenticate-authorize-
   * chat-user), the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User) `name` and
   * `type`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User member;

  /**
   * Identifier. Resource name of the membership, assigned by the server. Format:
   * `spaces/{space}/members/{member}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. User's role within a Chat space, which determines their permitted actions in the
   * space. This field can only be used as input in `UpdateMembership`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Output only. State of the membership.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Optional. Immutable. The creation time of the membership, such as when a member joined or was
   * invited to join a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Optional. Immutable. The creation time of the membership, such as when a member joined or was
   * invited to join a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * @param createTime createTime or {@code null} for none
   */
  public Membership setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Optional. Immutable. The deletion time of the membership, such as when a member left or was
   * removed from a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * @return value or {@code null} for none
   */
  public String getDeleteTime() {
    return deleteTime;
  }

  /**
   * Optional. Immutable. The deletion time of the membership, such as when a member left or was
   * removed from a space. This field is output only, except when used to import historical
   * memberships in import mode spaces.
   * @param deleteTime deleteTime or {@code null} for none
   */
  public Membership setDeleteTime(String deleteTime) {
    this.deleteTime = deleteTime;
    return this;
  }

  /**
   * Optional. The Google Group the membership corresponds to. Reading or mutating memberships for
   * Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * @return value or {@code null} for none
   */
  public Group getGroupMember() {
    return groupMember;
  }

  /**
   * Optional. The Google Group the membership corresponds to. Reading or mutating memberships for
   * Google Groups requires [user
   * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
   * @param groupMember groupMember or {@code null} for none
   */
  public Membership setGroupMember(Group groupMember) {
    this.groupMember = groupMember;
    return this;
  }

  /**
   * Optional. The Google Chat user or app the membership corresponds to. If your Chat app
   * [authenticates as a user](https://developers.google.com/workspace/chat/authenticate-authorize-
   * chat-user), the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User) `name` and
   * `type`.
   * @return value or {@code null} for none
   */
  public User getMember() {
    return member;
  }

  /**
   * Optional. The Google Chat user or app the membership corresponds to. If your Chat app
   * [authenticates as a user](https://developers.google.com/workspace/chat/authenticate-authorize-
   * chat-user), the output populates the
   * [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User) `name` and
   * `type`.
   * @param member member or {@code null} for none
   */
  public Membership setMember(User member) {
    this.member = member;
    return this;
  }

  /**
   * Identifier. Resource name of the membership, assigned by the server. Format:
   * `spaces/{space}/members/{member}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. Resource name of the membership, assigned by the server. Format:
   * `spaces/{space}/members/{member}`
   * @param name name or {@code null} for none
   */
  public Membership setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. User's role within a Chat space, which determines their permitted actions in the
   * space. This field can only be used as input in `UpdateMembership`.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Optional. User's role within a Chat space, which determines their permitted actions in the
   * space. This field can only be used as input in `UpdateMembership`.
   * @param role role or {@code null} for none
   */
  public Membership setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Output only. State of the membership.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. State of the membership.
   * @param state state or {@code null} for none
   */
  public Membership setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public Membership set(String fieldName, Object value) {
    return (Membership) super.set(fieldName, value);
  }

  @Override
  public Membership clone() {
    return (Membership) super.clone();
  }

}
