/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * A rich link to a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RichLinkMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Data for a chat space link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChatSpaceLinkData chatSpaceLinkData;

  /**
   * Data for a drive link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DriveLinkData driveLinkData;

  /**
   * The rich link type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String richLinkType;

  /**
   * The URI of this link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Data for a chat space link.
   * @return value or {@code null} for none
   */
  public ChatSpaceLinkData getChatSpaceLinkData() {
    return chatSpaceLinkData;
  }

  /**
   * Data for a chat space link.
   * @param chatSpaceLinkData chatSpaceLinkData or {@code null} for none
   */
  public RichLinkMetadata setChatSpaceLinkData(ChatSpaceLinkData chatSpaceLinkData) {
    this.chatSpaceLinkData = chatSpaceLinkData;
    return this;
  }

  /**
   * Data for a drive link.
   * @return value or {@code null} for none
   */
  public DriveLinkData getDriveLinkData() {
    return driveLinkData;
  }

  /**
   * Data for a drive link.
   * @param driveLinkData driveLinkData or {@code null} for none
   */
  public RichLinkMetadata setDriveLinkData(DriveLinkData driveLinkData) {
    this.driveLinkData = driveLinkData;
    return this;
  }

  /**
   * The rich link type.
   * @return value or {@code null} for none
   */
  public java.lang.String getRichLinkType() {
    return richLinkType;
  }

  /**
   * The rich link type.
   * @param richLinkType richLinkType or {@code null} for none
   */
  public RichLinkMetadata setRichLinkType(java.lang.String richLinkType) {
    this.richLinkType = richLinkType;
    return this;
  }

  /**
   * The URI of this link.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The URI of this link.
   * @param uri uri or {@code null} for none
   */
  public RichLinkMetadata setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public RichLinkMetadata set(String fieldName, Object value) {
    return (RichLinkMetadata) super.set(fieldName, value);
  }

  @Override
  public RichLinkMetadata clone() {
    return (RichLinkMetadata) super.clone();
  }

}
