/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Annotation metadata for slash commands (/).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SlashCommandMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The Chat app whose command was invoked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User bot;

  /**
   * The command ID of the invoked slash command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long commandId;

  /**
   * The name of the invoked slash command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commandName;

  /**
   * Indicates whether the slash command is for a dialog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean triggersDialog;

  /**
   * The type of slash command.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The Chat app whose command was invoked.
   * @return value or {@code null} for none
   */
  public User getBot() {
    return bot;
  }

  /**
   * The Chat app whose command was invoked.
   * @param bot bot or {@code null} for none
   */
  public SlashCommandMetadata setBot(User bot) {
    this.bot = bot;
    return this;
  }

  /**
   * The command ID of the invoked slash command.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCommandId() {
    return commandId;
  }

  /**
   * The command ID of the invoked slash command.
   * @param commandId commandId or {@code null} for none
   */
  public SlashCommandMetadata setCommandId(java.lang.Long commandId) {
    this.commandId = commandId;
    return this;
  }

  /**
   * The name of the invoked slash command.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommandName() {
    return commandName;
  }

  /**
   * The name of the invoked slash command.
   * @param commandName commandName or {@code null} for none
   */
  public SlashCommandMetadata setCommandName(java.lang.String commandName) {
    this.commandName = commandName;
    return this;
  }

  /**
   * Indicates whether the slash command is for a dialog.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTriggersDialog() {
    return triggersDialog;
  }

  /**
   * Indicates whether the slash command is for a dialog.
   * @param triggersDialog triggersDialog or {@code null} for none
   */
  public SlashCommandMetadata setTriggersDialog(java.lang.Boolean triggersDialog) {
    this.triggersDialog = triggersDialog;
    return this;
  }

  /**
   * The type of slash command.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of slash command.
   * @param type type or {@code null} for none
   */
  public SlashCommandMetadata setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SlashCommandMetadata set(String fieldName, Object value) {
    return (SlashCommandMetadata) super.set(fieldName, value);
  }

  @Override
  public SlashCommandMetadata clone() {
    return (SlashCommandMetadata) super.clone();
  }

}
