/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Details about the space including description and rules.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SpaceDetails extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A description of the space. For example, describe the space's discussion topic,
   * functional purpose, or participants. Supports up to 150 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Optional. The space's rules, expectations, and etiquette. Supports up to 5,000 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String guidelines;

  /**
   * Optional. A description of the space. For example, describe the space's discussion topic,
   * functional purpose, or participants. Supports up to 150 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A description of the space. For example, describe the space's discussion topic,
   * functional purpose, or participants. Supports up to 150 characters.
   * @param description description or {@code null} for none
   */
  public SpaceDetails setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Optional. The space's rules, expectations, and etiquette. Supports up to 5,000 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getGuidelines() {
    return guidelines;
  }

  /**
   * Optional. The space's rules, expectations, and etiquette. Supports up to 5,000 characters.
   * @param guidelines guidelines or {@code null} for none
   */
  public SpaceDetails setGuidelines(java.lang.String guidelines) {
    this.guidelines = guidelines;
    return this;
  }

  @Override
  public SpaceDetails set(String fieldName, Object value) {
    return (SpaceDetails) super.set(fieldName, value);
  }

  @Override
  public SpaceDetails clone() {
    return (SpaceDetails) super.clone();
  }

}
