/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Data for Calendar event links.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarEventLinkData extends com.google.api.client.json.GenericJson {

  /**
   * The [Calendar
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/calendars) of the
   * linked Calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String calendarId;

  /**
   * The [Event
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/events) of the
   * linked Calendar event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventId;

  /**
   * The [Calendar
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/calendars) of the
   * linked Calendar.
   * @return value or {@code null} for none
   */
  public java.lang.String getCalendarId() {
    return calendarId;
  }

  /**
   * The [Calendar
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/calendars) of the
   * linked Calendar.
   * @param calendarId calendarId or {@code null} for none
   */
  public CalendarEventLinkData setCalendarId(java.lang.String calendarId) {
    this.calendarId = calendarId;
    return this;
  }

  /**
   * The [Event
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/events) of the
   * linked Calendar event.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventId() {
    return eventId;
  }

  /**
   * The [Event
   * identifier](https://developers.google.com/workspace/calendar/api/v3/reference/events) of the
   * linked Calendar event.
   * @param eventId eventId or {@code null} for none
   */
  public CalendarEventLinkData setEventId(java.lang.String eventId) {
    this.eventId = eventId;
    return this;
  }

  @Override
  public CalendarEventLinkData set(String fieldName, Object value) {
    return (CalendarEventLinkData) super.set(fieldName, value);
  }

  @Override
  public CalendarEventLinkData clone() {
    return (CalendarEventLinkData) super.clone();
  }

}
