/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Each card is made up of widgets. A widget is a composite object that can represent one of text,
 * images, buttons, and other object types.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCardV1Widget extends com.google.api.client.json.GenericJson {

  /**
   * A list of buttons. For example, the following JSON creates two buttons. The first is a blue
   * text button and the second is an image button that opens a link: ``` "buttonList": { "buttons":
   * [ { "text": "Edit", "color": { "red": 0, "green": 0, "blue": 1, }, "disabled": true, }, {
   * "icon": { "knownIcon": "INVITE", "altText": "check calendar" }, "onClick": { "openLink": {
   * "url": "https://example.com/calendar" } } } ] } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1ButtonList buttonList;

  /**
   * A carousel contains a collection of nested widgets. For example, this is a JSON representation
   * of a carousel that contains two text paragraphs. ``` { "widgets": [ { "textParagraph": {
   * "text": "First text paragraph in the carousel." } }, { "textParagraph": { "text": "Second text
   * paragraph in the carousel." } } ] } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Carousel carousel;

  /**
   * A list of chips. For example, the following JSON creates two chips. The first is a text chip
   * and the second is an icon chip that opens a link: ``` "chipList": { "chips": [ { "text":
   * "Edit", "disabled": true, }, { "icon": { "knownIcon": "INVITE", "altText": "check calendar" },
   * "onClick": { "openLink": { "url": "https://example.com/calendar" } } } ] } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1ChipList chipList;

  /**
   * Displays up to 2 columns. To include more than 2 columns, or to use rows, use the `Grid`
   * widget. For example, the following JSON creates 2 columns that each contain text paragraphs:
   * ``` "columns": { "columnItems": [ { "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   * "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER", "widgets": [ { "textParagraph":
   * { "text": "First column text paragraph" } } ] }, { "horizontalSizeStyle":
   * "FILL_AVAILABLE_SPACE", "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER",
   * "widgets": [ { "textParagraph": { "text": "Second column text paragraph" } } ] } ] } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Columns columns;

  /**
   * Displays a widget that lets users input a date, time, or date and time. For example, the
   * following JSON creates a date time picker to schedule an appointment: ``` "dateTimePicker": {
   * "name": "appointment_time", "label": "Book your appointment at:", "type": "DATE_AND_TIME",
   * "valueMsEpoch": 796435200000 } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1DateTimePicker dateTimePicker;

  /**
   * Displays a decorated text item. For example, the following JSON creates a decorated text widget
   * showing email address: ``` "decoratedText": { "icon": { "knownIcon": "EMAIL" }, "topLabel":
   * "Email Address", "text": "sasha@example.com", "bottomLabel": "This is a new Email address!",
   * "switchControl": { "name": "has_send_welcome_email_to_sasha", "selected": false, "controlType":
   * "CHECKBOX" } } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1DecoratedText decoratedText;

  /**
   * Displays a horizontal line divider between widgets. For example, the following JSON creates a
   * divider: ``` "divider": { } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Divider divider;

  /**
   * Displays a grid with a collection of items. A grid supports any number of columns and items.
   * The number of rows is determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
   * has 6 rows. [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend): For example, the following JSON creates
   * a 2 column grid with a single item: ``` "grid": { "title": "A fine collection of items",
   * "columnCount": 2, "borderStyle": { "type": "STROKE", "cornerRadius": 4 }, "items": [ { "image":
   * { "imageUri": "https://www.example.com/image.png", "cropStyle": { "type": "SQUARE" },
   * "borderStyle": { "type": "STROKE" } }, "title": "An item", "textAlignment": "CENTER" } ],
   * "onClick": { "openLink": { "url": "https://www.example.com" } } } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Grid grid;

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String horizontalAlignment;

  /**
   * Displays an image. For example, the following JSON creates an image with alternative text: ```
   * "image": { "imageUrl": "https://developers.google.com/workspace/chat/images/quickstart-app-
   * avatar.png", "altText": "Chat app avatar" } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1Image image;

  /**
   * Displays a selection control that lets users select items. Selection controls can be
   * checkboxes, radio buttons, switches, or dropdown menus. For example, the following JSON creates
   * a dropdown menu that lets users choose a size: ``` "selectionInput": { "name": "size", "label":
   * "Size" "type": "DROPDOWN", "items": [ { "text": "S", "value": "small", "selected": false }, {
   * "text": "M", "value": "medium", "selected": true }, { "text": "L", "value": "large",
   * "selected": false }, { "text": "XL", "value": "extra_large", "selected": false } ] } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1SelectionInput selectionInput;

  /**
   * Displays a text box that users can type into. For example, the following JSON creates a text
   * input for an email address: ``` "textInput": { "name": "mailing_address", "label": "Mailing
   * Address" } ``` As another example, the following JSON creates a text input for a programming
   * language with static suggestions: ``` "textInput": { "name": "preferred_programing_language",
   * "label": "Preferred Language", "initialSuggestions": { "items": [ { "text": "C++" }, { "text":
   * "Java" }, { "text": "JavaScript" }, { "text": "Python" } ] } } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1TextInput textInput;

  /**
   * Displays a text paragraph. Supports simple HTML formatted text. For more information about
   * formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting) and
   * [Formatting text in Google Workspace add-ons](https://developers.google.com/apps-script/add-
   * ons/concepts/widgets#text_formatting). For example, the following JSON creates a bolded text:
   * ``` "textParagraph": { "text": " *bold text*" } ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCardV1TextParagraph textParagraph;

  /**
   * A list of buttons. For example, the following JSON creates two buttons. The first is a blue
   * text button and the second is an image button that opens a link: ``` "buttonList": { "buttons":
   * [ { "text": "Edit", "color": { "red": 0, "green": 0, "blue": 1, }, "disabled": true, }, {
   * "icon": { "knownIcon": "INVITE", "altText": "check calendar" }, "onClick": { "openLink": {
   * "url": "https://example.com/calendar" } } } ] } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1ButtonList getButtonList() {
    return buttonList;
  }

  /**
   * A list of buttons. For example, the following JSON creates two buttons. The first is a blue
   * text button and the second is an image button that opens a link: ``` "buttonList": { "buttons":
   * [ { "text": "Edit", "color": { "red": 0, "green": 0, "blue": 1, }, "disabled": true, }, {
   * "icon": { "knownIcon": "INVITE", "altText": "check calendar" }, "onClick": { "openLink": {
   * "url": "https://example.com/calendar" } } } ] } ```
   * @param buttonList buttonList or {@code null} for none
   */
  public GoogleAppsCardV1Widget setButtonList(GoogleAppsCardV1ButtonList buttonList) {
    this.buttonList = buttonList;
    return this;
  }

  /**
   * A carousel contains a collection of nested widgets. For example, this is a JSON representation
   * of a carousel that contains two text paragraphs. ``` { "widgets": [ { "textParagraph": {
   * "text": "First text paragraph in the carousel." } }, { "textParagraph": { "text": "Second text
   * paragraph in the carousel." } } ] } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Carousel getCarousel() {
    return carousel;
  }

  /**
   * A carousel contains a collection of nested widgets. For example, this is a JSON representation
   * of a carousel that contains two text paragraphs. ``` { "widgets": [ { "textParagraph": {
   * "text": "First text paragraph in the carousel." } }, { "textParagraph": { "text": "Second text
   * paragraph in the carousel." } } ] } ```
   * @param carousel carousel or {@code null} for none
   */
  public GoogleAppsCardV1Widget setCarousel(GoogleAppsCardV1Carousel carousel) {
    this.carousel = carousel;
    return this;
  }

  /**
   * A list of chips. For example, the following JSON creates two chips. The first is a text chip
   * and the second is an icon chip that opens a link: ``` "chipList": { "chips": [ { "text":
   * "Edit", "disabled": true, }, { "icon": { "knownIcon": "INVITE", "altText": "check calendar" },
   * "onClick": { "openLink": { "url": "https://example.com/calendar" } } } ] } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1ChipList getChipList() {
    return chipList;
  }

  /**
   * A list of chips. For example, the following JSON creates two chips. The first is a text chip
   * and the second is an icon chip that opens a link: ``` "chipList": { "chips": [ { "text":
   * "Edit", "disabled": true, }, { "icon": { "knownIcon": "INVITE", "altText": "check calendar" },
   * "onClick": { "openLink": { "url": "https://example.com/calendar" } } } ] } ```
   * @param chipList chipList or {@code null} for none
   */
  public GoogleAppsCardV1Widget setChipList(GoogleAppsCardV1ChipList chipList) {
    this.chipList = chipList;
    return this;
  }

  /**
   * Displays up to 2 columns. To include more than 2 columns, or to use rows, use the `Grid`
   * widget. For example, the following JSON creates 2 columns that each contain text paragraphs:
   * ``` "columns": { "columnItems": [ { "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   * "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER", "widgets": [ { "textParagraph":
   * { "text": "First column text paragraph" } } ] }, { "horizontalSizeStyle":
   * "FILL_AVAILABLE_SPACE", "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER",
   * "widgets": [ { "textParagraph": { "text": "Second column text paragraph" } } ] } ] } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Columns getColumns() {
    return columns;
  }

  /**
   * Displays up to 2 columns. To include more than 2 columns, or to use rows, use the `Grid`
   * widget. For example, the following JSON creates 2 columns that each contain text paragraphs:
   * ``` "columns": { "columnItems": [ { "horizontalSizeStyle": "FILL_AVAILABLE_SPACE",
   * "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER", "widgets": [ { "textParagraph":
   * { "text": "First column text paragraph" } } ] }, { "horizontalSizeStyle":
   * "FILL_AVAILABLE_SPACE", "horizontalAlignment": "CENTER", "verticalAlignment": "CENTER",
   * "widgets": [ { "textParagraph": { "text": "Second column text paragraph" } } ] } ] } ```
   * @param columns columns or {@code null} for none
   */
  public GoogleAppsCardV1Widget setColumns(GoogleAppsCardV1Columns columns) {
    this.columns = columns;
    return this;
  }

  /**
   * Displays a widget that lets users input a date, time, or date and time. For example, the
   * following JSON creates a date time picker to schedule an appointment: ``` "dateTimePicker": {
   * "name": "appointment_time", "label": "Book your appointment at:", "type": "DATE_AND_TIME",
   * "valueMsEpoch": 796435200000 } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1DateTimePicker getDateTimePicker() {
    return dateTimePicker;
  }

  /**
   * Displays a widget that lets users input a date, time, or date and time. For example, the
   * following JSON creates a date time picker to schedule an appointment: ``` "dateTimePicker": {
   * "name": "appointment_time", "label": "Book your appointment at:", "type": "DATE_AND_TIME",
   * "valueMsEpoch": 796435200000 } ```
   * @param dateTimePicker dateTimePicker or {@code null} for none
   */
  public GoogleAppsCardV1Widget setDateTimePicker(GoogleAppsCardV1DateTimePicker dateTimePicker) {
    this.dateTimePicker = dateTimePicker;
    return this;
  }

  /**
   * Displays a decorated text item. For example, the following JSON creates a decorated text widget
   * showing email address: ``` "decoratedText": { "icon": { "knownIcon": "EMAIL" }, "topLabel":
   * "Email Address", "text": "sasha@example.com", "bottomLabel": "This is a new Email address!",
   * "switchControl": { "name": "has_send_welcome_email_to_sasha", "selected": false, "controlType":
   * "CHECKBOX" } } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1DecoratedText getDecoratedText() {
    return decoratedText;
  }

  /**
   * Displays a decorated text item. For example, the following JSON creates a decorated text widget
   * showing email address: ``` "decoratedText": { "icon": { "knownIcon": "EMAIL" }, "topLabel":
   * "Email Address", "text": "sasha@example.com", "bottomLabel": "This is a new Email address!",
   * "switchControl": { "name": "has_send_welcome_email_to_sasha", "selected": false, "controlType":
   * "CHECKBOX" } } ```
   * @param decoratedText decoratedText or {@code null} for none
   */
  public GoogleAppsCardV1Widget setDecoratedText(GoogleAppsCardV1DecoratedText decoratedText) {
    this.decoratedText = decoratedText;
    return this;
  }

  /**
   * Displays a horizontal line divider between widgets. For example, the following JSON creates a
   * divider: ``` "divider": { } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Divider getDivider() {
    return divider;
  }

  /**
   * Displays a horizontal line divider between widgets. For example, the following JSON creates a
   * divider: ``` "divider": { } ```
   * @param divider divider or {@code null} for none
   */
  public GoogleAppsCardV1Widget setDivider(GoogleAppsCardV1Divider divider) {
    this.divider = divider;
    return this;
  }

  /**
   * Displays a grid with a collection of items. A grid supports any number of columns and items.
   * The number of rows is determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
   * has 6 rows. [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend): For example, the following JSON creates
   * a 2 column grid with a single item: ``` "grid": { "title": "A fine collection of items",
   * "columnCount": 2, "borderStyle": { "type": "STROKE", "cornerRadius": 4 }, "items": [ { "image":
   * { "imageUri": "https://www.example.com/image.png", "cropStyle": { "type": "SQUARE" },
   * "borderStyle": { "type": "STROKE" } }, "title": "An item", "textAlignment": "CENTER" } ],
   * "onClick": { "openLink": { "url": "https://www.example.com" } } } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Grid getGrid() {
    return grid;
  }

  /**
   * Displays a grid with a collection of items. A grid supports any number of columns and items.
   * The number of rows is determined by the upper bounds of the number items divided by the number
   * of columns. A grid with 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
   * has 6 rows. [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend): For example, the following JSON creates
   * a 2 column grid with a single item: ``` "grid": { "title": "A fine collection of items",
   * "columnCount": 2, "borderStyle": { "type": "STROKE", "cornerRadius": 4 }, "items": [ { "image":
   * { "imageUri": "https://www.example.com/image.png", "cropStyle": { "type": "SQUARE" },
   * "borderStyle": { "type": "STROKE" } }, "title": "An item", "textAlignment": "CENTER" } ],
   * "onClick": { "openLink": { "url": "https://www.example.com" } } } ```
   * @param grid grid or {@code null} for none
   */
  public GoogleAppsCardV1Widget setGrid(GoogleAppsCardV1Grid grid) {
    this.grid = grid;
    return this;
  }

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * @return value or {@code null} for none
   */
  public java.lang.String getHorizontalAlignment() {
    return horizontalAlignment;
  }

  /**
   * Specifies whether widgets align to the left, right, or center of a column.
   * @param horizontalAlignment horizontalAlignment or {@code null} for none
   */
  public GoogleAppsCardV1Widget setHorizontalAlignment(java.lang.String horizontalAlignment) {
    this.horizontalAlignment = horizontalAlignment;
    return this;
  }

  /**
   * Displays an image. For example, the following JSON creates an image with alternative text: ```
   * "image": { "imageUrl": "https://developers.google.com/workspace/chat/images/quickstart-app-
   * avatar.png", "altText": "Chat app avatar" } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1Image getImage() {
    return image;
  }

  /**
   * Displays an image. For example, the following JSON creates an image with alternative text: ```
   * "image": { "imageUrl": "https://developers.google.com/workspace/chat/images/quickstart-app-
   * avatar.png", "altText": "Chat app avatar" } ```
   * @param image image or {@code null} for none
   */
  public GoogleAppsCardV1Widget setImage(GoogleAppsCardV1Image image) {
    this.image = image;
    return this;
  }

  /**
   * Displays a selection control that lets users select items. Selection controls can be
   * checkboxes, radio buttons, switches, or dropdown menus. For example, the following JSON creates
   * a dropdown menu that lets users choose a size: ``` "selectionInput": { "name": "size", "label":
   * "Size" "type": "DROPDOWN", "items": [ { "text": "S", "value": "small", "selected": false }, {
   * "text": "M", "value": "medium", "selected": true }, { "text": "L", "value": "large",
   * "selected": false }, { "text": "XL", "value": "extra_large", "selected": false } ] } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1SelectionInput getSelectionInput() {
    return selectionInput;
  }

  /**
   * Displays a selection control that lets users select items. Selection controls can be
   * checkboxes, radio buttons, switches, or dropdown menus. For example, the following JSON creates
   * a dropdown menu that lets users choose a size: ``` "selectionInput": { "name": "size", "label":
   * "Size" "type": "DROPDOWN", "items": [ { "text": "S", "value": "small", "selected": false }, {
   * "text": "M", "value": "medium", "selected": true }, { "text": "L", "value": "large",
   * "selected": false }, { "text": "XL", "value": "extra_large", "selected": false } ] } ```
   * @param selectionInput selectionInput or {@code null} for none
   */
  public GoogleAppsCardV1Widget setSelectionInput(GoogleAppsCardV1SelectionInput selectionInput) {
    this.selectionInput = selectionInput;
    return this;
  }

  /**
   * Displays a text box that users can type into. For example, the following JSON creates a text
   * input for an email address: ``` "textInput": { "name": "mailing_address", "label": "Mailing
   * Address" } ``` As another example, the following JSON creates a text input for a programming
   * language with static suggestions: ``` "textInput": { "name": "preferred_programing_language",
   * "label": "Preferred Language", "initialSuggestions": { "items": [ { "text": "C++" }, { "text":
   * "Java" }, { "text": "JavaScript" }, { "text": "Python" } ] } } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1TextInput getTextInput() {
    return textInput;
  }

  /**
   * Displays a text box that users can type into. For example, the following JSON creates a text
   * input for an email address: ``` "textInput": { "name": "mailing_address", "label": "Mailing
   * Address" } ``` As another example, the following JSON creates a text input for a programming
   * language with static suggestions: ``` "textInput": { "name": "preferred_programing_language",
   * "label": "Preferred Language", "initialSuggestions": { "items": [ { "text": "C++" }, { "text":
   * "Java" }, { "text": "JavaScript" }, { "text": "Python" } ] } } ```
   * @param textInput textInput or {@code null} for none
   */
  public GoogleAppsCardV1Widget setTextInput(GoogleAppsCardV1TextInput textInput) {
    this.textInput = textInput;
    return this;
  }

  /**
   * Displays a text paragraph. Supports simple HTML formatted text. For more information about
   * formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting) and
   * [Formatting text in Google Workspace add-ons](https://developers.google.com/apps-script/add-
   * ons/concepts/widgets#text_formatting). For example, the following JSON creates a bolded text:
   * ``` "textParagraph": { "text": " *bold text*" } ```
   * @return value or {@code null} for none
   */
  public GoogleAppsCardV1TextParagraph getTextParagraph() {
    return textParagraph;
  }

  /**
   * Displays a text paragraph. Supports simple HTML formatted text. For more information about
   * formatting text, see [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting) and
   * [Formatting text in Google Workspace add-ons](https://developers.google.com/apps-script/add-
   * ons/concepts/widgets#text_formatting). For example, the following JSON creates a bolded text:
   * ``` "textParagraph": { "text": " *bold text*" } ```
   * @param textParagraph textParagraph or {@code null} for none
   */
  public GoogleAppsCardV1Widget setTextParagraph(GoogleAppsCardV1TextParagraph textParagraph) {
    this.textParagraph = textParagraph;
    return this;
  }

  @Override
  public GoogleAppsCardV1Widget set(String fieldName, Object value) {
    return (GoogleAppsCardV1Widget) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCardV1Widget clone() {
    return (GoogleAppsCardV1Widget) super.clone();
  }

}
