/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.chat.v1.model;

/**
 * Data for Meet space links.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Chat API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MeetSpaceLinkData extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Output only. If the Meet is a Huddle, indicates the status of the huddle. Otherwise,
   * this is unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String huddleStatus;

  /**
   * Meeting code of the linked Meet space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String meetingCode;

  /**
   * Indicates the type of the Meet space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. Output only. If the Meet is a Huddle, indicates the status of the huddle. Otherwise,
   * this is unset.
   * @return value or {@code null} for none
   */
  public java.lang.String getHuddleStatus() {
    return huddleStatus;
  }

  /**
   * Optional. Output only. If the Meet is a Huddle, indicates the status of the huddle. Otherwise,
   * this is unset.
   * @param huddleStatus huddleStatus or {@code null} for none
   */
  public MeetSpaceLinkData setHuddleStatus(java.lang.String huddleStatus) {
    this.huddleStatus = huddleStatus;
    return this;
  }

  /**
   * Meeting code of the linked Meet space.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeetingCode() {
    return meetingCode;
  }

  /**
   * Meeting code of the linked Meet space.
   * @param meetingCode meetingCode or {@code null} for none
   */
  public MeetSpaceLinkData setMeetingCode(java.lang.String meetingCode) {
    this.meetingCode = meetingCode;
    return this;
  }

  /**
   * Indicates the type of the Meet space.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Indicates the type of the Meet space.
   * @param type type or {@code null} for none
   */
  public MeetSpaceLinkData setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public MeetSpaceLinkData set(String fieldName, Object value) {
    return (MeetSpaceLinkData) super.set(fieldName, value);
  }

  @Override
  public MeetSpaceLinkData clone() {
    return (MeetSpaceLinkData) super.clone();
  }

}
