/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.classroom;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.classroom.ClassroomRequest;
import com.google.api.services.classroom.ClassroomRequestInitializer;
import com.google.api.services.classroom.model.Announcement;
import com.google.api.services.classroom.model.Course;
import com.google.api.services.classroom.model.CourseAlias;
import com.google.api.services.classroom.model.CourseWork;
import com.google.api.services.classroom.model.Empty;
import com.google.api.services.classroom.model.Guardian;
import com.google.api.services.classroom.model.GuardianInvitation;
import com.google.api.services.classroom.model.Invitation;
import com.google.api.services.classroom.model.ListAnnouncementsResponse;
import com.google.api.services.classroom.model.ListCourseAliasesResponse;
import com.google.api.services.classroom.model.ListCourseWorkResponse;
import com.google.api.services.classroom.model.ListCoursesResponse;
import com.google.api.services.classroom.model.ListGuardianInvitationsResponse;
import com.google.api.services.classroom.model.ListGuardiansResponse;
import com.google.api.services.classroom.model.ListInvitationsResponse;
import com.google.api.services.classroom.model.ListStudentSubmissionsResponse;
import com.google.api.services.classroom.model.ListStudentsResponse;
import com.google.api.services.classroom.model.ListTeachersResponse;
import com.google.api.services.classroom.model.ListTopicResponse;
import com.google.api.services.classroom.model.ModifyAnnouncementAssigneesRequest;
import com.google.api.services.classroom.model.ModifyAttachmentsRequest;
import com.google.api.services.classroom.model.ModifyCourseWorkAssigneesRequest;
import com.google.api.services.classroom.model.ReclaimStudentSubmissionRequest;
import com.google.api.services.classroom.model.Registration;
import com.google.api.services.classroom.model.ReturnStudentSubmissionRequest;
import com.google.api.services.classroom.model.Student;
import com.google.api.services.classroom.model.StudentSubmission;
import com.google.api.services.classroom.model.Teacher;
import com.google.api.services.classroom.model.Topic;
import com.google.api.services.classroom.model.TurnInStudentSubmissionRequest;
import com.google.api.services.classroom.model.UserProfile;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classroom
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://classroom.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://classroom.googleapis.com/";

    public Classroom(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Classroom(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Courses courses() {
        return new Courses();
    }

    public Invitations invitations() {
        return new Invitations();
    }

    public Registrations registrations() {
        return new Registrations();
    }

    public UserProfiles userProfiles() {
        return new UserProfiles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Classroom API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://classroom.googleapis.com/", Classroom.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Classroom.DEFAULT_BATCH_PATH);
        }

        public Classroom build() {
            return new Classroom(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setClassroomRequestInitializer(ClassroomRequestInitializer classroomRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)classroomRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserProfiles {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GuardianInvitations guardianInvitations() {
            return new GuardianInvitations();
        }

        public Guardians guardians() {
            return new Guardians();
        }

        public class Guardians {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListGuardiansResponse> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians";
                @Key
                private String studentId;
                @Key
                private String invitedEmailAddress;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListGuardiansResponse.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public List setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getInvitedEmailAddress() {
                    return this.invitedEmailAddress;
                }

                public List setInvitedEmailAddress(String string) {
                    this.invitedEmailAddress = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<Guardian> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians/{guardianId}";
                @Key
                private String studentId;
                @Key
                private String guardianId;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, Guardian.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                    this.guardianId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter guardianId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Get setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getGuardianId() {
                    return this.guardianId;
                }

                public Get setGuardianId(String string) {
                    this.guardianId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians/{guardianId}";
                @Key
                private String studentId;
                @Key
                private String guardianId;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                    this.guardianId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter guardianId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Delete setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getGuardianId() {
                    return this.guardianId;
                }

                public Delete setGuardianId(String string) {
                    this.guardianId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class GuardianInvitations {
            public Create create(String string, GuardianInvitation guardianInvitation) throws IOException {
                Create create = new Create(string, guardianInvitation);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, GuardianInvitation guardianInvitation) throws IOException {
                Patch patch = new Patch(string, string2, guardianInvitation);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}";
                @Key
                private String studentId;
                @Key
                private String invitationId;
                @Key
                private String updateMask;

                protected Patch(String string, String string2, GuardianInvitation guardianInvitation) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)guardianInvitation, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                    this.invitationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter invitationId must be specified.");
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Patch setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getInvitationId() {
                    return this.invitationId;
                }

                public Patch setInvitationId(String string) {
                    this.invitationId = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListGuardianInvitationsResponse> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations";
                @Key
                private String studentId;
                @Key
                private String pageToken;
                @Key
                private String invitedEmailAddress;
                @Key
                private java.util.List<String> states;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListGuardianInvitationsResponse.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public List setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getInvitedEmailAddress() {
                    return this.invitedEmailAddress;
                }

                public List setInvitedEmailAddress(String string) {
                    this.invitedEmailAddress = string;
                    return this;
                }

                public java.util.List<String> getStates() {
                    return this.states;
                }

                public List setStates(java.util.List<String> list) {
                    this.states = list;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}";
                @Key
                private String studentId;
                @Key
                private String invitationId;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                    this.invitationId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter invitationId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Get setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                public String getInvitationId() {
                    return this.invitationId;
                }

                public Get setInvitationId(String string) {
                    this.invitationId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations";
                @Key
                private String studentId;

                protected Create(String string, GuardianInvitation guardianInvitation) {
                    super(Classroom.this, "POST", REST_PATH, (Object)guardianInvitation, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter studentId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Create setStudentId(String string) {
                    this.studentId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ClassroomRequest<UserProfile> {
            private static final String REST_PATH = "v1/userProfiles/{userId}";
            @Key
            private String userId;

            protected Get(String string) {
                super(Classroom.this, "GET", REST_PATH, null, UserProfile.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Registrations {
        public Create create(Registration registration) throws IOException {
            Create create = new Create(registration);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/registrations/{registrationId}";
            @Key
            private String registrationId;

            protected Delete(String string) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.registrationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter registrationId must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getRegistrationId() {
                return this.registrationId;
            }

            public Delete setRegistrationId(String string) {
                this.registrationId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends ClassroomRequest<Registration> {
            private static final String REST_PATH = "v1/registrations";

            protected Create(Registration registration) {
                super(Classroom.this, "POST", REST_PATH, (Object)registration, Registration.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Invitations {
        public Accept accept(String string) throws IOException {
            Accept accept = new Accept(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)accept);
            return accept;
        }

        public Create create(Invitation invitation) throws IOException {
            Create create = new Create(invitation);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ClassroomRequest<ListInvitationsResponse> {
            private static final String REST_PATH = "v1/invitations";
            @Key
            private String userId;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String courseId;

            protected List() {
                super(Classroom.this, "GET", REST_PATH, null, ListInvitationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getCourseId() {
                return this.courseId;
            }

            public List setCourseId(String string) {
                this.courseId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ClassroomRequest<Invitation> {
            private static final String REST_PATH = "v1/invitations/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(Classroom.this, "GET", REST_PATH, null, Invitation.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/invitations/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends ClassroomRequest<Invitation> {
            private static final String REST_PATH = "v1/invitations";

            protected Create(Invitation invitation) {
                super(Classroom.this, "POST", REST_PATH, (Object)invitation, Invitation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Accept
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/invitations/{id}:accept";
            @Key
            private String id;

            protected Accept(String string) {
                super(Classroom.this, "POST", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Accept set$Xgafv(String string) {
                return (Accept)super.set$Xgafv(string);
            }

            public Accept setAccessToken(String string) {
                return (Accept)super.setAccessToken(string);
            }

            public Accept setAlt(String string) {
                return (Accept)super.setAlt(string);
            }

            public Accept setBearerToken(String string) {
                return (Accept)super.setBearerToken(string);
            }

            public Accept setCallback(String string) {
                return (Accept)super.setCallback(string);
            }

            public Accept setFields(String string) {
                return (Accept)super.setFields(string);
            }

            public Accept setKey(String string) {
                return (Accept)super.setKey(string);
            }

            public Accept setOauthToken(String string) {
                return (Accept)super.setOauthToken(string);
            }

            public Accept setPp(Boolean bl) {
                return (Accept)super.setPp(bl);
            }

            public Accept setPrettyPrint(Boolean bl) {
                return (Accept)super.setPrettyPrint(bl);
            }

            public Accept setQuotaUser(String string) {
                return (Accept)super.setQuotaUser(string);
            }

            public Accept setUploadType(String string) {
                return (Accept)super.setUploadType(string);
            }

            public Accept setUploadProtocol(String string) {
                return (Accept)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Accept setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Accept set(String string, Object object) {
                return (Accept)super.set(string, object);
            }
        }
    }

    public class Courses {
        public Create create(Course course) throws IOException {
            Create create = new Create(course);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Course course) throws IOException {
            Patch patch = new Patch(string, course);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Course course) throws IOException {
            Update update = new Update(string, course);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public Announcements announcements() {
            return new Announcements();
        }

        public CourseWork courseWork() {
            return new CourseWork();
        }

        public Students students() {
            return new Students();
        }

        public Teachers teachers() {
            return new Teachers();
        }

        public Topics topics() {
            return new Topics();
        }

        public class Topics {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListTopicResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics";
                @Key
                private String courseId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListTopicResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<Topic> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, Topic.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Teachers {
            public Create create(String string, Teacher teacher) throws IOException {
                Create create = new Create(string, teacher);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListTeachersResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers";
                @Key
                private String courseId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListTeachersResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<Teacher> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, Teacher.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter userId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<Teacher> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers";
                @Key
                private String courseId;

                protected Create(String string, Teacher teacher) {
                    super(Classroom.this, "POST", REST_PATH, (Object)teacher, Teacher.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Students {
            public Create create(String string, Student student) throws IOException {
                Create create = new Create(string, student);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListStudentsResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/students";
                @Key
                private String courseId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListStudentsResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<Student> {
                private static final String REST_PATH = "v1/courses/{courseId}/students/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, Student.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/students/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter userId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<Student> {
                private static final String REST_PATH = "v1/courses/{courseId}/students";
                @Key
                private String courseId;
                @Key
                private String enrollmentCode;

                protected Create(String string, Student student) {
                    super(Classroom.this, "POST", REST_PATH, (Object)student, Student.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getEnrollmentCode() {
                    return this.enrollmentCode;
                }

                public Create setEnrollmentCode(String string) {
                    this.enrollmentCode = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class CourseWork {
            public Create create(String string, com.google.api.services.classroom.model.CourseWork courseWork) throws IOException {
                Create create = new Create(string, courseWork);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public ModifyAssignees modifyAssignees(String string, String string2, ModifyCourseWorkAssigneesRequest modifyCourseWorkAssigneesRequest) throws IOException {
                ModifyAssignees modifyAssignees = new ModifyAssignees(string, string2, modifyCourseWorkAssigneesRequest);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)modifyAssignees);
                return modifyAssignees;
            }

            public Patch patch(String string, String string2, com.google.api.services.classroom.model.CourseWork courseWork) throws IOException {
                Patch patch = new Patch(string, string2, courseWork);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public StudentSubmissions studentSubmissions() {
                return new StudentSubmissions();
            }

            public class StudentSubmissions {
                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public ModifyAttachments modifyAttachments(String string, String string2, String string3, ModifyAttachmentsRequest modifyAttachmentsRequest) throws IOException {
                    ModifyAttachments modifyAttachments = new ModifyAttachments(string, string2, string3, modifyAttachmentsRequest);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)modifyAttachments);
                    return modifyAttachments;
                }

                public Patch patch(String string, String string2, String string3, StudentSubmission studentSubmission) throws IOException {
                    Patch patch = new Patch(string, string2, string3, studentSubmission);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Reclaim reclaim(String string, String string2, String string3, ReclaimStudentSubmissionRequest reclaimStudentSubmissionRequest) throws IOException {
                    Reclaim reclaim = new Reclaim(string, string2, string3, reclaimStudentSubmissionRequest);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)reclaim);
                    return reclaim;
                }

                public ClassroomReturn classroomReturn(String string, String string2, String string3, ReturnStudentSubmissionRequest returnStudentSubmissionRequest) throws IOException {
                    ClassroomReturn classroomReturn = new ClassroomReturn(string, string2, string3, returnStudentSubmissionRequest);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)classroomReturn);
                    return classroomReturn;
                }

                public TurnIn turnIn(String string, String string2, String string3, TurnInStudentSubmissionRequest turnInStudentSubmissionRequest) throws IOException {
                    TurnIn turnIn = new TurnIn(string, string2, string3, turnInStudentSubmissionRequest);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)turnIn);
                    return turnIn;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class TurnIn
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:turnIn";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected TurnIn(String string, String string2, String string3, TurnInStudentSubmissionRequest turnInStudentSubmissionRequest) {
                        super(Classroom.this, "POST", REST_PATH, (Object)turnInStudentSubmissionRequest, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public TurnIn set$Xgafv(String string) {
                        return (TurnIn)super.set$Xgafv(string);
                    }

                    public TurnIn setAccessToken(String string) {
                        return (TurnIn)super.setAccessToken(string);
                    }

                    public TurnIn setAlt(String string) {
                        return (TurnIn)super.setAlt(string);
                    }

                    public TurnIn setBearerToken(String string) {
                        return (TurnIn)super.setBearerToken(string);
                    }

                    public TurnIn setCallback(String string) {
                        return (TurnIn)super.setCallback(string);
                    }

                    public TurnIn setFields(String string) {
                        return (TurnIn)super.setFields(string);
                    }

                    public TurnIn setKey(String string) {
                        return (TurnIn)super.setKey(string);
                    }

                    public TurnIn setOauthToken(String string) {
                        return (TurnIn)super.setOauthToken(string);
                    }

                    public TurnIn setPp(Boolean bl) {
                        return (TurnIn)super.setPp(bl);
                    }

                    public TurnIn setPrettyPrint(Boolean bl) {
                        return (TurnIn)super.setPrettyPrint(bl);
                    }

                    public TurnIn setQuotaUser(String string) {
                        return (TurnIn)super.setQuotaUser(string);
                    }

                    public TurnIn setUploadType(String string) {
                        return (TurnIn)super.setUploadType(string);
                    }

                    public TurnIn setUploadProtocol(String string) {
                        return (TurnIn)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public TurnIn setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public TurnIn setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public TurnIn setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public TurnIn set(String string, Object object) {
                        return (TurnIn)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class ClassroomReturn
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:return";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected ClassroomReturn(String string, String string2, String string3, ReturnStudentSubmissionRequest returnStudentSubmissionRequest) {
                        super(Classroom.this, "POST", REST_PATH, (Object)returnStudentSubmissionRequest, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public ClassroomReturn set$Xgafv(String string) {
                        return (ClassroomReturn)super.set$Xgafv(string);
                    }

                    public ClassroomReturn setAccessToken(String string) {
                        return (ClassroomReturn)super.setAccessToken(string);
                    }

                    public ClassroomReturn setAlt(String string) {
                        return (ClassroomReturn)super.setAlt(string);
                    }

                    public ClassroomReturn setBearerToken(String string) {
                        return (ClassroomReturn)super.setBearerToken(string);
                    }

                    public ClassroomReturn setCallback(String string) {
                        return (ClassroomReturn)super.setCallback(string);
                    }

                    public ClassroomReturn setFields(String string) {
                        return (ClassroomReturn)super.setFields(string);
                    }

                    public ClassroomReturn setKey(String string) {
                        return (ClassroomReturn)super.setKey(string);
                    }

                    public ClassroomReturn setOauthToken(String string) {
                        return (ClassroomReturn)super.setOauthToken(string);
                    }

                    public ClassroomReturn setPp(Boolean bl) {
                        return (ClassroomReturn)super.setPp(bl);
                    }

                    public ClassroomReturn setPrettyPrint(Boolean bl) {
                        return (ClassroomReturn)super.setPrettyPrint(bl);
                    }

                    public ClassroomReturn setQuotaUser(String string) {
                        return (ClassroomReturn)super.setQuotaUser(string);
                    }

                    public ClassroomReturn setUploadType(String string) {
                        return (ClassroomReturn)super.setUploadType(string);
                    }

                    public ClassroomReturn setUploadProtocol(String string) {
                        return (ClassroomReturn)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public ClassroomReturn setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public ClassroomReturn setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public ClassroomReturn setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public ClassroomReturn set(String string, Object object) {
                        return (ClassroomReturn)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Reclaim
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:reclaim";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected Reclaim(String string, String string2, String string3, ReclaimStudentSubmissionRequest reclaimStudentSubmissionRequest) {
                        super(Classroom.this, "POST", REST_PATH, (Object)reclaimStudentSubmissionRequest, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public Reclaim set$Xgafv(String string) {
                        return (Reclaim)super.set$Xgafv(string);
                    }

                    public Reclaim setAccessToken(String string) {
                        return (Reclaim)super.setAccessToken(string);
                    }

                    public Reclaim setAlt(String string) {
                        return (Reclaim)super.setAlt(string);
                    }

                    public Reclaim setBearerToken(String string) {
                        return (Reclaim)super.setBearerToken(string);
                    }

                    public Reclaim setCallback(String string) {
                        return (Reclaim)super.setCallback(string);
                    }

                    public Reclaim setFields(String string) {
                        return (Reclaim)super.setFields(string);
                    }

                    public Reclaim setKey(String string) {
                        return (Reclaim)super.setKey(string);
                    }

                    public Reclaim setOauthToken(String string) {
                        return (Reclaim)super.setOauthToken(string);
                    }

                    public Reclaim setPp(Boolean bl) {
                        return (Reclaim)super.setPp(bl);
                    }

                    public Reclaim setPrettyPrint(Boolean bl) {
                        return (Reclaim)super.setPrettyPrint(bl);
                    }

                    public Reclaim setQuotaUser(String string) {
                        return (Reclaim)super.setQuotaUser(string);
                    }

                    public Reclaim setUploadType(String string) {
                        return (Reclaim)super.setUploadType(string);
                    }

                    public Reclaim setUploadProtocol(String string) {
                        return (Reclaim)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Reclaim setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Reclaim setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Reclaim setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Reclaim set(String string, Object object) {
                        return (Reclaim)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;
                    @Key
                    private String updateMask;

                    protected Patch(String string, String string2, String string3, StudentSubmission studentSubmission) {
                        super(Classroom.this, "PATCH", REST_PATH, (Object)studentSubmission, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Patch setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Patch setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Patch setId(String string) {
                        this.id = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class ModifyAttachments
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:modifyAttachments";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected ModifyAttachments(String string, String string2, String string3, ModifyAttachmentsRequest modifyAttachmentsRequest) {
                        super(Classroom.this, "POST", REST_PATH, (Object)modifyAttachmentsRequest, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public ModifyAttachments set$Xgafv(String string) {
                        return (ModifyAttachments)super.set$Xgafv(string);
                    }

                    public ModifyAttachments setAccessToken(String string) {
                        return (ModifyAttachments)super.setAccessToken(string);
                    }

                    public ModifyAttachments setAlt(String string) {
                        return (ModifyAttachments)super.setAlt(string);
                    }

                    public ModifyAttachments setBearerToken(String string) {
                        return (ModifyAttachments)super.setBearerToken(string);
                    }

                    public ModifyAttachments setCallback(String string) {
                        return (ModifyAttachments)super.setCallback(string);
                    }

                    public ModifyAttachments setFields(String string) {
                        return (ModifyAttachments)super.setFields(string);
                    }

                    public ModifyAttachments setKey(String string) {
                        return (ModifyAttachments)super.setKey(string);
                    }

                    public ModifyAttachments setOauthToken(String string) {
                        return (ModifyAttachments)super.setOauthToken(string);
                    }

                    public ModifyAttachments setPp(Boolean bl) {
                        return (ModifyAttachments)super.setPp(bl);
                    }

                    public ModifyAttachments setPrettyPrint(Boolean bl) {
                        return (ModifyAttachments)super.setPrettyPrint(bl);
                    }

                    public ModifyAttachments setQuotaUser(String string) {
                        return (ModifyAttachments)super.setQuotaUser(string);
                    }

                    public ModifyAttachments setUploadType(String string) {
                        return (ModifyAttachments)super.setUploadType(string);
                    }

                    public ModifyAttachments setUploadProtocol(String string) {
                        return (ModifyAttachments)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public ModifyAttachments setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public ModifyAttachments setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public ModifyAttachments setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public ModifyAttachments set(String string, Object object) {
                        return (ModifyAttachments)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ClassroomRequest<ListStudentSubmissionsResponse> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String late;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private java.util.List<String> states;
                    @Key
                    private String userId;

                    protected List(String string, String string2) {
                        super(Classroom.this, "GET", REST_PATH, null, ListStudentSubmissionsResponse.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public List setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public List setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getLate() {
                        return this.late;
                    }

                    public List setLate(String string) {
                        this.late = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public java.util.List<String> getStates() {
                        return this.states;
                    }

                    public List setStates(java.util.List<String> list) {
                        this.states = list;
                        return this;
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected Get(String string, String string2, String string3) {
                        super(Classroom.this, "GET", REST_PATH, null, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Get setCourseId(String string) {
                        this.courseId = string;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Get setCourseWorkId(String string) {
                        this.courseWorkId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;
                @Key
                private String updateMask;

                protected Patch(String string, String string2, com.google.api.services.classroom.model.CourseWork courseWork2) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)courseWork2, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Patch setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class ModifyAssignees
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}:modifyAssignees";
                @Key
                private String courseId;
                @Key
                private String id;

                protected ModifyAssignees(String string, String string2, ModifyCourseWorkAssigneesRequest modifyCourseWorkAssigneesRequest) {
                    super(Classroom.this, "POST", REST_PATH, (Object)modifyCourseWorkAssigneesRequest, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public ModifyAssignees set$Xgafv(String string) {
                    return (ModifyAssignees)super.set$Xgafv(string);
                }

                public ModifyAssignees setAccessToken(String string) {
                    return (ModifyAssignees)super.setAccessToken(string);
                }

                public ModifyAssignees setAlt(String string) {
                    return (ModifyAssignees)super.setAlt(string);
                }

                public ModifyAssignees setBearerToken(String string) {
                    return (ModifyAssignees)super.setBearerToken(string);
                }

                public ModifyAssignees setCallback(String string) {
                    return (ModifyAssignees)super.setCallback(string);
                }

                public ModifyAssignees setFields(String string) {
                    return (ModifyAssignees)super.setFields(string);
                }

                public ModifyAssignees setKey(String string) {
                    return (ModifyAssignees)super.setKey(string);
                }

                public ModifyAssignees setOauthToken(String string) {
                    return (ModifyAssignees)super.setOauthToken(string);
                }

                public ModifyAssignees setPp(Boolean bl) {
                    return (ModifyAssignees)super.setPp(bl);
                }

                public ModifyAssignees setPrettyPrint(Boolean bl) {
                    return (ModifyAssignees)super.setPrettyPrint(bl);
                }

                public ModifyAssignees setQuotaUser(String string) {
                    return (ModifyAssignees)super.setQuotaUser(string);
                }

                public ModifyAssignees setUploadType(String string) {
                    return (ModifyAssignees)super.setUploadType(string);
                }

                public ModifyAssignees setUploadProtocol(String string) {
                    return (ModifyAssignees)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public ModifyAssignees setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public ModifyAssignees setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public ModifyAssignees set(String string, Object object) {
                    return (ModifyAssignees)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListCourseWorkResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork";
                @Key
                private String courseId;
                @Key
                private String orderBy;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private java.util.List<String> courseWorkStates;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListCourseWorkResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String string) {
                    this.orderBy = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public java.util.List<String> getCourseWorkStates() {
                    return this.courseWorkStates;
                }

                public List setCourseWorkStates(java.util.List<String> list) {
                    this.courseWorkStates = list;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork";
                @Key
                private String courseId;

                protected Create(String string, com.google.api.services.classroom.model.CourseWork courseWork2) {
                    super(Classroom.this, "POST", REST_PATH, (Object)courseWork2, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Announcements {
            public Create create(String string, Announcement announcement) throws IOException {
                Create create = new Create(string, announcement);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public ModifyAssignees modifyAssignees(String string, String string2, ModifyAnnouncementAssigneesRequest modifyAnnouncementAssigneesRequest) throws IOException {
                ModifyAssignees modifyAssignees = new ModifyAssignees(string, string2, modifyAnnouncementAssigneesRequest);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)modifyAssignees);
                return modifyAssignees;
            }

            public Patch patch(String string, String string2, Announcement announcement) throws IOException {
                Patch patch = new Patch(string, string2, announcement);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;
                @Key
                private String updateMask;

                protected Patch(String string, String string2, Announcement announcement) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)announcement, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Patch setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class ModifyAssignees
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}:modifyAssignees";
                @Key
                private String courseId;
                @Key
                private String id;

                protected ModifyAssignees(String string, String string2, ModifyAnnouncementAssigneesRequest modifyAnnouncementAssigneesRequest) {
                    super(Classroom.this, "POST", REST_PATH, (Object)modifyAnnouncementAssigneesRequest, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public ModifyAssignees set$Xgafv(String string) {
                    return (ModifyAssignees)super.set$Xgafv(string);
                }

                public ModifyAssignees setAccessToken(String string) {
                    return (ModifyAssignees)super.setAccessToken(string);
                }

                public ModifyAssignees setAlt(String string) {
                    return (ModifyAssignees)super.setAlt(string);
                }

                public ModifyAssignees setBearerToken(String string) {
                    return (ModifyAssignees)super.setBearerToken(string);
                }

                public ModifyAssignees setCallback(String string) {
                    return (ModifyAssignees)super.setCallback(string);
                }

                public ModifyAssignees setFields(String string) {
                    return (ModifyAssignees)super.setFields(string);
                }

                public ModifyAssignees setKey(String string) {
                    return (ModifyAssignees)super.setKey(string);
                }

                public ModifyAssignees setOauthToken(String string) {
                    return (ModifyAssignees)super.setOauthToken(string);
                }

                public ModifyAssignees setPp(Boolean bl) {
                    return (ModifyAssignees)super.setPp(bl);
                }

                public ModifyAssignees setPrettyPrint(Boolean bl) {
                    return (ModifyAssignees)super.setPrettyPrint(bl);
                }

                public ModifyAssignees setQuotaUser(String string) {
                    return (ModifyAssignees)super.setQuotaUser(string);
                }

                public ModifyAssignees setUploadType(String string) {
                    return (ModifyAssignees)super.setUploadType(string);
                }

                public ModifyAssignees setUploadProtocol(String string) {
                    return (ModifyAssignees)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public ModifyAssignees setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public ModifyAssignees setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public ModifyAssignees set(String string, Object object) {
                    return (ModifyAssignees)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListAnnouncementsResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements";
                @Key
                private String courseId;
                @Key
                private String orderBy;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private java.util.List<String> announcementStates;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListAnnouncementsResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String string) {
                    this.orderBy = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public java.util.List<String> getAnnouncementStates() {
                    return this.announcementStates;
                }

                public List setAnnouncementStates(java.util.List<String> list) {
                    this.announcementStates = list;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(Classroom.this, "GET", REST_PATH, null, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements";
                @Key
                private String courseId;

                protected Create(String string, Announcement announcement) {
                    super(Classroom.this, "POST", REST_PATH, (Object)announcement, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Aliases {
            public Create create(String string, CourseAlias courseAlias) throws IOException {
                Create create = new Create(string, courseAlias);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClassroomRequest<ListCourseAliasesResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases";
                @Key
                private String courseId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Classroom.this, "GET", REST_PATH, null, ListCourseAliasesResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases/{alias}";
                @Key
                private String courseId;
                @Key
                private String alias;

                protected Delete(String string, String string2) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter alias must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String string) {
                    this.alias = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ClassroomRequest<CourseAlias> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases";
                @Key
                private String courseId;

                protected Create(String string, CourseAlias courseAlias) {
                    super(Classroom.this, "POST", REST_PATH, (Object)courseAlias, CourseAlias.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String string) {
                    this.courseId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Update(String string, Course course) {
                super(Classroom.this, "PUT", REST_PATH, (Object)course, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Update set$Xgafv(String string) {
                return (Update)super.set$Xgafv(string);
            }

            public Update setAccessToken(String string) {
                return (Update)super.setAccessToken(string);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setBearerToken(String string) {
                return (Update)super.setBearerToken(string);
            }

            public Update setCallback(String string) {
                return (Update)super.setCallback(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPp(Boolean bl) {
                return (Update)super.setPp(bl);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUploadType(String string) {
                return (Update)super.setUploadType(string);
            }

            public Update setUploadProtocol(String string) {
                return (Update)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;
            @Key
            private String updateMask;

            protected Patch(String string, Course course) {
                super(Classroom.this, "PATCH", REST_PATH, (Object)course, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch set$Xgafv(String string) {
                return (Patch)super.set$Xgafv(string);
            }

            public Patch setAccessToken(String string) {
                return (Patch)super.setAccessToken(string);
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setBearerToken(String string) {
                return (Patch)super.setBearerToken(string);
            }

            public Patch setCallback(String string) {
                return (Patch)super.setCallback(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPp(Boolean bl) {
                return (Patch)super.setPp(bl);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUploadType(String string) {
                return (Patch)super.setUploadType(string);
            }

            public Patch setUploadProtocol(String string) {
                return (Patch)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String string) {
                this.updateMask = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ClassroomRequest<ListCoursesResponse> {
            private static final String REST_PATH = "v1/courses";
            @Key
            private String teacherId;
            @Key
            private java.util.List<String> courseStates;
            @Key
            private String studentId;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Classroom.this, "GET", REST_PATH, null, ListCoursesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getTeacherId() {
                return this.teacherId;
            }

            public List setTeacherId(String string) {
                this.teacherId = string;
                return this;
            }

            public java.util.List<String> getCourseStates() {
                return this.courseStates;
            }

            public List setCourseStates(java.util.List<String> list) {
                this.courseStates = list;
                return this;
            }

            public String getStudentId() {
                return this.studentId;
            }

            public List setStudentId(String string) {
                this.studentId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(Classroom.this, "GET", REST_PATH, null, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses";

            protected Create(Course course) {
                super(Classroom.this, "POST", REST_PATH, (Object)course, Course.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }
}

