/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.classroom;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.classroom.ClassroomRequest;
import com.google.api.services.classroom.ClassroomRequestInitializer;
import com.google.api.services.classroom.model.Announcement;
import com.google.api.services.classroom.model.Course;
import com.google.api.services.classroom.model.CourseAlias;
import com.google.api.services.classroom.model.CourseWork;
import com.google.api.services.classroom.model.Empty;
import com.google.api.services.classroom.model.Guardian;
import com.google.api.services.classroom.model.GuardianInvitation;
import com.google.api.services.classroom.model.Invitation;
import com.google.api.services.classroom.model.ListAnnouncementsResponse;
import com.google.api.services.classroom.model.ListCourseAliasesResponse;
import com.google.api.services.classroom.model.ListCourseWorkResponse;
import com.google.api.services.classroom.model.ListCoursesResponse;
import com.google.api.services.classroom.model.ListGuardianInvitationsResponse;
import com.google.api.services.classroom.model.ListGuardiansResponse;
import com.google.api.services.classroom.model.ListInvitationsResponse;
import com.google.api.services.classroom.model.ListStudentSubmissionsResponse;
import com.google.api.services.classroom.model.ListStudentsResponse;
import com.google.api.services.classroom.model.ListTeachersResponse;
import com.google.api.services.classroom.model.ListTopicResponse;
import com.google.api.services.classroom.model.ModifyAnnouncementAssigneesRequest;
import com.google.api.services.classroom.model.ModifyAttachmentsRequest;
import com.google.api.services.classroom.model.ModifyCourseWorkAssigneesRequest;
import com.google.api.services.classroom.model.ReclaimStudentSubmissionRequest;
import com.google.api.services.classroom.model.Registration;
import com.google.api.services.classroom.model.ReturnStudentSubmissionRequest;
import com.google.api.services.classroom.model.Student;
import com.google.api.services.classroom.model.StudentSubmission;
import com.google.api.services.classroom.model.Teacher;
import com.google.api.services.classroom.model.Topic;
import com.google.api.services.classroom.model.TurnInStudentSubmissionRequest;
import com.google.api.services.classroom.model.UserProfile;
import java.io.IOException;
import java.util.List;

public class Classroom
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://classroom.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://classroom.googleapis.com/";

    public Classroom(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Classroom(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Courses courses() {
        return new Courses();
    }

    public Invitations invitations() {
        return new Invitations();
    }

    public Registrations registrations() {
        return new Registrations();
    }

    public UserProfiles userProfiles() {
        return new UserProfiles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Google Classroom API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://classroom.googleapis.com/", Classroom.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Classroom.DEFAULT_BATCH_PATH);
        }

        public Classroom build() {
            return new Classroom(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setClassroomRequestInitializer(ClassroomRequestInitializer classroomRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)classroomRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserProfiles {
        public Get get(String userId) throws IOException {
            Get result = new Get(userId);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GuardianInvitations guardianInvitations() {
            return new GuardianInvitations();
        }

        public Guardians guardians() {
            return new Guardians();
        }

        public class Guardians {
            public Delete delete(String studentId, String guardianId) throws IOException {
                Delete result = new Delete(studentId, guardianId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String studentId, String guardianId) throws IOException {
                Get result = new Get(studentId, guardianId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String studentId) throws IOException {
                List result = new List(studentId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ClassroomRequest<ListGuardiansResponse> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians";
                @Key
                private String studentId;
                @Key
                private String invitedEmailAddress;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String studentId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListGuardiansResponse.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public List setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getInvitedEmailAddress() {
                    return this.invitedEmailAddress;
                }

                public List setInvitedEmailAddress(String invitedEmailAddress) {
                    this.invitedEmailAddress = invitedEmailAddress;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<Guardian> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians/{guardianId}";
                @Key
                private String studentId;
                @Key
                private String guardianId;

                protected Get(String studentId, String guardianId) {
                    super(Classroom.this, "GET", REST_PATH, null, Guardian.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                    this.guardianId = (String)Preconditions.checkNotNull((Object)guardianId, (Object)"Required parameter guardianId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Get setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getGuardianId() {
                    return this.guardianId;
                }

                public Get setGuardianId(String guardianId) {
                    this.guardianId = guardianId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardians/{guardianId}";
                @Key
                private String studentId;
                @Key
                private String guardianId;

                protected Delete(String studentId, String guardianId) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                    this.guardianId = (String)Preconditions.checkNotNull((Object)guardianId, (Object)"Required parameter guardianId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Delete setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getGuardianId() {
                    return this.guardianId;
                }

                public Delete setGuardianId(String guardianId) {
                    this.guardianId = guardianId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class GuardianInvitations {
            public Create create(String studentId, GuardianInvitation content) throws IOException {
                Create result = new Create(studentId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String studentId, String invitationId) throws IOException {
                Get result = new Get(studentId, invitationId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String studentId) throws IOException {
                List result = new List(studentId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String studentId, String invitationId, GuardianInvitation content) throws IOException {
                Patch result = new Patch(studentId, invitationId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}";
                @Key
                private String studentId;
                @Key
                private String invitationId;
                @Key
                private String updateMask;

                protected Patch(String studentId, String invitationId, GuardianInvitation content) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)content, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                    this.invitationId = (String)Preconditions.checkNotNull((Object)invitationId, (Object)"Required parameter invitationId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Patch setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getInvitationId() {
                    return this.invitationId;
                }

                public Patch setInvitationId(String invitationId) {
                    this.invitationId = invitationId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ClassroomRequest<ListGuardianInvitationsResponse> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations";
                @Key
                private String studentId;
                @Key
                private String invitedEmailAddress;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private java.util.List<String> states;

                protected List(String studentId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListGuardianInvitationsResponse.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public List setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getInvitedEmailAddress() {
                    return this.invitedEmailAddress;
                }

                public List setInvitedEmailAddress(String invitedEmailAddress) {
                    this.invitedEmailAddress = invitedEmailAddress;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public java.util.List<String> getStates() {
                    return this.states;
                }

                public List setStates(java.util.List<String> states) {
                    this.states = states;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations/{invitationId}";
                @Key
                private String studentId;
                @Key
                private String invitationId;

                protected Get(String studentId, String invitationId) {
                    super(Classroom.this, "GET", REST_PATH, null, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                    this.invitationId = (String)Preconditions.checkNotNull((Object)invitationId, (Object)"Required parameter invitationId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Get setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                public String getInvitationId() {
                    return this.invitationId;
                }

                public Get setInvitationId(String invitationId) {
                    this.invitationId = invitationId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<GuardianInvitation> {
                private static final String REST_PATH = "v1/userProfiles/{studentId}/guardianInvitations";
                @Key
                private String studentId;

                protected Create(String studentId, GuardianInvitation content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, GuardianInvitation.class);
                    this.studentId = (String)Preconditions.checkNotNull((Object)studentId, (Object)"Required parameter studentId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getStudentId() {
                    return this.studentId;
                }

                public Create setStudentId(String studentId) {
                    this.studentId = studentId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Get
        extends ClassroomRequest<UserProfile> {
            private static final String REST_PATH = "v1/userProfiles/{userId}";
            @Key
            private String userId;

            protected Get(String userId) {
                super(Classroom.this, "GET", REST_PATH, null, UserProfile.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Registrations {
        public Create create(Registration content) throws IOException {
            Create result = new Create(content);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String registrationId) throws IOException {
            Delete result = new Delete(registrationId);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/registrations/{registrationId}";
            @Key
            private String registrationId;

            protected Delete(String registrationId) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.registrationId = (String)Preconditions.checkNotNull((Object)registrationId, (Object)"Required parameter registrationId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getRegistrationId() {
                return this.registrationId;
            }

            public Delete setRegistrationId(String registrationId) {
                this.registrationId = registrationId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ClassroomRequest<Registration> {
            private static final String REST_PATH = "v1/registrations";

            protected Create(Registration content) {
                super(Classroom.this, "POST", REST_PATH, (Object)content, Registration.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Invitations {
        public Accept accept(String id) throws IOException {
            Accept result = new Accept(id);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Invitation content) throws IOException {
            Create result = new Create(content);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String id) throws IOException {
            Get result = new Get(id);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ClassroomRequest<ListInvitationsResponse> {
            private static final String REST_PATH = "v1/invitations";
            @Key
            private String courseId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String userId;

            protected List() {
                super(Classroom.this, "GET", REST_PATH, null, ListInvitationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCourseId() {
                return this.courseId;
            }

            public List setCourseId(String courseId) {
                this.courseId = courseId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ClassroomRequest<Invitation> {
            private static final String REST_PATH = "v1/invitations/{id}";
            @Key
            private String id;

            protected Get(String id) {
                super(Classroom.this, "GET", REST_PATH, null, Invitation.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/invitations/{id}";
            @Key
            private String id;

            protected Delete(String id) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ClassroomRequest<Invitation> {
            private static final String REST_PATH = "v1/invitations";

            protected Create(Invitation content) {
                super(Classroom.this, "POST", REST_PATH, (Object)content, Invitation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Accept
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/invitations/{id}:accept";
            @Key
            private String id;

            protected Accept(String id) {
                super(Classroom.this, "POST", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Accept set$Xgafv(String $Xgafv) {
                return (Accept)super.set$Xgafv($Xgafv);
            }

            public Accept setAccessToken(String accessToken) {
                return (Accept)super.setAccessToken(accessToken);
            }

            public Accept setAlt(String alt) {
                return (Accept)super.setAlt(alt);
            }

            public Accept setCallback(String callback) {
                return (Accept)super.setCallback(callback);
            }

            public Accept setFields(String fields) {
                return (Accept)super.setFields(fields);
            }

            public Accept setKey(String key) {
                return (Accept)super.setKey(key);
            }

            public Accept setOauthToken(String oauthToken) {
                return (Accept)super.setOauthToken(oauthToken);
            }

            public Accept setPrettyPrint(Boolean prettyPrint) {
                return (Accept)super.setPrettyPrint(prettyPrint);
            }

            public Accept setQuotaUser(String quotaUser) {
                return (Accept)super.setQuotaUser(quotaUser);
            }

            public Accept setUploadType(String uploadType) {
                return (Accept)super.setUploadType(uploadType);
            }

            public Accept setUploadProtocol(String uploadProtocol) {
                return (Accept)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Accept setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Accept set(String parameterName, Object value) {
                return (Accept)super.set(parameterName, value);
            }
        }
    }

    public class Courses {
        public Create create(Course content) throws IOException {
            Create result = new Create(content);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String id) throws IOException {
            Get result = new Get(id);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String id, Course content) throws IOException {
            Patch result = new Patch(id, content);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String id, Course content) throws IOException {
            Update result = new Update(id, content);
            Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public Announcements announcements() {
            return new Announcements();
        }

        public CourseWork courseWork() {
            return new CourseWork();
        }

        public Students students() {
            return new Students();
        }

        public Teachers teachers() {
            return new Teachers();
        }

        public Topics topics() {
            return new Topics();
        }

        public class Topics {
            public Create create(String courseId, Topic content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String id) throws IOException {
                Delete result = new Delete(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String courseId, String id) throws IOException {
                Get result = new Get(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String courseId, String id, Topic content) throws IOException {
                Patch result = new Patch(courseId, id, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ClassroomRequest<Topic> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics/{id}";
                @Key
                private String courseId;
                @Key
                private String id;
                @Key
                private String updateMask;

                protected Patch(String courseId, String id, Topic content) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)content, Topic.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Patch setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ClassroomRequest<ListTopicResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics";
                @Key
                private String courseId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListTopicResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<Topic> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String courseId, String id) {
                    super(Classroom.this, "GET", REST_PATH, null, Topic.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Delete(String courseId, String id) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<Topic> {
                private static final String REST_PATH = "v1/courses/{courseId}/topics";
                @Key
                private String courseId;

                protected Create(String courseId, Topic content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, Topic.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Teachers {
            public Create create(String courseId, Teacher content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String userId) throws IOException {
                Delete result = new Delete(courseId, userId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String courseId, String userId) throws IOException {
                Get result = new Get(courseId, userId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ClassroomRequest<ListTeachersResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers";
                @Key
                private String courseId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListTeachersResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<Teacher> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Get(String courseId, String userId) {
                    super(Classroom.this, "GET", REST_PATH, null, Teacher.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Delete(String courseId, String userId) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<Teacher> {
                private static final String REST_PATH = "v1/courses/{courseId}/teachers";
                @Key
                private String courseId;

                protected Create(String courseId, Teacher content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, Teacher.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Students {
            public Create create(String courseId, Student content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String userId) throws IOException {
                Delete result = new Delete(courseId, userId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String courseId, String userId) throws IOException {
                Get result = new Get(courseId, userId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ClassroomRequest<ListStudentsResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/students";
                @Key
                private String courseId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListStudentsResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<Student> {
                private static final String REST_PATH = "v1/courses/{courseId}/students/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Get(String courseId, String userId) {
                    super(Classroom.this, "GET", REST_PATH, null, Student.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/students/{userId}";
                @Key
                private String courseId;
                @Key
                private String userId;

                protected Delete(String courseId, String userId) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<Student> {
                private static final String REST_PATH = "v1/courses/{courseId}/students";
                @Key
                private String courseId;
                @Key
                private String enrollmentCode;

                protected Create(String courseId, Student content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, Student.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getEnrollmentCode() {
                    return this.enrollmentCode;
                }

                public Create setEnrollmentCode(String enrollmentCode) {
                    this.enrollmentCode = enrollmentCode;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class CourseWork {
            public Create create(String courseId, com.google.api.services.classroom.model.CourseWork content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String id) throws IOException {
                Delete result = new Delete(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String courseId, String id) throws IOException {
                Get result = new Get(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ModifyAssignees modifyAssignees(String courseId, String id, ModifyCourseWorkAssigneesRequest content) throws IOException {
                ModifyAssignees result = new ModifyAssignees(courseId, id, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String courseId, String id, com.google.api.services.classroom.model.CourseWork content) throws IOException {
                Patch result = new Patch(courseId, id, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public StudentSubmissions studentSubmissions() {
                return new StudentSubmissions();
            }

            public class StudentSubmissions {
                public Get get(String courseId, String courseWorkId, String id) throws IOException {
                    Get result = new Get(courseId, courseWorkId, id);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String courseId, String courseWorkId) throws IOException {
                    List result = new List(courseId, courseWorkId);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ModifyAttachments modifyAttachments(String courseId, String courseWorkId, String id, ModifyAttachmentsRequest content) throws IOException {
                    ModifyAttachments result = new ModifyAttachments(courseId, courseWorkId, id, content);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String courseId, String courseWorkId, String id, StudentSubmission content) throws IOException {
                    Patch result = new Patch(courseId, courseWorkId, id, content);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Reclaim reclaim(String courseId, String courseWorkId, String id, ReclaimStudentSubmissionRequest content) throws IOException {
                    Reclaim result = new Reclaim(courseId, courseWorkId, id, content);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ClassroomReturn classroomReturn(String courseId, String courseWorkId, String id, ReturnStudentSubmissionRequest content) throws IOException {
                    ClassroomReturn result = new ClassroomReturn(courseId, courseWorkId, id, content);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TurnIn turnIn(String courseId, String courseWorkId, String id, TurnInStudentSubmissionRequest content) throws IOException {
                    TurnIn result = new TurnIn(courseId, courseWorkId, id, content);
                    Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class TurnIn
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:turnIn";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected TurnIn(String courseId, String courseWorkId, String id, TurnInStudentSubmissionRequest content) {
                        super(Classroom.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public TurnIn set$Xgafv(String $Xgafv) {
                        return (TurnIn)super.set$Xgafv($Xgafv);
                    }

                    public TurnIn setAccessToken(String accessToken) {
                        return (TurnIn)super.setAccessToken(accessToken);
                    }

                    public TurnIn setAlt(String alt) {
                        return (TurnIn)super.setAlt(alt);
                    }

                    public TurnIn setCallback(String callback) {
                        return (TurnIn)super.setCallback(callback);
                    }

                    public TurnIn setFields(String fields) {
                        return (TurnIn)super.setFields(fields);
                    }

                    public TurnIn setKey(String key) {
                        return (TurnIn)super.setKey(key);
                    }

                    public TurnIn setOauthToken(String oauthToken) {
                        return (TurnIn)super.setOauthToken(oauthToken);
                    }

                    public TurnIn setPrettyPrint(Boolean prettyPrint) {
                        return (TurnIn)super.setPrettyPrint(prettyPrint);
                    }

                    public TurnIn setQuotaUser(String quotaUser) {
                        return (TurnIn)super.setQuotaUser(quotaUser);
                    }

                    public TurnIn setUploadType(String uploadType) {
                        return (TurnIn)super.setUploadType(uploadType);
                    }

                    public TurnIn setUploadProtocol(String uploadProtocol) {
                        return (TurnIn)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public TurnIn setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public TurnIn setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public TurnIn setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public TurnIn set(String parameterName, Object value) {
                        return (TurnIn)super.set(parameterName, value);
                    }
                }

                public class ClassroomReturn
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:return";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected ClassroomReturn(String courseId, String courseWorkId, String id, ReturnStudentSubmissionRequest content) {
                        super(Classroom.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public ClassroomReturn set$Xgafv(String $Xgafv) {
                        return (ClassroomReturn)super.set$Xgafv($Xgafv);
                    }

                    public ClassroomReturn setAccessToken(String accessToken) {
                        return (ClassroomReturn)super.setAccessToken(accessToken);
                    }

                    public ClassroomReturn setAlt(String alt) {
                        return (ClassroomReturn)super.setAlt(alt);
                    }

                    public ClassroomReturn setCallback(String callback) {
                        return (ClassroomReturn)super.setCallback(callback);
                    }

                    public ClassroomReturn setFields(String fields) {
                        return (ClassroomReturn)super.setFields(fields);
                    }

                    public ClassroomReturn setKey(String key) {
                        return (ClassroomReturn)super.setKey(key);
                    }

                    public ClassroomReturn setOauthToken(String oauthToken) {
                        return (ClassroomReturn)super.setOauthToken(oauthToken);
                    }

                    public ClassroomReturn setPrettyPrint(Boolean prettyPrint) {
                        return (ClassroomReturn)super.setPrettyPrint(prettyPrint);
                    }

                    public ClassroomReturn setQuotaUser(String quotaUser) {
                        return (ClassroomReturn)super.setQuotaUser(quotaUser);
                    }

                    public ClassroomReturn setUploadType(String uploadType) {
                        return (ClassroomReturn)super.setUploadType(uploadType);
                    }

                    public ClassroomReturn setUploadProtocol(String uploadProtocol) {
                        return (ClassroomReturn)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public ClassroomReturn setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public ClassroomReturn setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public ClassroomReturn setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public ClassroomReturn set(String parameterName, Object value) {
                        return (ClassroomReturn)super.set(parameterName, value);
                    }
                }

                public class Reclaim
                extends ClassroomRequest<Empty> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:reclaim";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected Reclaim(String courseId, String courseWorkId, String id, ReclaimStudentSubmissionRequest content) {
                        super(Classroom.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public Reclaim set$Xgafv(String $Xgafv) {
                        return (Reclaim)super.set$Xgafv($Xgafv);
                    }

                    public Reclaim setAccessToken(String accessToken) {
                        return (Reclaim)super.setAccessToken(accessToken);
                    }

                    public Reclaim setAlt(String alt) {
                        return (Reclaim)super.setAlt(alt);
                    }

                    public Reclaim setCallback(String callback) {
                        return (Reclaim)super.setCallback(callback);
                    }

                    public Reclaim setFields(String fields) {
                        return (Reclaim)super.setFields(fields);
                    }

                    public Reclaim setKey(String key) {
                        return (Reclaim)super.setKey(key);
                    }

                    public Reclaim setOauthToken(String oauthToken) {
                        return (Reclaim)super.setOauthToken(oauthToken);
                    }

                    public Reclaim setPrettyPrint(Boolean prettyPrint) {
                        return (Reclaim)super.setPrettyPrint(prettyPrint);
                    }

                    public Reclaim setQuotaUser(String quotaUser) {
                        return (Reclaim)super.setQuotaUser(quotaUser);
                    }

                    public Reclaim setUploadType(String uploadType) {
                        return (Reclaim)super.setUploadType(uploadType);
                    }

                    public Reclaim setUploadProtocol(String uploadProtocol) {
                        return (Reclaim)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Reclaim setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Reclaim setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Reclaim setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Reclaim set(String parameterName, Object value) {
                        return (Reclaim)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;
                    @Key
                    private String updateMask;

                    protected Patch(String courseId, String courseWorkId, String id, StudentSubmission content) {
                        super(Classroom.this, "PATCH", REST_PATH, (Object)content, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Patch setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Patch setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Patch setId(String id) {
                        this.id = id;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class ModifyAttachments
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:modifyAttachments";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected ModifyAttachments(String courseId, String courseWorkId, String id, ModifyAttachmentsRequest content) {
                        super(Classroom.this, "POST", REST_PATH, (Object)content, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public ModifyAttachments set$Xgafv(String $Xgafv) {
                        return (ModifyAttachments)super.set$Xgafv($Xgafv);
                    }

                    public ModifyAttachments setAccessToken(String accessToken) {
                        return (ModifyAttachments)super.setAccessToken(accessToken);
                    }

                    public ModifyAttachments setAlt(String alt) {
                        return (ModifyAttachments)super.setAlt(alt);
                    }

                    public ModifyAttachments setCallback(String callback) {
                        return (ModifyAttachments)super.setCallback(callback);
                    }

                    public ModifyAttachments setFields(String fields) {
                        return (ModifyAttachments)super.setFields(fields);
                    }

                    public ModifyAttachments setKey(String key) {
                        return (ModifyAttachments)super.setKey(key);
                    }

                    public ModifyAttachments setOauthToken(String oauthToken) {
                        return (ModifyAttachments)super.setOauthToken(oauthToken);
                    }

                    public ModifyAttachments setPrettyPrint(Boolean prettyPrint) {
                        return (ModifyAttachments)super.setPrettyPrint(prettyPrint);
                    }

                    public ModifyAttachments setQuotaUser(String quotaUser) {
                        return (ModifyAttachments)super.setQuotaUser(quotaUser);
                    }

                    public ModifyAttachments setUploadType(String uploadType) {
                        return (ModifyAttachments)super.setUploadType(uploadType);
                    }

                    public ModifyAttachments setUploadProtocol(String uploadProtocol) {
                        return (ModifyAttachments)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public ModifyAttachments setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public ModifyAttachments setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public ModifyAttachments setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public ModifyAttachments set(String parameterName, Object value) {
                        return (ModifyAttachments)super.set(parameterName, value);
                    }
                }

                public class List
                extends ClassroomRequest<ListStudentSubmissionsResponse> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String late;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private java.util.List<String> states;
                    @Key
                    private String userId;

                    protected List(String courseId, String courseWorkId) {
                        super(Classroom.this, "GET", REST_PATH, null, ListStudentSubmissionsResponse.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public List setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public List setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getLate() {
                        return this.late;
                    }

                    public List setLate(String late) {
                        this.late = late;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public java.util.List<String> getStates() {
                        return this.states;
                    }

                    public List setStates(java.util.List<String> states) {
                        this.states = states;
                        return this;
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ClassroomRequest<StudentSubmission> {
                    private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}";
                    @Key
                    private String courseId;
                    @Key
                    private String courseWorkId;
                    @Key
                    private String id;

                    protected Get(String courseId, String courseWorkId, String id) {
                        super(Classroom.this, "GET", REST_PATH, null, StudentSubmission.class);
                        this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                        this.courseWorkId = (String)Preconditions.checkNotNull((Object)courseWorkId, (Object)"Required parameter courseWorkId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCourseId() {
                        return this.courseId;
                    }

                    public Get setCourseId(String courseId) {
                        this.courseId = courseId;
                        return this;
                    }

                    public String getCourseWorkId() {
                        return this.courseWorkId;
                    }

                    public Get setCourseWorkId(String courseWorkId) {
                        this.courseWorkId = courseWorkId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;
                @Key
                private String updateMask;

                protected Patch(String courseId, String id, com.google.api.services.classroom.model.CourseWork content) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Patch setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class ModifyAssignees
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}:modifyAssignees";
                @Key
                private String courseId;
                @Key
                private String id;

                protected ModifyAssignees(String courseId, String id, ModifyCourseWorkAssigneesRequest content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public ModifyAssignees set$Xgafv(String $Xgafv) {
                    return (ModifyAssignees)super.set$Xgafv($Xgafv);
                }

                public ModifyAssignees setAccessToken(String accessToken) {
                    return (ModifyAssignees)super.setAccessToken(accessToken);
                }

                public ModifyAssignees setAlt(String alt) {
                    return (ModifyAssignees)super.setAlt(alt);
                }

                public ModifyAssignees setCallback(String callback) {
                    return (ModifyAssignees)super.setCallback(callback);
                }

                public ModifyAssignees setFields(String fields) {
                    return (ModifyAssignees)super.setFields(fields);
                }

                public ModifyAssignees setKey(String key) {
                    return (ModifyAssignees)super.setKey(key);
                }

                public ModifyAssignees setOauthToken(String oauthToken) {
                    return (ModifyAssignees)super.setOauthToken(oauthToken);
                }

                public ModifyAssignees setPrettyPrint(Boolean prettyPrint) {
                    return (ModifyAssignees)super.setPrettyPrint(prettyPrint);
                }

                public ModifyAssignees setQuotaUser(String quotaUser) {
                    return (ModifyAssignees)super.setQuotaUser(quotaUser);
                }

                public ModifyAssignees setUploadType(String uploadType) {
                    return (ModifyAssignees)super.setUploadType(uploadType);
                }

                public ModifyAssignees setUploadProtocol(String uploadProtocol) {
                    return (ModifyAssignees)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public ModifyAssignees setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public ModifyAssignees setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public ModifyAssignees set(String parameterName, Object value) {
                    return (ModifyAssignees)super.set(parameterName, value);
                }
            }

            public class List
            extends ClassroomRequest<ListCourseWorkResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork";
                @Key
                private String courseId;
                @Key
                private java.util.List<String> courseWorkStates;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListCourseWorkResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public java.util.List<String> getCourseWorkStates() {
                    return this.courseWorkStates;
                }

                public List setCourseWorkStates(java.util.List<String> courseWorkStates) {
                    this.courseWorkStates = courseWorkStates;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String courseId, String id) {
                    super(Classroom.this, "GET", REST_PATH, null, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Delete(String courseId, String id) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<com.google.api.services.classroom.model.CourseWork> {
                private static final String REST_PATH = "v1/courses/{courseId}/courseWork";
                @Key
                private String courseId;

                protected Create(String courseId, com.google.api.services.classroom.model.CourseWork content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, com.google.api.services.classroom.model.CourseWork.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Announcements {
            public Create create(String courseId, Announcement content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String id) throws IOException {
                Delete result = new Delete(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String courseId, String id) throws IOException {
                Get result = new Get(courseId, id);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ModifyAssignees modifyAssignees(String courseId, String id, ModifyAnnouncementAssigneesRequest content) throws IOException {
                ModifyAssignees result = new ModifyAssignees(courseId, id, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String courseId, String id, Announcement content) throws IOException {
                Patch result = new Patch(courseId, id, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;
                @Key
                private String updateMask;

                protected Patch(String courseId, String id, Announcement content) {
                    super(Classroom.this, "PATCH", REST_PATH, (Object)content, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Patch setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class ModifyAssignees
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}:modifyAssignees";
                @Key
                private String courseId;
                @Key
                private String id;

                protected ModifyAssignees(String courseId, String id, ModifyAnnouncementAssigneesRequest content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public ModifyAssignees set$Xgafv(String $Xgafv) {
                    return (ModifyAssignees)super.set$Xgafv($Xgafv);
                }

                public ModifyAssignees setAccessToken(String accessToken) {
                    return (ModifyAssignees)super.setAccessToken(accessToken);
                }

                public ModifyAssignees setAlt(String alt) {
                    return (ModifyAssignees)super.setAlt(alt);
                }

                public ModifyAssignees setCallback(String callback) {
                    return (ModifyAssignees)super.setCallback(callback);
                }

                public ModifyAssignees setFields(String fields) {
                    return (ModifyAssignees)super.setFields(fields);
                }

                public ModifyAssignees setKey(String key) {
                    return (ModifyAssignees)super.setKey(key);
                }

                public ModifyAssignees setOauthToken(String oauthToken) {
                    return (ModifyAssignees)super.setOauthToken(oauthToken);
                }

                public ModifyAssignees setPrettyPrint(Boolean prettyPrint) {
                    return (ModifyAssignees)super.setPrettyPrint(prettyPrint);
                }

                public ModifyAssignees setQuotaUser(String quotaUser) {
                    return (ModifyAssignees)super.setQuotaUser(quotaUser);
                }

                public ModifyAssignees setUploadType(String uploadType) {
                    return (ModifyAssignees)super.setUploadType(uploadType);
                }

                public ModifyAssignees setUploadProtocol(String uploadProtocol) {
                    return (ModifyAssignees)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public ModifyAssignees setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public ModifyAssignees setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public ModifyAssignees set(String parameterName, Object value) {
                    return (ModifyAssignees)super.set(parameterName, value);
                }
            }

            public class List
            extends ClassroomRequest<ListAnnouncementsResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements";
                @Key
                private String courseId;
                @Key
                private java.util.List<String> announcementStates;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListAnnouncementsResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public java.util.List<String> getAnnouncementStates() {
                    return this.announcementStates;
                }

                public List setAnnouncementStates(java.util.List<String> announcementStates) {
                    this.announcementStates = announcementStates;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Get(String courseId, String id) {
                    super(Classroom.this, "GET", REST_PATH, null, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Get setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements/{id}";
                @Key
                private String courseId;
                @Key
                private String id;

                protected Delete(String courseId, String id) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<Announcement> {
                private static final String REST_PATH = "v1/courses/{courseId}/announcements";
                @Key
                private String courseId;

                protected Create(String courseId, Announcement content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, Announcement.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Aliases {
            public Create create(String courseId, CourseAlias content) throws IOException {
                Create result = new Create(courseId, content);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String courseId, String alias) throws IOException {
                Delete result = new Delete(courseId, alias);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String courseId) throws IOException {
                List result = new List(courseId);
                Classroom.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ClassroomRequest<ListCourseAliasesResponse> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases";
                @Key
                private String courseId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String courseId) {
                    super(Classroom.this, "GET", REST_PATH, null, ListCourseAliasesResponse.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public List setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ClassroomRequest<Empty> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases/{alias}";
                @Key
                private String courseId;
                @Key
                private String alias;

                protected Delete(String courseId, String alias) {
                    super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"Required parameter alias must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Delete setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String alias) {
                    this.alias = alias;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ClassroomRequest<CourseAlias> {
                private static final String REST_PATH = "v1/courses/{courseId}/aliases";
                @Key
                private String courseId;

                protected Create(String courseId, CourseAlias content) {
                    super(Classroom.this, "POST", REST_PATH, (Object)content, CourseAlias.class);
                    this.courseId = (String)Preconditions.checkNotNull((Object)courseId, (Object)"Required parameter courseId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getCourseId() {
                    return this.courseId;
                }

                public Create setCourseId(String courseId) {
                    this.courseId = courseId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Update
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Update(String id, Course content) {
                super(Classroom.this, "PUT", REST_PATH, (Object)content, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;
            @Key
            private String updateMask;

            protected Patch(String id, Course content) {
                super(Classroom.this, "PATCH", REST_PATH, (Object)content, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String id) {
                this.id = id;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ClassroomRequest<ListCoursesResponse> {
            private static final String REST_PATH = "v1/courses";
            @Key
            private java.util.List<String> courseStates;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String studentId;
            @Key
            private String teacherId;

            protected List() {
                super(Classroom.this, "GET", REST_PATH, null, ListCoursesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getCourseStates() {
                return this.courseStates;
            }

            public List setCourseStates(java.util.List<String> courseStates) {
                this.courseStates = courseStates;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getStudentId() {
                return this.studentId;
            }

            public List setStudentId(String studentId) {
                this.studentId = studentId;
                return this;
            }

            public String getTeacherId() {
                return this.teacherId;
            }

            public List setTeacherId(String teacherId) {
                this.teacherId = teacherId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Get(String id) {
                super(Classroom.this, "GET", REST_PATH, null, Course.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ClassroomRequest<Empty> {
            private static final String REST_PATH = "v1/courses/{id}";
            @Key
            private String id;

            protected Delete(String id) {
                super(Classroom.this, "DELETE", REST_PATH, null, Empty.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ClassroomRequest<Course> {
            private static final String REST_PATH = "v1/courses";

            protected Create(Course content) {
                super(Classroom.this, "POST", REST_PATH, (Object)content, Course.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

