/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudasset.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudasset.v1.CloudAssetRequest;
import com.google.api.services.cloudasset.v1.CloudAssetRequestInitializer;
import com.google.api.services.cloudasset.v1.model.AnalyzeIamPolicyLongrunningRequest;
import com.google.api.services.cloudasset.v1.model.AnalyzeIamPolicyResponse;
import com.google.api.services.cloudasset.v1.model.AnalyzeMoveResponse;
import com.google.api.services.cloudasset.v1.model.AnalyzeOrgPoliciesResponse;
import com.google.api.services.cloudasset.v1.model.AnalyzeOrgPolicyGovernedAssetsResponse;
import com.google.api.services.cloudasset.v1.model.AnalyzeOrgPolicyGovernedContainersResponse;
import com.google.api.services.cloudasset.v1.model.BatchGetAssetsHistoryResponse;
import com.google.api.services.cloudasset.v1.model.BatchGetEffectiveIamPoliciesResponse;
import com.google.api.services.cloudasset.v1.model.CreateFeedRequest;
import com.google.api.services.cloudasset.v1.model.Empty;
import com.google.api.services.cloudasset.v1.model.ExportAssetsRequest;
import com.google.api.services.cloudasset.v1.model.Feed;
import com.google.api.services.cloudasset.v1.model.ListAssetsResponse;
import com.google.api.services.cloudasset.v1.model.ListFeedsResponse;
import com.google.api.services.cloudasset.v1.model.ListSavedQueriesResponse;
import com.google.api.services.cloudasset.v1.model.Operation;
import com.google.api.services.cloudasset.v1.model.QueryAssetsRequest;
import com.google.api.services.cloudasset.v1.model.QueryAssetsResponse;
import com.google.api.services.cloudasset.v1.model.SavedQuery;
import com.google.api.services.cloudasset.v1.model.SearchAllIamPoliciesResponse;
import com.google.api.services.cloudasset.v1.model.SearchAllResourcesResponse;
import com.google.api.services.cloudasset.v1.model.UpdateFeedRequest;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class CloudAsset
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudasset.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudasset.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudasset.googleapis.com/";

    public CloudAsset(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudAsset(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Assets assets() {
        return new Assets();
    }

    public EffectiveIamPolicies effectiveIamPolicies() {
        return new EffectiveIamPolicies();
    }

    public Feeds feeds() {
        return new Feeds();
    }

    public Operations operations() {
        return new Operations();
    }

    public SavedQueries savedQueries() {
        return new SavedQueries();
    }

    public V1 v1() {
        return new V1();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Asset API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudAsset.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudasset.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudAsset.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudAsset.DEFAULT_BATCH_PATH);
        }

        public CloudAsset build() {
            return new CloudAsset(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudAssetRequestInitializer(CloudAssetRequestInitializer cloudassetRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudassetRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class V1 {
        public AnalyzeIamPolicy analyzeIamPolicy(String scope) throws IOException {
            AnalyzeIamPolicy result = new AnalyzeIamPolicy(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnalyzeIamPolicyLongrunning analyzeIamPolicyLongrunning(String scope, AnalyzeIamPolicyLongrunningRequest content) throws IOException {
            AnalyzeIamPolicyLongrunning result = new AnalyzeIamPolicyLongrunning(scope, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnalyzeMove analyzeMove(String resource) throws IOException {
            AnalyzeMove result = new AnalyzeMove(resource);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnalyzeOrgPolicies analyzeOrgPolicies(String scope) throws IOException {
            AnalyzeOrgPolicies result = new AnalyzeOrgPolicies(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnalyzeOrgPolicyGovernedAssets analyzeOrgPolicyGovernedAssets(String scope) throws IOException {
            AnalyzeOrgPolicyGovernedAssets result = new AnalyzeOrgPolicyGovernedAssets(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AnalyzeOrgPolicyGovernedContainers analyzeOrgPolicyGovernedContainers(String scope) throws IOException {
            AnalyzeOrgPolicyGovernedContainers result = new AnalyzeOrgPolicyGovernedContainers(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchGetAssetsHistory batchGetAssetsHistory(String parent) throws IOException {
            BatchGetAssetsHistory result = new BatchGetAssetsHistory(parent);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ExportAssets exportAssets(String parent, ExportAssetsRequest content) throws IOException {
            ExportAssets result = new ExportAssets(parent, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public QueryAssets queryAssets(String parent, QueryAssetsRequest content) throws IOException {
            QueryAssets result = new QueryAssets(parent, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SearchAllIamPolicies searchAllIamPolicies(String scope) throws IOException {
            SearchAllIamPolicies result = new SearchAllIamPolicies(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SearchAllResources searchAllResources(String scope) throws IOException {
            SearchAllResources result = new SearchAllResources(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class SearchAllResources
        extends CloudAssetRequest<SearchAllResourcesResponse> {
            private static final String REST_PATH = "v1/{+scope}:searchAllResources";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private List<String> assetTypes;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private String readMask;

            protected SearchAllResources(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, SearchAllResourcesResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public SearchAllResources set$Xgafv(String $Xgafv) {
                return (SearchAllResources)super.set$Xgafv($Xgafv);
            }

            public SearchAllResources setAccessToken(String accessToken) {
                return (SearchAllResources)super.setAccessToken(accessToken);
            }

            public SearchAllResources setAlt(String alt) {
                return (SearchAllResources)super.setAlt(alt);
            }

            public SearchAllResources setCallback(String callback) {
                return (SearchAllResources)super.setCallback(callback);
            }

            public SearchAllResources setFields(String fields) {
                return (SearchAllResources)super.setFields(fields);
            }

            public SearchAllResources setKey(String key) {
                return (SearchAllResources)super.setKey(key);
            }

            public SearchAllResources setOauthToken(String oauthToken) {
                return (SearchAllResources)super.setOauthToken(oauthToken);
            }

            public SearchAllResources setPrettyPrint(Boolean prettyPrint) {
                return (SearchAllResources)super.setPrettyPrint(prettyPrint);
            }

            public SearchAllResources setQuotaUser(String quotaUser) {
                return (SearchAllResources)super.setQuotaUser(quotaUser);
            }

            public SearchAllResources setUploadType(String uploadType) {
                return (SearchAllResources)super.setUploadType(uploadType);
            }

            public SearchAllResources setUploadProtocol(String uploadProtocol) {
                return (SearchAllResources)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public SearchAllResources setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public List<String> getAssetTypes() {
                return this.assetTypes;
            }

            public SearchAllResources setAssetTypes(List<String> assetTypes) {
                this.assetTypes = assetTypes;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public SearchAllResources setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public SearchAllResources setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public SearchAllResources setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public SearchAllResources setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public SearchAllResources setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public SearchAllResources set(String parameterName, Object value) {
                return (SearchAllResources)super.set(parameterName, value);
            }
        }

        public class SearchAllIamPolicies
        extends CloudAssetRequest<SearchAllIamPoliciesResponse> {
            private static final String REST_PATH = "v1/{+scope}:searchAllIamPolicies";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private List<String> assetTypes;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String query;

            protected SearchAllIamPolicies(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, SearchAllIamPoliciesResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public SearchAllIamPolicies set$Xgafv(String $Xgafv) {
                return (SearchAllIamPolicies)super.set$Xgafv($Xgafv);
            }

            public SearchAllIamPolicies setAccessToken(String accessToken) {
                return (SearchAllIamPolicies)super.setAccessToken(accessToken);
            }

            public SearchAllIamPolicies setAlt(String alt) {
                return (SearchAllIamPolicies)super.setAlt(alt);
            }

            public SearchAllIamPolicies setCallback(String callback) {
                return (SearchAllIamPolicies)super.setCallback(callback);
            }

            public SearchAllIamPolicies setFields(String fields) {
                return (SearchAllIamPolicies)super.setFields(fields);
            }

            public SearchAllIamPolicies setKey(String key) {
                return (SearchAllIamPolicies)super.setKey(key);
            }

            public SearchAllIamPolicies setOauthToken(String oauthToken) {
                return (SearchAllIamPolicies)super.setOauthToken(oauthToken);
            }

            public SearchAllIamPolicies setPrettyPrint(Boolean prettyPrint) {
                return (SearchAllIamPolicies)super.setPrettyPrint(prettyPrint);
            }

            public SearchAllIamPolicies setQuotaUser(String quotaUser) {
                return (SearchAllIamPolicies)super.setQuotaUser(quotaUser);
            }

            public SearchAllIamPolicies setUploadType(String uploadType) {
                return (SearchAllIamPolicies)super.setUploadType(uploadType);
            }

            public SearchAllIamPolicies setUploadProtocol(String uploadProtocol) {
                return (SearchAllIamPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public SearchAllIamPolicies setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public List<String> getAssetTypes() {
                return this.assetTypes;
            }

            public SearchAllIamPolicies setAssetTypes(List<String> assetTypes) {
                this.assetTypes = assetTypes;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public SearchAllIamPolicies setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public SearchAllIamPolicies setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public SearchAllIamPolicies setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public SearchAllIamPolicies setQuery(String query) {
                this.query = query;
                return this;
            }

            @Override
            public SearchAllIamPolicies set(String parameterName, Object value) {
                return (SearchAllIamPolicies)super.set(parameterName, value);
            }
        }

        public class QueryAssets
        extends CloudAssetRequest<QueryAssetsResponse> {
            private static final String REST_PATH = "v1/{+parent}:queryAssets";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected QueryAssets(String parent, QueryAssetsRequest content) {
                super(CloudAsset.this, "POST", REST_PATH, (Object)content, QueryAssetsResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public QueryAssets set$Xgafv(String $Xgafv) {
                return (QueryAssets)super.set$Xgafv($Xgafv);
            }

            public QueryAssets setAccessToken(String accessToken) {
                return (QueryAssets)super.setAccessToken(accessToken);
            }

            public QueryAssets setAlt(String alt) {
                return (QueryAssets)super.setAlt(alt);
            }

            public QueryAssets setCallback(String callback) {
                return (QueryAssets)super.setCallback(callback);
            }

            public QueryAssets setFields(String fields) {
                return (QueryAssets)super.setFields(fields);
            }

            public QueryAssets setKey(String key) {
                return (QueryAssets)super.setKey(key);
            }

            public QueryAssets setOauthToken(String oauthToken) {
                return (QueryAssets)super.setOauthToken(oauthToken);
            }

            public QueryAssets setPrettyPrint(Boolean prettyPrint) {
                return (QueryAssets)super.setPrettyPrint(prettyPrint);
            }

            public QueryAssets setQuotaUser(String quotaUser) {
                return (QueryAssets)super.setQuotaUser(quotaUser);
            }

            public QueryAssets setUploadType(String uploadType) {
                return (QueryAssets)super.setUploadType(uploadType);
            }

            public QueryAssets setUploadProtocol(String uploadProtocol) {
                return (QueryAssets)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public QueryAssets setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public QueryAssets set(String parameterName, Object value) {
                return (QueryAssets)super.set(parameterName, value);
            }
        }

        public class ExportAssets
        extends CloudAssetRequest<Operation> {
            private static final String REST_PATH = "v1/{+parent}:exportAssets";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected ExportAssets(String parent, ExportAssetsRequest content) {
                super(CloudAsset.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public ExportAssets set$Xgafv(String $Xgafv) {
                return (ExportAssets)super.set$Xgafv($Xgafv);
            }

            public ExportAssets setAccessToken(String accessToken) {
                return (ExportAssets)super.setAccessToken(accessToken);
            }

            public ExportAssets setAlt(String alt) {
                return (ExportAssets)super.setAlt(alt);
            }

            public ExportAssets setCallback(String callback) {
                return (ExportAssets)super.setCallback(callback);
            }

            public ExportAssets setFields(String fields) {
                return (ExportAssets)super.setFields(fields);
            }

            public ExportAssets setKey(String key) {
                return (ExportAssets)super.setKey(key);
            }

            public ExportAssets setOauthToken(String oauthToken) {
                return (ExportAssets)super.setOauthToken(oauthToken);
            }

            public ExportAssets setPrettyPrint(Boolean prettyPrint) {
                return (ExportAssets)super.setPrettyPrint(prettyPrint);
            }

            public ExportAssets setQuotaUser(String quotaUser) {
                return (ExportAssets)super.setQuotaUser(quotaUser);
            }

            public ExportAssets setUploadType(String uploadType) {
                return (ExportAssets)super.setUploadType(uploadType);
            }

            public ExportAssets setUploadProtocol(String uploadProtocol) {
                return (ExportAssets)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public ExportAssets setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public ExportAssets set(String parameterName, Object value) {
                return (ExportAssets)super.set(parameterName, value);
            }
        }

        public class BatchGetAssetsHistory
        extends CloudAssetRequest<BatchGetAssetsHistoryResponse> {
            private static final String REST_PATH = "v1/{+parent}:batchGetAssetsHistory";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private List<String> assetNames;
            @Key
            private String contentType;
            @Key(value="readTimeWindow.endTime")
            private String readTimeWindowEndTime;
            @Key(value="readTimeWindow.startTime")
            private String readTimeWindowStartTime;
            @Key
            private List<String> relationshipTypes;

            protected BatchGetAssetsHistory(String parent) {
                super(CloudAsset.this, "GET", REST_PATH, null, BatchGetAssetsHistoryResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGetAssetsHistory set$Xgafv(String $Xgafv) {
                return (BatchGetAssetsHistory)super.set$Xgafv($Xgafv);
            }

            public BatchGetAssetsHistory setAccessToken(String accessToken) {
                return (BatchGetAssetsHistory)super.setAccessToken(accessToken);
            }

            public BatchGetAssetsHistory setAlt(String alt) {
                return (BatchGetAssetsHistory)super.setAlt(alt);
            }

            public BatchGetAssetsHistory setCallback(String callback) {
                return (BatchGetAssetsHistory)super.setCallback(callback);
            }

            public BatchGetAssetsHistory setFields(String fields) {
                return (BatchGetAssetsHistory)super.setFields(fields);
            }

            public BatchGetAssetsHistory setKey(String key) {
                return (BatchGetAssetsHistory)super.setKey(key);
            }

            public BatchGetAssetsHistory setOauthToken(String oauthToken) {
                return (BatchGetAssetsHistory)super.setOauthToken(oauthToken);
            }

            public BatchGetAssetsHistory setPrettyPrint(Boolean prettyPrint) {
                return (BatchGetAssetsHistory)super.setPrettyPrint(prettyPrint);
            }

            public BatchGetAssetsHistory setQuotaUser(String quotaUser) {
                return (BatchGetAssetsHistory)super.setQuotaUser(quotaUser);
            }

            public BatchGetAssetsHistory setUploadType(String uploadType) {
                return (BatchGetAssetsHistory)super.setUploadType(uploadType);
            }

            public BatchGetAssetsHistory setUploadProtocol(String uploadProtocol) {
                return (BatchGetAssetsHistory)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public BatchGetAssetsHistory setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public List<String> getAssetNames() {
                return this.assetNames;
            }

            public BatchGetAssetsHistory setAssetNames(List<String> assetNames) {
                this.assetNames = assetNames;
                return this;
            }

            public String getContentType() {
                return this.contentType;
            }

            public BatchGetAssetsHistory setContentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public String getReadTimeWindowEndTime() {
                return this.readTimeWindowEndTime;
            }

            public BatchGetAssetsHistory setReadTimeWindowEndTime(String readTimeWindowEndTime) {
                this.readTimeWindowEndTime = readTimeWindowEndTime;
                return this;
            }

            public String getReadTimeWindowStartTime() {
                return this.readTimeWindowStartTime;
            }

            public BatchGetAssetsHistory setReadTimeWindowStartTime(String readTimeWindowStartTime) {
                this.readTimeWindowStartTime = readTimeWindowStartTime;
                return this;
            }

            public List<String> getRelationshipTypes() {
                return this.relationshipTypes;
            }

            public BatchGetAssetsHistory setRelationshipTypes(List<String> relationshipTypes) {
                this.relationshipTypes = relationshipTypes;
                return this;
            }

            @Override
            public BatchGetAssetsHistory set(String parameterName, Object value) {
                return (BatchGetAssetsHistory)super.set(parameterName, value);
            }
        }

        public class AnalyzeOrgPolicyGovernedContainers
        extends CloudAssetRequest<AnalyzeOrgPolicyGovernedContainersResponse> {
            private static final String REST_PATH = "v1/{+scope}:analyzeOrgPolicyGovernedContainers";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private String constraint;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected AnalyzeOrgPolicyGovernedContainers(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, AnalyzeOrgPolicyGovernedContainersResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AnalyzeOrgPolicyGovernedContainers set$Xgafv(String $Xgafv) {
                return (AnalyzeOrgPolicyGovernedContainers)super.set$Xgafv($Xgafv);
            }

            public AnalyzeOrgPolicyGovernedContainers setAccessToken(String accessToken) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setAccessToken(accessToken);
            }

            public AnalyzeOrgPolicyGovernedContainers setAlt(String alt) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setAlt(alt);
            }

            public AnalyzeOrgPolicyGovernedContainers setCallback(String callback) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setCallback(callback);
            }

            public AnalyzeOrgPolicyGovernedContainers setFields(String fields) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setFields(fields);
            }

            public AnalyzeOrgPolicyGovernedContainers setKey(String key) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setKey(key);
            }

            public AnalyzeOrgPolicyGovernedContainers setOauthToken(String oauthToken) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setOauthToken(oauthToken);
            }

            public AnalyzeOrgPolicyGovernedContainers setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeOrgPolicyGovernedContainers setQuotaUser(String quotaUser) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setQuotaUser(quotaUser);
            }

            public AnalyzeOrgPolicyGovernedContainers setUploadType(String uploadType) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setUploadType(uploadType);
            }

            public AnalyzeOrgPolicyGovernedContainers setUploadProtocol(String uploadProtocol) {
                return (AnalyzeOrgPolicyGovernedContainers)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public AnalyzeOrgPolicyGovernedContainers setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public String getConstraint() {
                return this.constraint;
            }

            public AnalyzeOrgPolicyGovernedContainers setConstraint(String constraint) {
                this.constraint = constraint;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AnalyzeOrgPolicyGovernedContainers setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public AnalyzeOrgPolicyGovernedContainers setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AnalyzeOrgPolicyGovernedContainers setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public AnalyzeOrgPolicyGovernedContainers set(String parameterName, Object value) {
                return (AnalyzeOrgPolicyGovernedContainers)super.set(parameterName, value);
            }
        }

        public class AnalyzeOrgPolicyGovernedAssets
        extends CloudAssetRequest<AnalyzeOrgPolicyGovernedAssetsResponse> {
            private static final String REST_PATH = "v1/{+scope}:analyzeOrgPolicyGovernedAssets";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private String constraint;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected AnalyzeOrgPolicyGovernedAssets(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, AnalyzeOrgPolicyGovernedAssetsResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AnalyzeOrgPolicyGovernedAssets set$Xgafv(String $Xgafv) {
                return (AnalyzeOrgPolicyGovernedAssets)super.set$Xgafv($Xgafv);
            }

            public AnalyzeOrgPolicyGovernedAssets setAccessToken(String accessToken) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setAccessToken(accessToken);
            }

            public AnalyzeOrgPolicyGovernedAssets setAlt(String alt) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setAlt(alt);
            }

            public AnalyzeOrgPolicyGovernedAssets setCallback(String callback) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setCallback(callback);
            }

            public AnalyzeOrgPolicyGovernedAssets setFields(String fields) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setFields(fields);
            }

            public AnalyzeOrgPolicyGovernedAssets setKey(String key) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setKey(key);
            }

            public AnalyzeOrgPolicyGovernedAssets setOauthToken(String oauthToken) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setOauthToken(oauthToken);
            }

            public AnalyzeOrgPolicyGovernedAssets setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeOrgPolicyGovernedAssets setQuotaUser(String quotaUser) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setQuotaUser(quotaUser);
            }

            public AnalyzeOrgPolicyGovernedAssets setUploadType(String uploadType) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setUploadType(uploadType);
            }

            public AnalyzeOrgPolicyGovernedAssets setUploadProtocol(String uploadProtocol) {
                return (AnalyzeOrgPolicyGovernedAssets)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public AnalyzeOrgPolicyGovernedAssets setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public String getConstraint() {
                return this.constraint;
            }

            public AnalyzeOrgPolicyGovernedAssets setConstraint(String constraint) {
                this.constraint = constraint;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AnalyzeOrgPolicyGovernedAssets setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public AnalyzeOrgPolicyGovernedAssets setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AnalyzeOrgPolicyGovernedAssets setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public AnalyzeOrgPolicyGovernedAssets set(String parameterName, Object value) {
                return (AnalyzeOrgPolicyGovernedAssets)super.set(parameterName, value);
            }
        }

        public class AnalyzeOrgPolicies
        extends CloudAssetRequest<AnalyzeOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+scope}:analyzeOrgPolicies";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private String constraint;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected AnalyzeOrgPolicies(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, AnalyzeOrgPoliciesResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AnalyzeOrgPolicies set$Xgafv(String $Xgafv) {
                return (AnalyzeOrgPolicies)super.set$Xgafv($Xgafv);
            }

            public AnalyzeOrgPolicies setAccessToken(String accessToken) {
                return (AnalyzeOrgPolicies)super.setAccessToken(accessToken);
            }

            public AnalyzeOrgPolicies setAlt(String alt) {
                return (AnalyzeOrgPolicies)super.setAlt(alt);
            }

            public AnalyzeOrgPolicies setCallback(String callback) {
                return (AnalyzeOrgPolicies)super.setCallback(callback);
            }

            public AnalyzeOrgPolicies setFields(String fields) {
                return (AnalyzeOrgPolicies)super.setFields(fields);
            }

            public AnalyzeOrgPolicies setKey(String key) {
                return (AnalyzeOrgPolicies)super.setKey(key);
            }

            public AnalyzeOrgPolicies setOauthToken(String oauthToken) {
                return (AnalyzeOrgPolicies)super.setOauthToken(oauthToken);
            }

            public AnalyzeOrgPolicies setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeOrgPolicies)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeOrgPolicies setQuotaUser(String quotaUser) {
                return (AnalyzeOrgPolicies)super.setQuotaUser(quotaUser);
            }

            public AnalyzeOrgPolicies setUploadType(String uploadType) {
                return (AnalyzeOrgPolicies)super.setUploadType(uploadType);
            }

            public AnalyzeOrgPolicies setUploadProtocol(String uploadProtocol) {
                return (AnalyzeOrgPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public AnalyzeOrgPolicies setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public String getConstraint() {
                return this.constraint;
            }

            public AnalyzeOrgPolicies setConstraint(String constraint) {
                this.constraint = constraint;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AnalyzeOrgPolicies setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public AnalyzeOrgPolicies setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AnalyzeOrgPolicies setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public AnalyzeOrgPolicies set(String parameterName, Object value) {
                return (AnalyzeOrgPolicies)super.set(parameterName, value);
            }
        }

        public class AnalyzeMove
        extends CloudAssetRequest<AnalyzeMoveResponse> {
            private static final String REST_PATH = "v1/{+resource}:analyzeMove";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;
            @Key
            private String destinationParent;
            @Key
            private String view;

            protected AnalyzeMove(String resource) {
                super(CloudAsset.this, "GET", REST_PATH, null, AnalyzeMoveResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AnalyzeMove set$Xgafv(String $Xgafv) {
                return (AnalyzeMove)super.set$Xgafv($Xgafv);
            }

            public AnalyzeMove setAccessToken(String accessToken) {
                return (AnalyzeMove)super.setAccessToken(accessToken);
            }

            public AnalyzeMove setAlt(String alt) {
                return (AnalyzeMove)super.setAlt(alt);
            }

            public AnalyzeMove setCallback(String callback) {
                return (AnalyzeMove)super.setCallback(callback);
            }

            public AnalyzeMove setFields(String fields) {
                return (AnalyzeMove)super.setFields(fields);
            }

            public AnalyzeMove setKey(String key) {
                return (AnalyzeMove)super.setKey(key);
            }

            public AnalyzeMove setOauthToken(String oauthToken) {
                return (AnalyzeMove)super.setOauthToken(oauthToken);
            }

            public AnalyzeMove setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeMove)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeMove setQuotaUser(String quotaUser) {
                return (AnalyzeMove)super.setQuotaUser(quotaUser);
            }

            public AnalyzeMove setUploadType(String uploadType) {
                return (AnalyzeMove)super.setUploadType(uploadType);
            }

            public AnalyzeMove setUploadProtocol(String uploadProtocol) {
                return (AnalyzeMove)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public AnalyzeMove setResource(String resource) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            public String getDestinationParent() {
                return this.destinationParent;
            }

            public AnalyzeMove setDestinationParent(String destinationParent) {
                this.destinationParent = destinationParent;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public AnalyzeMove setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public AnalyzeMove set(String parameterName, Object value) {
                return (AnalyzeMove)super.set(parameterName, value);
            }
        }

        public class AnalyzeIamPolicyLongrunning
        extends CloudAssetRequest<Operation> {
            private static final String REST_PATH = "v1/{+scope}:analyzeIamPolicyLongrunning";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;

            protected AnalyzeIamPolicyLongrunning(String scope, AnalyzeIamPolicyLongrunningRequest content) {
                super(CloudAsset.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public AnalyzeIamPolicyLongrunning set$Xgafv(String $Xgafv) {
                return (AnalyzeIamPolicyLongrunning)super.set$Xgafv($Xgafv);
            }

            public AnalyzeIamPolicyLongrunning setAccessToken(String accessToken) {
                return (AnalyzeIamPolicyLongrunning)super.setAccessToken(accessToken);
            }

            public AnalyzeIamPolicyLongrunning setAlt(String alt) {
                return (AnalyzeIamPolicyLongrunning)super.setAlt(alt);
            }

            public AnalyzeIamPolicyLongrunning setCallback(String callback) {
                return (AnalyzeIamPolicyLongrunning)super.setCallback(callback);
            }

            public AnalyzeIamPolicyLongrunning setFields(String fields) {
                return (AnalyzeIamPolicyLongrunning)super.setFields(fields);
            }

            public AnalyzeIamPolicyLongrunning setKey(String key) {
                return (AnalyzeIamPolicyLongrunning)super.setKey(key);
            }

            public AnalyzeIamPolicyLongrunning setOauthToken(String oauthToken) {
                return (AnalyzeIamPolicyLongrunning)super.setOauthToken(oauthToken);
            }

            public AnalyzeIamPolicyLongrunning setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeIamPolicyLongrunning)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeIamPolicyLongrunning setQuotaUser(String quotaUser) {
                return (AnalyzeIamPolicyLongrunning)super.setQuotaUser(quotaUser);
            }

            public AnalyzeIamPolicyLongrunning setUploadType(String uploadType) {
                return (AnalyzeIamPolicyLongrunning)super.setUploadType(uploadType);
            }

            public AnalyzeIamPolicyLongrunning setUploadProtocol(String uploadProtocol) {
                return (AnalyzeIamPolicyLongrunning)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public AnalyzeIamPolicyLongrunning setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            @Override
            public AnalyzeIamPolicyLongrunning set(String parameterName, Object value) {
                return (AnalyzeIamPolicyLongrunning)super.set(parameterName, value);
            }
        }

        public class AnalyzeIamPolicy
        extends CloudAssetRequest<AnalyzeIamPolicyResponse> {
            private static final String REST_PATH = "v1/{+scope}:analyzeIamPolicy";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key(value="analysisQuery.accessSelector.permissions")
            private List<String> analysisQueryAccessSelectorPermissions;
            @Key(value="analysisQuery.accessSelector.roles")
            private List<String> analysisQueryAccessSelectorRoles;
            @Key(value="analysisQuery.conditionContext.accessTime")
            private String analysisQueryConditionContextAccessTime;
            @Key(value="analysisQuery.identitySelector.identity")
            private String analysisQueryIdentitySelectorIdentity;
            @Key(value="analysisQuery.options.analyzeServiceAccountImpersonation")
            private Boolean analysisQueryOptionsAnalyzeServiceAccountImpersonation;
            @Key(value="analysisQuery.options.expandGroups")
            private Boolean analysisQueryOptionsExpandGroups;
            @Key(value="analysisQuery.options.expandResources")
            private Boolean analysisQueryOptionsExpandResources;
            @Key(value="analysisQuery.options.expandRoles")
            private Boolean analysisQueryOptionsExpandRoles;
            @Key(value="analysisQuery.options.outputGroupEdges")
            private Boolean analysisQueryOptionsOutputGroupEdges;
            @Key(value="analysisQuery.options.outputResourceEdges")
            private Boolean analysisQueryOptionsOutputResourceEdges;
            @Key(value="analysisQuery.resourceSelector.fullResourceName")
            private String analysisQueryResourceSelectorFullResourceName;
            @Key
            private String executionTimeout;
            @Key
            private String savedAnalysisQuery;

            protected AnalyzeIamPolicy(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, AnalyzeIamPolicyResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AnalyzeIamPolicy set$Xgafv(String $Xgafv) {
                return (AnalyzeIamPolicy)super.set$Xgafv($Xgafv);
            }

            public AnalyzeIamPolicy setAccessToken(String accessToken) {
                return (AnalyzeIamPolicy)super.setAccessToken(accessToken);
            }

            public AnalyzeIamPolicy setAlt(String alt) {
                return (AnalyzeIamPolicy)super.setAlt(alt);
            }

            public AnalyzeIamPolicy setCallback(String callback) {
                return (AnalyzeIamPolicy)super.setCallback(callback);
            }

            public AnalyzeIamPolicy setFields(String fields) {
                return (AnalyzeIamPolicy)super.setFields(fields);
            }

            public AnalyzeIamPolicy setKey(String key) {
                return (AnalyzeIamPolicy)super.setKey(key);
            }

            public AnalyzeIamPolicy setOauthToken(String oauthToken) {
                return (AnalyzeIamPolicy)super.setOauthToken(oauthToken);
            }

            public AnalyzeIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (AnalyzeIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public AnalyzeIamPolicy setQuotaUser(String quotaUser) {
                return (AnalyzeIamPolicy)super.setQuotaUser(quotaUser);
            }

            public AnalyzeIamPolicy setUploadType(String uploadType) {
                return (AnalyzeIamPolicy)super.setUploadType(uploadType);
            }

            public AnalyzeIamPolicy setUploadProtocol(String uploadProtocol) {
                return (AnalyzeIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public AnalyzeIamPolicy setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public List<String> getAnalysisQueryAccessSelectorPermissions() {
                return this.analysisQueryAccessSelectorPermissions;
            }

            public AnalyzeIamPolicy setAnalysisQueryAccessSelectorPermissions(List<String> analysisQueryAccessSelectorPermissions) {
                this.analysisQueryAccessSelectorPermissions = analysisQueryAccessSelectorPermissions;
                return this;
            }

            public List<String> getAnalysisQueryAccessSelectorRoles() {
                return this.analysisQueryAccessSelectorRoles;
            }

            public AnalyzeIamPolicy setAnalysisQueryAccessSelectorRoles(List<String> analysisQueryAccessSelectorRoles) {
                this.analysisQueryAccessSelectorRoles = analysisQueryAccessSelectorRoles;
                return this;
            }

            public String getAnalysisQueryConditionContextAccessTime() {
                return this.analysisQueryConditionContextAccessTime;
            }

            public AnalyzeIamPolicy setAnalysisQueryConditionContextAccessTime(String analysisQueryConditionContextAccessTime) {
                this.analysisQueryConditionContextAccessTime = analysisQueryConditionContextAccessTime;
                return this;
            }

            public String getAnalysisQueryIdentitySelectorIdentity() {
                return this.analysisQueryIdentitySelectorIdentity;
            }

            public AnalyzeIamPolicy setAnalysisQueryIdentitySelectorIdentity(String analysisQueryIdentitySelectorIdentity) {
                this.analysisQueryIdentitySelectorIdentity = analysisQueryIdentitySelectorIdentity;
                return this;
            }

            public Boolean getAnalysisQueryOptionsAnalyzeServiceAccountImpersonation() {
                return this.analysisQueryOptionsAnalyzeServiceAccountImpersonation;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsAnalyzeServiceAccountImpersonation(Boolean analysisQueryOptionsAnalyzeServiceAccountImpersonation) {
                this.analysisQueryOptionsAnalyzeServiceAccountImpersonation = analysisQueryOptionsAnalyzeServiceAccountImpersonation;
                return this;
            }

            public Boolean getAnalysisQueryOptionsExpandGroups() {
                return this.analysisQueryOptionsExpandGroups;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsExpandGroups(Boolean analysisQueryOptionsExpandGroups) {
                this.analysisQueryOptionsExpandGroups = analysisQueryOptionsExpandGroups;
                return this;
            }

            public Boolean getAnalysisQueryOptionsExpandResources() {
                return this.analysisQueryOptionsExpandResources;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsExpandResources(Boolean analysisQueryOptionsExpandResources) {
                this.analysisQueryOptionsExpandResources = analysisQueryOptionsExpandResources;
                return this;
            }

            public Boolean getAnalysisQueryOptionsExpandRoles() {
                return this.analysisQueryOptionsExpandRoles;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsExpandRoles(Boolean analysisQueryOptionsExpandRoles) {
                this.analysisQueryOptionsExpandRoles = analysisQueryOptionsExpandRoles;
                return this;
            }

            public Boolean getAnalysisQueryOptionsOutputGroupEdges() {
                return this.analysisQueryOptionsOutputGroupEdges;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsOutputGroupEdges(Boolean analysisQueryOptionsOutputGroupEdges) {
                this.analysisQueryOptionsOutputGroupEdges = analysisQueryOptionsOutputGroupEdges;
                return this;
            }

            public Boolean getAnalysisQueryOptionsOutputResourceEdges() {
                return this.analysisQueryOptionsOutputResourceEdges;
            }

            public AnalyzeIamPolicy setAnalysisQueryOptionsOutputResourceEdges(Boolean analysisQueryOptionsOutputResourceEdges) {
                this.analysisQueryOptionsOutputResourceEdges = analysisQueryOptionsOutputResourceEdges;
                return this;
            }

            public String getAnalysisQueryResourceSelectorFullResourceName() {
                return this.analysisQueryResourceSelectorFullResourceName;
            }

            public AnalyzeIamPolicy setAnalysisQueryResourceSelectorFullResourceName(String analysisQueryResourceSelectorFullResourceName) {
                this.analysisQueryResourceSelectorFullResourceName = analysisQueryResourceSelectorFullResourceName;
                return this;
            }

            public String getExecutionTimeout() {
                return this.executionTimeout;
            }

            public AnalyzeIamPolicy setExecutionTimeout(String executionTimeout) {
                this.executionTimeout = executionTimeout;
                return this;
            }

            public String getSavedAnalysisQuery() {
                return this.savedAnalysisQuery;
            }

            public AnalyzeIamPolicy setSavedAnalysisQuery(String savedAnalysisQuery) {
                this.savedAnalysisQuery = savedAnalysisQuery;
                return this;
            }

            @Override
            public AnalyzeIamPolicy set(String parameterName, Object value) {
                return (AnalyzeIamPolicy)super.set(parameterName, value);
            }
        }
    }

    public class SavedQueries {
        public Create create(String parent, SavedQuery content) throws IOException {
            Create result = new Create(parent, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, SavedQuery content) throws IOException {
            Patch result = new Patch(name, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends CloudAssetRequest<SavedQuery> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, SavedQuery content) {
                super(CloudAsset.this, "PATCH", REST_PATH, (Object)content, SavedQuery.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/savedQueries/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudAssetRequest<ListSavedQueriesResponse> {
            private static final String REST_PATH = "v1/{+parent}/savedQueries";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(CloudAsset.this, "GET", REST_PATH, null, ListSavedQueriesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudAssetRequest<SavedQuery> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudAsset.this, "GET", REST_PATH, null, SavedQuery.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/savedQueries/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudAssetRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudAsset.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/savedQueries/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/savedQueries/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudAssetRequest<SavedQuery> {
            private static final String REST_PATH = "v1/{+parent}/savedQueries";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String savedQueryId;

            protected Create(String parent, SavedQuery content) {
                super(CloudAsset.this, "POST", REST_PATH, (Object)content, SavedQuery.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getSavedQueryId() {
                return this.savedQueryId;
            }

            public Create setSavedQueryId(String savedQueryId) {
                this.savedQueryId = savedQueryId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends CloudAssetRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudAsset.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/operations/[^/]+/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/operations/[^/]+/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/operations/[^/]+/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Feeds {
        public Create create(String parent, CreateFeedRequest content) throws IOException {
            Create result = new Create(parent, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, UpdateFeedRequest content) throws IOException {
            Patch result = new Patch(name, content);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends CloudAssetRequest<Feed> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Patch(String name, UpdateFeedRequest content) {
                super(CloudAsset.this, "PATCH", REST_PATH, (Object)content, Feed.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/feeds/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudAssetRequest<ListFeedsResponse> {
            private static final String REST_PATH = "v1/{+parent}/feeds";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected List(String parent) {
                super(CloudAsset.this, "GET", REST_PATH, null, ListFeedsResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudAssetRequest<Feed> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudAsset.this, "GET", REST_PATH, null, Feed.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/feeds/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudAssetRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudAsset.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/feeds/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/feeds/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudAssetRequest<Feed> {
            private static final String REST_PATH = "v1/{+parent}/feeds";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected Create(String parent, CreateFeedRequest content) {
                super(CloudAsset.this, "POST", REST_PATH, (Object)content, Feed.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class EffectiveIamPolicies {
        public BatchGet batchGet(String scope) throws IOException {
            BatchGet result = new BatchGet(scope);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class BatchGet
        extends CloudAssetRequest<BatchGetEffectiveIamPoliciesResponse> {
            private static final String REST_PATH = "v1/{+scope}/effectiveIamPolicies:batchGet";
            private final Pattern SCOPE_PATTERN;
            @Key
            private String scope;
            @Key
            private List<String> names;

            protected BatchGet(String scope) {
                super(CloudAsset.this, "GET", REST_PATH, null, BatchGetEffectiveIamPoliciesResponse.class);
                this.SCOPE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.scope = (String)Preconditions.checkNotNull((Object)scope, (Object)"Required parameter scope must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getScope() {
                return this.scope;
            }

            public BatchGet setScope(String scope) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SCOPE_PATTERN.matcher(scope).matches(), (Object)"Parameter scope must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.scope = scope;
                return this;
            }

            public List<String> getNames() {
                return this.names;
            }

            public BatchGet setNames(List<String> names) {
                this.names = names;
                return this;
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }
    }

    public class Assets {
        public List list(String parent) throws IOException {
            List result = new List(parent);
            CloudAsset.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends CloudAssetRequest<ListAssetsResponse> {
            private static final String REST_PATH = "v1/{+parent}/assets";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private java.util.List<String> assetTypes;
            @Key
            private String contentType;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String readTime;
            @Key
            private java.util.List<String> relationshipTypes;

            protected List(String parent) {
                super(CloudAsset.this, "GET", REST_PATH, null, ListAssetsResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!CloudAsset.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public java.util.List<String> getAssetTypes() {
                return this.assetTypes;
            }

            public List setAssetTypes(java.util.List<String> assetTypes) {
                this.assetTypes = assetTypes;
                return this;
            }

            public String getContentType() {
                return this.contentType;
            }

            public List setContentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getReadTime() {
                return this.readTime;
            }

            public List setReadTime(String readTime) {
                this.readTime = readTime;
                return this;
            }

            public java.util.List<String> getRelationshipTypes() {
                return this.relationshipTypes;
            }

            public List setRelationshipTypes(java.util.List<String> relationshipTypes) {
                this.relationshipTypes = relationshipTypes;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }
}

