/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudbilling;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudbilling.CloudbillingRequest;
import com.google.api.services.cloudbilling.CloudbillingRequestInitializer;
import com.google.api.services.cloudbilling.model.BillingAccount;
import com.google.api.services.cloudbilling.model.ListBillingAccountsResponse;
import com.google.api.services.cloudbilling.model.ListProjectBillingInfoResponse;
import com.google.api.services.cloudbilling.model.ListServicesResponse;
import com.google.api.services.cloudbilling.model.ListSkusResponse;
import com.google.api.services.cloudbilling.model.MoveBillingAccountRequest;
import com.google.api.services.cloudbilling.model.Policy;
import com.google.api.services.cloudbilling.model.ProjectBillingInfo;
import com.google.api.services.cloudbilling.model.SetIamPolicyRequest;
import com.google.api.services.cloudbilling.model.TestIamPermissionsRequest;
import com.google.api.services.cloudbilling.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class Cloudbilling
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudbilling.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudbilling.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudbilling.googleapis.com/";

    public Cloudbilling(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Cloudbilling(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BillingAccounts billingAccounts() {
        return new BillingAccounts();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Billing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Cloudbilling.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudbilling.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Cloudbilling.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Cloudbilling.DEFAULT_BATCH_PATH);
        }

        public Cloudbilling build() {
            return new Cloudbilling(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudbillingRequestInitializer(CloudbillingRequestInitializer cloudbillingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudbillingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Services {
        public List list() throws IOException {
            List result = new List();
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Skus skus() {
            return new Skus();
        }

        public class Skus {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudbillingRequest<ListSkusResponse> {
                private static final String REST_PATH = "v1/{+parent}/skus";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String currencyCode;
                @Key
                private String endTime;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String startTime;

                protected List(String parent) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListSkusResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^services/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getCurrencyCode() {
                    return this.currencyCode;
                }

                public List setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                    return this;
                }

                public String getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(String endTime) {
                    this.endTime = endTime;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(String startTime) {
                    this.startTime = startTime;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends CloudbillingRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/services";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(Cloudbilling.this, "GET", REST_PATH, null, ListServicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public GetBillingInfo getBillingInfo(String name) throws IOException {
            GetBillingInfo result = new GetBillingInfo(name);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateBillingInfo updateBillingInfo(String name, ProjectBillingInfo content) throws IOException {
            UpdateBillingInfo result = new UpdateBillingInfo(name, content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateBillingInfo
        extends CloudbillingRequest<ProjectBillingInfo> {
            private static final String REST_PATH = "v1/{+name}/billingInfo";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected UpdateBillingInfo(String name, ProjectBillingInfo content) {
                super(Cloudbilling.this, "PUT", REST_PATH, (Object)content, ProjectBillingInfo.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public UpdateBillingInfo set$Xgafv(String $Xgafv) {
                return (UpdateBillingInfo)super.set$Xgafv($Xgafv);
            }

            public UpdateBillingInfo setAccessToken(String accessToken) {
                return (UpdateBillingInfo)super.setAccessToken(accessToken);
            }

            public UpdateBillingInfo setAlt(String alt) {
                return (UpdateBillingInfo)super.setAlt(alt);
            }

            public UpdateBillingInfo setCallback(String callback) {
                return (UpdateBillingInfo)super.setCallback(callback);
            }

            public UpdateBillingInfo setFields(String fields) {
                return (UpdateBillingInfo)super.setFields(fields);
            }

            public UpdateBillingInfo setKey(String key) {
                return (UpdateBillingInfo)super.setKey(key);
            }

            public UpdateBillingInfo setOauthToken(String oauthToken) {
                return (UpdateBillingInfo)super.setOauthToken(oauthToken);
            }

            public UpdateBillingInfo setPrettyPrint(Boolean prettyPrint) {
                return (UpdateBillingInfo)super.setPrettyPrint(prettyPrint);
            }

            public UpdateBillingInfo setQuotaUser(String quotaUser) {
                return (UpdateBillingInfo)super.setQuotaUser(quotaUser);
            }

            public UpdateBillingInfo setUploadType(String uploadType) {
                return (UpdateBillingInfo)super.setUploadType(uploadType);
            }

            public UpdateBillingInfo setUploadProtocol(String uploadProtocol) {
                return (UpdateBillingInfo)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateBillingInfo setName(String name) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public UpdateBillingInfo set(String parameterName, Object value) {
                return (UpdateBillingInfo)super.set(parameterName, value);
            }
        }

        public class GetBillingInfo
        extends CloudbillingRequest<ProjectBillingInfo> {
            private static final String REST_PATH = "v1/{+name}/billingInfo";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetBillingInfo(String name) {
                super(Cloudbilling.this, "GET", REST_PATH, null, ProjectBillingInfo.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetBillingInfo set$Xgafv(String $Xgafv) {
                return (GetBillingInfo)super.set$Xgafv($Xgafv);
            }

            public GetBillingInfo setAccessToken(String accessToken) {
                return (GetBillingInfo)super.setAccessToken(accessToken);
            }

            public GetBillingInfo setAlt(String alt) {
                return (GetBillingInfo)super.setAlt(alt);
            }

            public GetBillingInfo setCallback(String callback) {
                return (GetBillingInfo)super.setCallback(callback);
            }

            public GetBillingInfo setFields(String fields) {
                return (GetBillingInfo)super.setFields(fields);
            }

            public GetBillingInfo setKey(String key) {
                return (GetBillingInfo)super.setKey(key);
            }

            public GetBillingInfo setOauthToken(String oauthToken) {
                return (GetBillingInfo)super.setOauthToken(oauthToken);
            }

            public GetBillingInfo setPrettyPrint(Boolean prettyPrint) {
                return (GetBillingInfo)super.setPrettyPrint(prettyPrint);
            }

            public GetBillingInfo setQuotaUser(String quotaUser) {
                return (GetBillingInfo)super.setQuotaUser(quotaUser);
            }

            public GetBillingInfo setUploadType(String uploadType) {
                return (GetBillingInfo)super.setUploadType(uploadType);
            }

            public GetBillingInfo setUploadProtocol(String uploadProtocol) {
                return (GetBillingInfo)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetBillingInfo setName(String name) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetBillingInfo set(String parameterName, Object value) {
                return (GetBillingInfo)super.set(parameterName, value);
            }
        }
    }

    public class Organizations {
        public BillingAccounts billingAccounts() {
            return new BillingAccounts();
        }

        public class BillingAccounts {
            public Create create(String parent, BillingAccount content) throws IOException {
                Create result = new Create(parent, content);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Move move(String destinationParent, String name) throws IOException {
                Move result = new Move(destinationParent, name);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Move
            extends CloudbillingRequest<BillingAccount> {
                private static final String REST_PATH = "v1/{+destinationParent}/{+name}:move";
                private final Pattern DESTINATION_PARENT_PATTERN;
                private final Pattern NAME_PATTERN;
                @Key
                private String destinationParent;
                @Key
                private String name;

                protected Move(String destinationParent, String name) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, BillingAccount.class);
                    this.DESTINATION_PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.destinationParent = (String)Preconditions.checkNotNull((Object)destinationParent, (Object)"Required parameter destinationParent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DESTINATION_PARENT_PATTERN.matcher(destinationParent).matches(), (Object)"Parameter destinationParent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Move set$Xgafv(String $Xgafv) {
                    return (Move)super.set$Xgafv($Xgafv);
                }

                public Move setAccessToken(String accessToken) {
                    return (Move)super.setAccessToken(accessToken);
                }

                public Move setAlt(String alt) {
                    return (Move)super.setAlt(alt);
                }

                public Move setCallback(String callback) {
                    return (Move)super.setCallback(callback);
                }

                public Move setFields(String fields) {
                    return (Move)super.setFields(fields);
                }

                public Move setKey(String key) {
                    return (Move)super.setKey(key);
                }

                public Move setOauthToken(String oauthToken) {
                    return (Move)super.setOauthToken(oauthToken);
                }

                public Move setPrettyPrint(Boolean prettyPrint) {
                    return (Move)super.setPrettyPrint(prettyPrint);
                }

                public Move setQuotaUser(String quotaUser) {
                    return (Move)super.setQuotaUser(quotaUser);
                }

                public Move setUploadType(String uploadType) {
                    return (Move)super.setUploadType(uploadType);
                }

                public Move setUploadProtocol(String uploadProtocol) {
                    return (Move)super.setUploadProtocol(uploadProtocol);
                }

                public String getDestinationParent() {
                    return this.destinationParent;
                }

                public Move setDestinationParent(String destinationParent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DESTINATION_PARENT_PATTERN.matcher(destinationParent).matches(), (Object)"Parameter destinationParent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.destinationParent = destinationParent;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Move setName(String name) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Move set(String parameterName, Object value) {
                    return (Move)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudbillingRequest<ListBillingAccountsResponse> {
                private static final String REST_PATH = "v1/{+parent}/billingAccounts";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListBillingAccountsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudbillingRequest<BillingAccount> {
                private static final String REST_PATH = "v1/{+parent}/billingAccounts";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, BillingAccount content) {
                    super(Cloudbilling.this, "POST", REST_PATH, (Object)content, BillingAccount.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class BillingAccounts {
        public Create create(BillingAccount content) throws IOException {
            Create result = new Create(content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Move move(String name, MoveBillingAccountRequest content) throws IOException {
            Move result = new Move(name, content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, BillingAccount content) throws IOException {
            Patch result = new Patch(name, content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Projects projects() {
            return new Projects();
        }

        public SubAccounts subAccounts() {
            return new SubAccounts();
        }

        public class SubAccounts {
            public Create create(String parent, BillingAccount content) throws IOException {
                Create result = new Create(parent, content);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudbillingRequest<ListBillingAccountsResponse> {
                private static final String REST_PATH = "v1/{+parent}/subAccounts";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListBillingAccountsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudbillingRequest<BillingAccount> {
                private static final String REST_PATH = "v1/{+parent}/subAccounts";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, BillingAccount content) {
                    super(Cloudbilling.this, "POST", REST_PATH, (Object)content, BillingAccount.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Projects {
            public List list(String name) throws IOException {
                List result = new List(name);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudbillingRequest<ListProjectBillingInfoResponse> {
                private static final String REST_PATH = "v1/{+name}/projects";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListProjectBillingInfoResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class TestIamPermissions
        extends CloudbillingRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends CloudbillingRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, BillingAccount content) {
                super(Cloudbilling.this, "PATCH", REST_PATH, (Object)content, BillingAccount.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Move
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/{+name}:move";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Move(String name, MoveBillingAccountRequest content) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)content, BillingAccount.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public Move set$Xgafv(String $Xgafv) {
                return (Move)super.set$Xgafv($Xgafv);
            }

            public Move setAccessToken(String accessToken) {
                return (Move)super.setAccessToken(accessToken);
            }

            public Move setAlt(String alt) {
                return (Move)super.setAlt(alt);
            }

            public Move setCallback(String callback) {
                return (Move)super.setCallback(callback);
            }

            public Move setFields(String fields) {
                return (Move)super.setFields(fields);
            }

            public Move setKey(String key) {
                return (Move)super.setKey(key);
            }

            public Move setOauthToken(String oauthToken) {
                return (Move)super.setOauthToken(oauthToken);
            }

            public Move setPrettyPrint(Boolean prettyPrint) {
                return (Move)super.setPrettyPrint(prettyPrint);
            }

            public Move setQuotaUser(String quotaUser) {
                return (Move)super.setQuotaUser(quotaUser);
            }

            public Move setUploadType(String uploadType) {
                return (Move)super.setUploadType(uploadType);
            }

            public Move setUploadProtocol(String uploadProtocol) {
                return (Move)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Move setName(String name) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Move set(String parameterName, Object value) {
                return (Move)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudbillingRequest<ListBillingAccountsResponse> {
            private static final String REST_PATH = "v1/billingAccounts";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String parent;

            protected List() {
                super(Cloudbilling.this, "GET", REST_PATH, null, ListBillingAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                this.parent = parent;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends CloudbillingRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;
            @Key(value="options.requestedPolicyVersion")
            private Integer optionsRequestedPolicyVersion;

            protected GetIamPolicy(String resource) {
                super(Cloudbilling.this, "GET", REST_PATH, null, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Cloudbilling.this, "GET", REST_PATH, null, BillingAccount.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/billingAccounts";
            @Key
            private String parent;

            protected Create(BillingAccount content) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)content, BillingAccount.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                this.parent = parent;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

