/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudbilling;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudbilling.CloudbillingRequest;
import com.google.api.services.cloudbilling.CloudbillingRequestInitializer;
import com.google.api.services.cloudbilling.model.BillingAccount;
import com.google.api.services.cloudbilling.model.ListBillingAccountsResponse;
import com.google.api.services.cloudbilling.model.ListProjectBillingInfoResponse;
import com.google.api.services.cloudbilling.model.ListServicesResponse;
import com.google.api.services.cloudbilling.model.ListSkusResponse;
import com.google.api.services.cloudbilling.model.Policy;
import com.google.api.services.cloudbilling.model.ProjectBillingInfo;
import com.google.api.services.cloudbilling.model.SetIamPolicyRequest;
import com.google.api.services.cloudbilling.model.TestIamPermissionsRequest;
import com.google.api.services.cloudbilling.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cloudbilling
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudbilling.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudbilling.googleapis.com/";

    public Cloudbilling(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Cloudbilling(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BillingAccounts billingAccounts() {
        return new BillingAccounts();
    }

    public Projects projects() {
        return new Projects();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Billing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://cloudbilling.googleapis.com/", Cloudbilling.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Cloudbilling.DEFAULT_BATCH_PATH);
        }

        public Cloudbilling build() {
            return new Cloudbilling(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCloudbillingRequestInitializer(CloudbillingRequestInitializer cloudbillingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudbillingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Services {
        public List list() throws IOException {
            List list = new List();
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Skus skus() {
            return new Skus();
        }

        public class Skus {
            public List list(String string) throws IOException {
                List list = new List(string);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends CloudbillingRequest<ListSkusResponse> {
                private static final String REST_PATH = "v1/{+parent}/skus";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String endTime;
                @Key
                private String pageToken;
                @Key
                private String startTime;
                @Key
                private Integer pageSize;
                @Key
                private String currencyCode;

                protected List(String string) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListSkusResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^services/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^services/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(String string) {
                    this.endTime = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(String string) {
                    this.startTime = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getCurrencyCode() {
                    return this.currencyCode;
                }

                public List setCurrencyCode(String string) {
                    this.currencyCode = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudbillingRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/services";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Cloudbilling.this, "GET", REST_PATH, null, ListServicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Projects {
        public GetBillingInfo getBillingInfo(String string) throws IOException {
            GetBillingInfo getBillingInfo = new GetBillingInfo(string);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)getBillingInfo);
            return getBillingInfo;
        }

        public UpdateBillingInfo updateBillingInfo(String string, ProjectBillingInfo projectBillingInfo) throws IOException {
            UpdateBillingInfo updateBillingInfo = new UpdateBillingInfo(string, projectBillingInfo);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)updateBillingInfo);
            return updateBillingInfo;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdateBillingInfo
        extends CloudbillingRequest<ProjectBillingInfo> {
            private static final String REST_PATH = "v1/{+name}/billingInfo";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected UpdateBillingInfo(String string, ProjectBillingInfo projectBillingInfo) {
                super(Cloudbilling.this, "PUT", REST_PATH, (Object)projectBillingInfo, ProjectBillingInfo.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public UpdateBillingInfo set$Xgafv(String string) {
                return (UpdateBillingInfo)super.set$Xgafv(string);
            }

            public UpdateBillingInfo setAccessToken(String string) {
                return (UpdateBillingInfo)super.setAccessToken(string);
            }

            public UpdateBillingInfo setAlt(String string) {
                return (UpdateBillingInfo)super.setAlt(string);
            }

            public UpdateBillingInfo setCallback(String string) {
                return (UpdateBillingInfo)super.setCallback(string);
            }

            public UpdateBillingInfo setFields(String string) {
                return (UpdateBillingInfo)super.setFields(string);
            }

            public UpdateBillingInfo setKey(String string) {
                return (UpdateBillingInfo)super.setKey(string);
            }

            public UpdateBillingInfo setOauthToken(String string) {
                return (UpdateBillingInfo)super.setOauthToken(string);
            }

            public UpdateBillingInfo setPrettyPrint(Boolean bl) {
                return (UpdateBillingInfo)super.setPrettyPrint(bl);
            }

            public UpdateBillingInfo setQuotaUser(String string) {
                return (UpdateBillingInfo)super.setQuotaUser(string);
            }

            public UpdateBillingInfo setUploadType(String string) {
                return (UpdateBillingInfo)super.setUploadType(string);
            }

            public UpdateBillingInfo setUploadProtocol(String string) {
                return (UpdateBillingInfo)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public UpdateBillingInfo setName(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public UpdateBillingInfo set(String string, Object object) {
                return (UpdateBillingInfo)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetBillingInfo
        extends CloudbillingRequest<ProjectBillingInfo> {
            private static final String REST_PATH = "v1/{+name}/billingInfo";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetBillingInfo(String string) {
                super(Cloudbilling.this, "GET", REST_PATH, null, ProjectBillingInfo.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetBillingInfo set$Xgafv(String string) {
                return (GetBillingInfo)super.set$Xgafv(string);
            }

            public GetBillingInfo setAccessToken(String string) {
                return (GetBillingInfo)super.setAccessToken(string);
            }

            public GetBillingInfo setAlt(String string) {
                return (GetBillingInfo)super.setAlt(string);
            }

            public GetBillingInfo setCallback(String string) {
                return (GetBillingInfo)super.setCallback(string);
            }

            public GetBillingInfo setFields(String string) {
                return (GetBillingInfo)super.setFields(string);
            }

            public GetBillingInfo setKey(String string) {
                return (GetBillingInfo)super.setKey(string);
            }

            public GetBillingInfo setOauthToken(String string) {
                return (GetBillingInfo)super.setOauthToken(string);
            }

            public GetBillingInfo setPrettyPrint(Boolean bl) {
                return (GetBillingInfo)super.setPrettyPrint(bl);
            }

            public GetBillingInfo setQuotaUser(String string) {
                return (GetBillingInfo)super.setQuotaUser(string);
            }

            public GetBillingInfo setUploadType(String string) {
                return (GetBillingInfo)super.setUploadType(string);
            }

            public GetBillingInfo setUploadProtocol(String string) {
                return (GetBillingInfo)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public GetBillingInfo setName(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public GetBillingInfo set(String string, Object object) {
                return (GetBillingInfo)super.set(string, object);
            }
        }
    }

    public class BillingAccounts {
        public Create create(BillingAccount billingAccount) throws IOException {
            Create create = new Create(billingAccount);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public List list() throws IOException {
            List list = new List();
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, BillingAccount billingAccount) throws IOException {
            Patch patch = new Patch(string, billingAccount);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        public Projects projects() {
            return new Projects();
        }

        public class Projects {
            public List list(String string) throws IOException {
                List list = new List(string);
                Cloudbilling.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends CloudbillingRequest<ListProjectBillingInfoResponse> {
                private static final String REST_PATH = "v1/{+name}/projects";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Cloudbilling.this, "GET", REST_PATH, null, ListProjectBillingInfoResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!Cloudbilling.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends CloudbillingRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends CloudbillingRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String string, BillingAccount billingAccount) {
                super(Cloudbilling.this, "PATCH", REST_PATH, (Object)billingAccount, BillingAccount.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public Patch set$Xgafv(String string) {
                return (Patch)super.set$Xgafv(string);
            }

            public Patch setAccessToken(String string) {
                return (Patch)super.setAccessToken(string);
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setCallback(String string) {
                return (Patch)super.setCallback(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUploadType(String string) {
                return (Patch)super.setUploadType(string);
            }

            public Patch setUploadProtocol(String string) {
                return (Patch)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = string;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String string) {
                this.updateMask = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudbillingRequest<ListBillingAccountsResponse> {
            private static final String REST_PATH = "v1/billingAccounts";
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Cloudbilling.this, "GET", REST_PATH, null, ListBillingAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends CloudbillingRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;
            @Key(value="options.requestedPolicyVersion")
            private Integer optionsRequestedPolicyVersion;

            protected GetIamPolicy(String string) {
                super(Cloudbilling.this, "GET", REST_PATH, null, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer n) {
                this.optionsRequestedPolicyVersion = n;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(Cloudbilling.this, "GET", REST_PATH, null, BillingAccount.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!Cloudbilling.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends CloudbillingRequest<BillingAccount> {
            private static final String REST_PATH = "v1/billingAccounts";

            protected Create(BillingAccount billingAccount) {
                super(Cloudbilling.this, "POST", REST_PATH, (Object)billingAccount, BillingAccount.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }
}

