/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudbuild.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudbuild.v1.CloudBuildRequest;
import com.google.api.services.cloudbuild.v1.CloudBuildRequestInitializer;
import com.google.api.services.cloudbuild.v1.model.ApproveBuildRequest;
import com.google.api.services.cloudbuild.v1.model.BatchCreateBitbucketServerConnectedRepositoriesRequest;
import com.google.api.services.cloudbuild.v1.model.BatchCreateGitLabConnectedRepositoriesRequest;
import com.google.api.services.cloudbuild.v1.model.BitbucketServerConfig;
import com.google.api.services.cloudbuild.v1.model.Build;
import com.google.api.services.cloudbuild.v1.model.BuildTrigger;
import com.google.api.services.cloudbuild.v1.model.CancelBuildRequest;
import com.google.api.services.cloudbuild.v1.model.CancelOperationRequest;
import com.google.api.services.cloudbuild.v1.model.DefaultServiceAccount;
import com.google.api.services.cloudbuild.v1.model.Empty;
import com.google.api.services.cloudbuild.v1.model.GitHubEnterpriseConfig;
import com.google.api.services.cloudbuild.v1.model.GitLabConfig;
import com.google.api.services.cloudbuild.v1.model.HttpBody;
import com.google.api.services.cloudbuild.v1.model.ListBitbucketServerConfigsResponse;
import com.google.api.services.cloudbuild.v1.model.ListBitbucketServerRepositoriesResponse;
import com.google.api.services.cloudbuild.v1.model.ListBuildTriggersResponse;
import com.google.api.services.cloudbuild.v1.model.ListBuildsResponse;
import com.google.api.services.cloudbuild.v1.model.ListGitLabConfigsResponse;
import com.google.api.services.cloudbuild.v1.model.ListGitLabRepositoriesResponse;
import com.google.api.services.cloudbuild.v1.model.ListGithubEnterpriseConfigsResponse;
import com.google.api.services.cloudbuild.v1.model.ListWorkerPoolsResponse;
import com.google.api.services.cloudbuild.v1.model.Operation;
import com.google.api.services.cloudbuild.v1.model.ReceiveTriggerWebhookResponse;
import com.google.api.services.cloudbuild.v1.model.RemoveBitbucketServerConnectedRepositoryRequest;
import com.google.api.services.cloudbuild.v1.model.RemoveGitLabConnectedRepositoryRequest;
import com.google.api.services.cloudbuild.v1.model.RepoSource;
import com.google.api.services.cloudbuild.v1.model.RetryBuildRequest;
import com.google.api.services.cloudbuild.v1.model.RunBuildTriggerRequest;
import com.google.api.services.cloudbuild.v1.model.WorkerPool;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudBuild
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudbuild.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudbuild.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudbuild.googleapis.com/";

    public CloudBuild(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudBuild(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public GithubDotComWebhook githubDotComWebhook() {
        return new GithubDotComWebhook();
    }

    public Locations locations() {
        return new Locations();
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    public V1 v1() {
        return new V1();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Build API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudBuild.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudbuild.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudBuild.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudBuild.DEFAULT_BATCH_PATH);
        }

        public CloudBuild build() {
            return new CloudBuild(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudBuildRequestInitializer(CloudBuildRequestInitializer cloudbuildRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudbuildRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class V1 {
        public Webhook webhook(HttpBody content) throws IOException {
            Webhook result = new Webhook(content);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Webhook
        extends CloudBuildRequest<Empty> {
            private static final String REST_PATH = "v1/webhook";
            @Key
            private String webhookKey;

            protected Webhook(HttpBody content) {
                super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public Webhook set$Xgafv(String $Xgafv) {
                return (Webhook)super.set$Xgafv($Xgafv);
            }

            public Webhook setAccessToken(String accessToken) {
                return (Webhook)super.setAccessToken(accessToken);
            }

            public Webhook setAlt(String alt) {
                return (Webhook)super.setAlt(alt);
            }

            public Webhook setCallback(String callback) {
                return (Webhook)super.setCallback(callback);
            }

            public Webhook setFields(String fields) {
                return (Webhook)super.setFields(fields);
            }

            public Webhook setKey(String key) {
                return (Webhook)super.setKey(key);
            }

            public Webhook setOauthToken(String oauthToken) {
                return (Webhook)super.setOauthToken(oauthToken);
            }

            public Webhook setPrettyPrint(Boolean prettyPrint) {
                return (Webhook)super.setPrettyPrint(prettyPrint);
            }

            public Webhook setQuotaUser(String quotaUser) {
                return (Webhook)super.setQuotaUser(quotaUser);
            }

            public Webhook setUploadType(String uploadType) {
                return (Webhook)super.setUploadType(uploadType);
            }

            public Webhook setUploadProtocol(String uploadProtocol) {
                return (Webhook)super.setUploadProtocol(uploadProtocol);
            }

            public String getWebhookKey() {
                return this.webhookKey;
            }

            public Webhook setWebhookKey(String webhookKey) {
                this.webhookKey = webhookKey;
                return this;
            }

            @Override
            public Webhook set(String parameterName, Object value) {
                return (Webhook)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public Builds builds() {
            return new Builds();
        }

        public GithubEnterpriseConfigs githubEnterpriseConfigs() {
            return new GithubEnterpriseConfigs();
        }

        public Locations locations() {
            return new Locations();
        }

        public Triggers triggers() {
            return new Triggers();
        }

        public class Triggers {
            public Create create(String projectId, BuildTrigger content) throws IOException {
                Create result = new Create(projectId, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String projectId, String triggerId) throws IOException {
                Delete result = new Delete(projectId, triggerId);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String triggerId) throws IOException {
                Get result = new Get(projectId, triggerId);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String projectId, String triggerId, BuildTrigger content) throws IOException {
                Patch result = new Patch(projectId, triggerId, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Run run(String projectId, String triggerId, RepoSource content) throws IOException {
                Run result = new Run(projectId, triggerId, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Webhook webhook(String projectId, String trigger, HttpBody content) throws IOException {
                Webhook result = new Webhook(projectId, trigger, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Webhook
            extends CloudBuildRequest<ReceiveTriggerWebhookResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{trigger}:webhook";
                @Key
                private String projectId;
                @Key
                private String trigger;
                @Key
                private String name;
                @Key
                private String secret;

                protected Webhook(String projectId, String trigger, HttpBody content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, ReceiveTriggerWebhookResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.trigger = (String)Preconditions.checkNotNull((Object)trigger, (Object)"Required parameter trigger must be specified.");
                }

                public Webhook set$Xgafv(String $Xgafv) {
                    return (Webhook)super.set$Xgafv($Xgafv);
                }

                public Webhook setAccessToken(String accessToken) {
                    return (Webhook)super.setAccessToken(accessToken);
                }

                public Webhook setAlt(String alt) {
                    return (Webhook)super.setAlt(alt);
                }

                public Webhook setCallback(String callback) {
                    return (Webhook)super.setCallback(callback);
                }

                public Webhook setFields(String fields) {
                    return (Webhook)super.setFields(fields);
                }

                public Webhook setKey(String key) {
                    return (Webhook)super.setKey(key);
                }

                public Webhook setOauthToken(String oauthToken) {
                    return (Webhook)super.setOauthToken(oauthToken);
                }

                public Webhook setPrettyPrint(Boolean prettyPrint) {
                    return (Webhook)super.setPrettyPrint(prettyPrint);
                }

                public Webhook setQuotaUser(String quotaUser) {
                    return (Webhook)super.setQuotaUser(quotaUser);
                }

                public Webhook setUploadType(String uploadType) {
                    return (Webhook)super.setUploadType(uploadType);
                }

                public Webhook setUploadProtocol(String uploadProtocol) {
                    return (Webhook)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Webhook setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTrigger() {
                    return this.trigger;
                }

                public Webhook setTrigger(String trigger) {
                    this.trigger = trigger;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Webhook setName(String name) {
                    this.name = name;
                    return this;
                }

                public String getSecret() {
                    return this.secret;
                }

                public Webhook setSecret(String secret) {
                    this.secret = secret;
                    return this;
                }

                @Override
                public Webhook set(String parameterName, Object value) {
                    return (Webhook)super.set(parameterName, value);
                }
            }

            public class Run
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}:run";
                @Key
                private String projectId;
                @Key
                private String triggerId;
                @Key
                private String name;

                protected Run(String projectId, String triggerId, RepoSource content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Run set$Xgafv(String $Xgafv) {
                    return (Run)super.set$Xgafv($Xgafv);
                }

                public Run setAccessToken(String accessToken) {
                    return (Run)super.setAccessToken(accessToken);
                }

                public Run setAlt(String alt) {
                    return (Run)super.setAlt(alt);
                }

                public Run setCallback(String callback) {
                    return (Run)super.setCallback(callback);
                }

                public Run setFields(String fields) {
                    return (Run)super.setFields(fields);
                }

                public Run setKey(String key) {
                    return (Run)super.setKey(key);
                }

                public Run setOauthToken(String oauthToken) {
                    return (Run)super.setOauthToken(oauthToken);
                }

                public Run setPrettyPrint(Boolean prettyPrint) {
                    return (Run)super.setPrettyPrint(prettyPrint);
                }

                public Run setQuotaUser(String quotaUser) {
                    return (Run)super.setQuotaUser(quotaUser);
                }

                public Run setUploadType(String uploadType) {
                    return (Run)super.setUploadType(uploadType);
                }

                public Run setUploadProtocol(String uploadProtocol) {
                    return (Run)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Run setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Run setTriggerId(String triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Run setName(String name) {
                    this.name = name;
                    return this;
                }

                @Override
                public Run set(String parameterName, Object value) {
                    return (Run)super.set(parameterName, value);
                }
            }

            public class Patch
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;
                @Key
                private String updateMask;

                protected Patch(String projectId, String triggerId, BuildTrigger content) {
                    super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Patch setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Patch setTriggerId(String triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudBuildRequest<ListBuildTriggersResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers";
                @Key
                private String projectId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String parent;

                protected List(String projectId) {
                    super(CloudBuild.this, "GET", REST_PATH, null, ListBuildTriggersResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    this.parent = parent;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;
                @Key
                private String name;

                protected Get(String projectId, String triggerId) {
                    super(CloudBuild.this, "GET", REST_PATH, null, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Get setTriggerId(String triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudBuildRequest<Empty> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;
                @Key
                private String name;

                protected Delete(String projectId, String triggerId) {
                    super(CloudBuild.this, "DELETE", REST_PATH, null, Empty.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)triggerId, (Object)"Required parameter triggerId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Delete setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Delete setTriggerId(String triggerId) {
                    this.triggerId = triggerId;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers";
                @Key
                private String projectId;
                @Key
                private String parent;

                protected Create(String projectId, BuildTrigger content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public GetDefaultServiceAccount getDefaultServiceAccount(String name) throws IOException {
                GetDefaultServiceAccount result = new GetDefaultServiceAccount(name);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BitbucketServerConfigs bitbucketServerConfigs() {
                return new BitbucketServerConfigs();
            }

            public Builds builds() {
                return new Builds();
            }

            public GitLabConfigs gitLabConfigs() {
                return new GitLabConfigs();
            }

            public GithubEnterpriseConfigs githubEnterpriseConfigs() {
                return new GithubEnterpriseConfigs();
            }

            public Operations operations() {
                return new Operations();
            }

            public Triggers triggers() {
                return new Triggers();
            }

            public WorkerPools workerPools() {
                return new WorkerPools();
            }

            public class WorkerPools {
                public Create create(String parent, WorkerPool content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, WorkerPool content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;
                    @Key
                    private Boolean validateOnly;

                    protected Patch(String name, WorkerPool content) {
                        super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Patch setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListWorkerPoolsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/workerPools";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListWorkerPoolsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<WorkerPool> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, WorkerPool.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean allowMissing;
                    @Key
                    private String etag;
                    @Key
                    private Boolean validateOnly;

                    protected Delete(String name) {
                        super(CloudBuild.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workerPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getAllowMissing() {
                        return this.allowMissing;
                    }

                    public Delete setAllowMissing(Boolean allowMissing) {
                        this.allowMissing = allowMissing;
                        return this;
                    }

                    public String getEtag() {
                        return this.etag;
                    }

                    public Delete setEtag(String etag) {
                        this.etag = etag;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Delete setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/workerPools";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Boolean validateOnly;
                    @Key
                    private String workerPoolId;

                    protected Create(String parent, WorkerPool content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Create setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    public String getWorkerPoolId() {
                        return this.workerPoolId;
                    }

                    public Create setWorkerPoolId(String workerPoolId) {
                        this.workerPoolId = workerPoolId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Triggers {
                public Create create(String parent, BuildTrigger content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String resourceName, BuildTrigger content) throws IOException {
                    Patch result = new Patch(resourceName, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Run run(String name, RunBuildTriggerRequest content) throws IOException {
                    Run result = new Run(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Webhook webhook(String name, HttpBody content) throws IOException {
                    Webhook result = new Webhook(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Webhook
                extends CloudBuildRequest<ReceiveTriggerWebhookResponse> {
                    private static final String REST_PATH = "v1/{+name}:webhook";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String projectId;
                    @Key
                    private String secret;
                    @Key
                    private String trigger;

                    protected Webhook(String name, HttpBody content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, ReceiveTriggerWebhookResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                    }

                    public Webhook set$Xgafv(String $Xgafv) {
                        return (Webhook)super.set$Xgafv($Xgafv);
                    }

                    public Webhook setAccessToken(String accessToken) {
                        return (Webhook)super.setAccessToken(accessToken);
                    }

                    public Webhook setAlt(String alt) {
                        return (Webhook)super.setAlt(alt);
                    }

                    public Webhook setCallback(String callback) {
                        return (Webhook)super.setCallback(callback);
                    }

                    public Webhook setFields(String fields) {
                        return (Webhook)super.setFields(fields);
                    }

                    public Webhook setKey(String key) {
                        return (Webhook)super.setKey(key);
                    }

                    public Webhook setOauthToken(String oauthToken) {
                        return (Webhook)super.setOauthToken(oauthToken);
                    }

                    public Webhook setPrettyPrint(Boolean prettyPrint) {
                        return (Webhook)super.setPrettyPrint(prettyPrint);
                    }

                    public Webhook setQuotaUser(String quotaUser) {
                        return (Webhook)super.setQuotaUser(quotaUser);
                    }

                    public Webhook setUploadType(String uploadType) {
                        return (Webhook)super.setUploadType(uploadType);
                    }

                    public Webhook setUploadProtocol(String uploadProtocol) {
                        return (Webhook)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Webhook setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Webhook setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getSecret() {
                        return this.secret;
                    }

                    public Webhook setSecret(String secret) {
                        this.secret = secret;
                        return this;
                    }

                    public String getTrigger() {
                        return this.trigger;
                    }

                    public Webhook setTrigger(String trigger) {
                        this.trigger = trigger;
                        return this;
                    }

                    @Override
                    public Webhook set(String parameterName, Object value) {
                        return (Webhook)super.set(parameterName, value);
                    }
                }

                public class Run
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:run";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Run(String name, RunBuildTriggerRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                    }

                    public Run set$Xgafv(String $Xgafv) {
                        return (Run)super.set$Xgafv($Xgafv);
                    }

                    public Run setAccessToken(String accessToken) {
                        return (Run)super.setAccessToken(accessToken);
                    }

                    public Run setAlt(String alt) {
                        return (Run)super.setAlt(alt);
                    }

                    public Run setCallback(String callback) {
                        return (Run)super.setCallback(callback);
                    }

                    public Run setFields(String fields) {
                        return (Run)super.setFields(fields);
                    }

                    public Run setKey(String key) {
                        return (Run)super.setKey(key);
                    }

                    public Run setOauthToken(String oauthToken) {
                        return (Run)super.setOauthToken(oauthToken);
                    }

                    public Run setPrettyPrint(Boolean prettyPrint) {
                        return (Run)super.setPrettyPrint(prettyPrint);
                    }

                    public Run setQuotaUser(String quotaUser) {
                        return (Run)super.setQuotaUser(quotaUser);
                    }

                    public Run setUploadType(String uploadType) {
                        return (Run)super.setUploadType(uploadType);
                    }

                    public Run setUploadProtocol(String uploadProtocol) {
                        return (Run)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Run setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Run set(String parameterName, Object value) {
                        return (Run)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudBuildRequest<BuildTrigger> {
                    private static final String REST_PATH = "v1/{+resourceName}";
                    private final Pattern RESOURCE_NAME_PATTERN;
                    @Key
                    private String resourceName;
                    @Key
                    private String projectId;
                    @Key
                    private String triggerId;
                    @Key
                    private String updateMask;

                    protected Patch(String resourceName, BuildTrigger content) {
                        super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, BuildTrigger.class);
                        this.RESOURCE_NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResourceName() {
                        return this.resourceName;
                    }

                    public Patch setResourceName(String resourceName) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                        this.resourceName = resourceName;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getTriggerId() {
                        return this.triggerId;
                    }

                    public Patch setTriggerId(String triggerId) {
                        this.triggerId = triggerId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListBuildTriggersResponse> {
                    private static final String REST_PATH = "v1/{+parent}/triggers";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String projectId;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListBuildTriggersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<BuildTrigger> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String projectId;
                    @Key
                    private String triggerId;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, BuildTrigger.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getTriggerId() {
                        return this.triggerId;
                    }

                    public Get setTriggerId(String triggerId) {
                        this.triggerId = triggerId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudBuildRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String projectId;
                    @Key
                    private String triggerId;

                    protected Delete(String name) {
                        super(CloudBuild.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/triggers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getTriggerId() {
                        return this.triggerId;
                    }

                    public Delete setTriggerId(String triggerId) {
                        this.triggerId = triggerId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<BuildTrigger> {
                    private static final String REST_PATH = "v1/{+parent}/triggers";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;

                    protected Create(String parent, BuildTrigger content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, BuildTrigger.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends CloudBuildRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class GithubEnterpriseConfigs {
                public Create create(String parent, GitHubEnterpriseConfig content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, GitHubEnterpriseConfig content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, GitHubEnterpriseConfig content) {
                        super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListGithubEnterpriseConfigsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/githubEnterpriseConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListGithubEnterpriseConfigsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<GitHubEnterpriseConfig> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String configId;
                    @Key
                    private String projectId;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, GitHubEnterpriseConfig.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getConfigId() {
                        return this.configId;
                    }

                    public Get setConfigId(String configId) {
                        this.configId = configId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String configId;
                    @Key
                    private String projectId;

                    protected Delete(String name) {
                        super(CloudBuild.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/githubEnterpriseConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getConfigId() {
                        return this.configId;
                    }

                    public Delete setConfigId(String configId) {
                        this.configId = configId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/githubEnterpriseConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String gheConfigId;
                    @Key
                    private String projectId;

                    protected Create(String parent, GitHubEnterpriseConfig content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getGheConfigId() {
                        return this.gheConfigId;
                    }

                    public Create setGheConfigId(String gheConfigId) {
                        this.gheConfigId = gheConfigId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class GitLabConfigs {
                public Create create(String parent, GitLabConfig content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, GitLabConfig content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public RemoveGitLabConnectedRepository removeGitLabConnectedRepository(String config, RemoveGitLabConnectedRepositoryRequest content) throws IOException {
                    RemoveGitLabConnectedRepository result = new RemoveGitLabConnectedRepository(config, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ConnectedRepositories connectedRepositories() {
                    return new ConnectedRepositories();
                }

                public Repos repos() {
                    return new Repos();
                }

                public class Repos {
                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends CloudBuildRequest<ListGitLabRepositoriesResponse> {
                        private static final String REST_PATH = "v1/{+parent}/repos";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudBuild.this, "GET", REST_PATH, null, ListGitLabRepositoriesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class ConnectedRepositories {
                    public BatchCreate batchCreate(String parent, BatchCreateGitLabConnectedRepositoriesRequest content) throws IOException {
                        BatchCreate result = new BatchCreate(parent, content);
                        CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class BatchCreate
                    extends CloudBuildRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/connectedRepositories:batchCreate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchCreate(String parent, BatchCreateGitLabConnectedRepositoriesRequest content) {
                            super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            }
                        }

                        public BatchCreate set$Xgafv(String $Xgafv) {
                            return (BatchCreate)super.set$Xgafv($Xgafv);
                        }

                        public BatchCreate setAccessToken(String accessToken) {
                            return (BatchCreate)super.setAccessToken(accessToken);
                        }

                        public BatchCreate setAlt(String alt) {
                            return (BatchCreate)super.setAlt(alt);
                        }

                        public BatchCreate setCallback(String callback) {
                            return (BatchCreate)super.setCallback(callback);
                        }

                        public BatchCreate setFields(String fields) {
                            return (BatchCreate)super.setFields(fields);
                        }

                        public BatchCreate setKey(String key) {
                            return (BatchCreate)super.setKey(key);
                        }

                        public BatchCreate setOauthToken(String oauthToken) {
                            return (BatchCreate)super.setOauthToken(oauthToken);
                        }

                        public BatchCreate setPrettyPrint(Boolean prettyPrint) {
                            return (BatchCreate)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchCreate setQuotaUser(String quotaUser) {
                            return (BatchCreate)super.setQuotaUser(quotaUser);
                        }

                        public BatchCreate setUploadType(String uploadType) {
                            return (BatchCreate)super.setUploadType(uploadType);
                        }

                        public BatchCreate setUploadProtocol(String uploadProtocol) {
                            return (BatchCreate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchCreate setParent(String parent) {
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public BatchCreate set(String parameterName, Object value) {
                            return (BatchCreate)super.set(parameterName, value);
                        }
                    }
                }

                public class RemoveGitLabConnectedRepository
                extends CloudBuildRequest<Empty> {
                    private static final String REST_PATH = "v1/{+config}:removeGitLabConnectedRepository";
                    private final Pattern CONFIG_PATTERN;
                    @Key
                    private String config;

                    protected RemoveGitLabConnectedRepository(String config, RemoveGitLabConnectedRepositoryRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.CONFIG_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        this.config = (String)Preconditions.checkNotNull((Object)config, (Object)"Required parameter config must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.CONFIG_PATTERN.matcher(config).matches(), (Object)"Parameter config must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                    }

                    public RemoveGitLabConnectedRepository set$Xgafv(String $Xgafv) {
                        return (RemoveGitLabConnectedRepository)super.set$Xgafv($Xgafv);
                    }

                    public RemoveGitLabConnectedRepository setAccessToken(String accessToken) {
                        return (RemoveGitLabConnectedRepository)super.setAccessToken(accessToken);
                    }

                    public RemoveGitLabConnectedRepository setAlt(String alt) {
                        return (RemoveGitLabConnectedRepository)super.setAlt(alt);
                    }

                    public RemoveGitLabConnectedRepository setCallback(String callback) {
                        return (RemoveGitLabConnectedRepository)super.setCallback(callback);
                    }

                    public RemoveGitLabConnectedRepository setFields(String fields) {
                        return (RemoveGitLabConnectedRepository)super.setFields(fields);
                    }

                    public RemoveGitLabConnectedRepository setKey(String key) {
                        return (RemoveGitLabConnectedRepository)super.setKey(key);
                    }

                    public RemoveGitLabConnectedRepository setOauthToken(String oauthToken) {
                        return (RemoveGitLabConnectedRepository)super.setOauthToken(oauthToken);
                    }

                    public RemoveGitLabConnectedRepository setPrettyPrint(Boolean prettyPrint) {
                        return (RemoveGitLabConnectedRepository)super.setPrettyPrint(prettyPrint);
                    }

                    public RemoveGitLabConnectedRepository setQuotaUser(String quotaUser) {
                        return (RemoveGitLabConnectedRepository)super.setQuotaUser(quotaUser);
                    }

                    public RemoveGitLabConnectedRepository setUploadType(String uploadType) {
                        return (RemoveGitLabConnectedRepository)super.setUploadType(uploadType);
                    }

                    public RemoveGitLabConnectedRepository setUploadProtocol(String uploadProtocol) {
                        return (RemoveGitLabConnectedRepository)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getConfig() {
                        return this.config;
                    }

                    public RemoveGitLabConnectedRepository setConfig(String config) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.CONFIG_PATTERN.matcher(config).matches(), (Object)"Parameter config must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                        this.config = config;
                        return this;
                    }

                    @Override
                    public RemoveGitLabConnectedRepository set(String parameterName, Object value) {
                        return (RemoveGitLabConnectedRepository)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, GitLabConfig content) {
                        super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListGitLabConfigsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/gitLabConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListGitLabConfigsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<GitLabConfig> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, GitLabConfig.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(CloudBuild.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/gitLabConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/gitLabConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String gitlabConfigId;

                    protected Create(String parent, GitLabConfig content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getGitlabConfigId() {
                        return this.gitlabConfigId;
                    }

                    public Create setGitlabConfigId(String gitlabConfigId) {
                        this.gitlabConfigId = gitlabConfigId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Builds {
                public Approve approve(String name, ApproveBuildRequest content) throws IOException {
                    Approve result = new Approve(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Cancel cancel(String name, CancelBuildRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, Build content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Retry retry(String name, RetryBuildRequest content) throws IOException {
                    Retry result = new Retry(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Retry
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:retry";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Retry(String name, RetryBuildRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                    }

                    public Retry set$Xgafv(String $Xgafv) {
                        return (Retry)super.set$Xgafv($Xgafv);
                    }

                    public Retry setAccessToken(String accessToken) {
                        return (Retry)super.setAccessToken(accessToken);
                    }

                    public Retry setAlt(String alt) {
                        return (Retry)super.setAlt(alt);
                    }

                    public Retry setCallback(String callback) {
                        return (Retry)super.setCallback(callback);
                    }

                    public Retry setFields(String fields) {
                        return (Retry)super.setFields(fields);
                    }

                    public Retry setKey(String key) {
                        return (Retry)super.setKey(key);
                    }

                    public Retry setOauthToken(String oauthToken) {
                        return (Retry)super.setOauthToken(oauthToken);
                    }

                    public Retry setPrettyPrint(Boolean prettyPrint) {
                        return (Retry)super.setPrettyPrint(prettyPrint);
                    }

                    public Retry setQuotaUser(String quotaUser) {
                        return (Retry)super.setQuotaUser(quotaUser);
                    }

                    public Retry setUploadType(String uploadType) {
                        return (Retry)super.setUploadType(uploadType);
                    }

                    public Retry setUploadProtocol(String uploadProtocol) {
                        return (Retry)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Retry setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Retry set(String parameterName, Object value) {
                        return (Retry)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListBuildsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/builds";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String projectId;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListBuildsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<Build> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String id;
                    @Key
                    private String projectId;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, Build.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String id) {
                        this.id = id;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/builds";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;

                    protected Create(String parent, Build content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends CloudBuildRequest<Build> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelBuildRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Build.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }

                public class Approve
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:approve";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Approve(String name, ApproveBuildRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                    }

                    public Approve set$Xgafv(String $Xgafv) {
                        return (Approve)super.set$Xgafv($Xgafv);
                    }

                    public Approve setAccessToken(String accessToken) {
                        return (Approve)super.setAccessToken(accessToken);
                    }

                    public Approve setAlt(String alt) {
                        return (Approve)super.setAlt(alt);
                    }

                    public Approve setCallback(String callback) {
                        return (Approve)super.setCallback(callback);
                    }

                    public Approve setFields(String fields) {
                        return (Approve)super.setFields(fields);
                    }

                    public Approve setKey(String key) {
                        return (Approve)super.setKey(key);
                    }

                    public Approve setOauthToken(String oauthToken) {
                        return (Approve)super.setOauthToken(oauthToken);
                    }

                    public Approve setPrettyPrint(Boolean prettyPrint) {
                        return (Approve)super.setPrettyPrint(prettyPrint);
                    }

                    public Approve setQuotaUser(String quotaUser) {
                        return (Approve)super.setQuotaUser(quotaUser);
                    }

                    public Approve setUploadType(String uploadType) {
                        return (Approve)super.setUploadType(uploadType);
                    }

                    public Approve setUploadProtocol(String uploadProtocol) {
                        return (Approve)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Approve setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/builds/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Approve set(String parameterName, Object value) {
                        return (Approve)super.set(parameterName, value);
                    }
                }
            }

            public class BitbucketServerConfigs {
                public Create create(String parent, BitbucketServerConfig content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, BitbucketServerConfig content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public RemoveBitbucketServerConnectedRepository removeBitbucketServerConnectedRepository(String config, RemoveBitbucketServerConnectedRepositoryRequest content) throws IOException {
                    RemoveBitbucketServerConnectedRepository result = new RemoveBitbucketServerConnectedRepository(config, content);
                    CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ConnectedRepositories connectedRepositories() {
                    return new ConnectedRepositories();
                }

                public Repos repos() {
                    return new Repos();
                }

                public class Repos {
                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends CloudBuildRequest<ListBitbucketServerRepositoriesResponse> {
                        private static final String REST_PATH = "v1/{+parent}/repos";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudBuild.this, "GET", REST_PATH, null, ListBitbucketServerRepositoriesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class ConnectedRepositories {
                    public BatchCreate batchCreate(String parent, BatchCreateBitbucketServerConnectedRepositoriesRequest content) throws IOException {
                        BatchCreate result = new BatchCreate(parent, content);
                        CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class BatchCreate
                    extends CloudBuildRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/connectedRepositories:batchCreate";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected BatchCreate(String parent, BatchCreateBitbucketServerConnectedRepositoriesRequest content) {
                            super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            }
                        }

                        public BatchCreate set$Xgafv(String $Xgafv) {
                            return (BatchCreate)super.set$Xgafv($Xgafv);
                        }

                        public BatchCreate setAccessToken(String accessToken) {
                            return (BatchCreate)super.setAccessToken(accessToken);
                        }

                        public BatchCreate setAlt(String alt) {
                            return (BatchCreate)super.setAlt(alt);
                        }

                        public BatchCreate setCallback(String callback) {
                            return (BatchCreate)super.setCallback(callback);
                        }

                        public BatchCreate setFields(String fields) {
                            return (BatchCreate)super.setFields(fields);
                        }

                        public BatchCreate setKey(String key) {
                            return (BatchCreate)super.setKey(key);
                        }

                        public BatchCreate setOauthToken(String oauthToken) {
                            return (BatchCreate)super.setOauthToken(oauthToken);
                        }

                        public BatchCreate setPrettyPrint(Boolean prettyPrint) {
                            return (BatchCreate)super.setPrettyPrint(prettyPrint);
                        }

                        public BatchCreate setQuotaUser(String quotaUser) {
                            return (BatchCreate)super.setQuotaUser(quotaUser);
                        }

                        public BatchCreate setUploadType(String uploadType) {
                            return (BatchCreate)super.setUploadType(uploadType);
                        }

                        public BatchCreate setUploadProtocol(String uploadProtocol) {
                            return (BatchCreate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public BatchCreate setParent(String parent) {
                            if (!CloudBuild.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public BatchCreate set(String parameterName, Object value) {
                            return (BatchCreate)super.set(parameterName, value);
                        }
                    }
                }

                public class RemoveBitbucketServerConnectedRepository
                extends CloudBuildRequest<Empty> {
                    private static final String REST_PATH = "v1/{+config}:removeBitbucketServerConnectedRepository";
                    private final Pattern CONFIG_PATTERN;
                    @Key
                    private String config;

                    protected RemoveBitbucketServerConnectedRepository(String config, RemoveBitbucketServerConnectedRepositoryRequest content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.CONFIG_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        this.config = (String)Preconditions.checkNotNull((Object)config, (Object)"Required parameter config must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.CONFIG_PATTERN.matcher(config).matches(), (Object)"Parameter config must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                    }

                    public RemoveBitbucketServerConnectedRepository set$Xgafv(String $Xgafv) {
                        return (RemoveBitbucketServerConnectedRepository)super.set$Xgafv($Xgafv);
                    }

                    public RemoveBitbucketServerConnectedRepository setAccessToken(String accessToken) {
                        return (RemoveBitbucketServerConnectedRepository)super.setAccessToken(accessToken);
                    }

                    public RemoveBitbucketServerConnectedRepository setAlt(String alt) {
                        return (RemoveBitbucketServerConnectedRepository)super.setAlt(alt);
                    }

                    public RemoveBitbucketServerConnectedRepository setCallback(String callback) {
                        return (RemoveBitbucketServerConnectedRepository)super.setCallback(callback);
                    }

                    public RemoveBitbucketServerConnectedRepository setFields(String fields) {
                        return (RemoveBitbucketServerConnectedRepository)super.setFields(fields);
                    }

                    public RemoveBitbucketServerConnectedRepository setKey(String key) {
                        return (RemoveBitbucketServerConnectedRepository)super.setKey(key);
                    }

                    public RemoveBitbucketServerConnectedRepository setOauthToken(String oauthToken) {
                        return (RemoveBitbucketServerConnectedRepository)super.setOauthToken(oauthToken);
                    }

                    public RemoveBitbucketServerConnectedRepository setPrettyPrint(Boolean prettyPrint) {
                        return (RemoveBitbucketServerConnectedRepository)super.setPrettyPrint(prettyPrint);
                    }

                    public RemoveBitbucketServerConnectedRepository setQuotaUser(String quotaUser) {
                        return (RemoveBitbucketServerConnectedRepository)super.setQuotaUser(quotaUser);
                    }

                    public RemoveBitbucketServerConnectedRepository setUploadType(String uploadType) {
                        return (RemoveBitbucketServerConnectedRepository)super.setUploadType(uploadType);
                    }

                    public RemoveBitbucketServerConnectedRepository setUploadProtocol(String uploadProtocol) {
                        return (RemoveBitbucketServerConnectedRepository)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getConfig() {
                        return this.config;
                    }

                    public RemoveBitbucketServerConnectedRepository setConfig(String config) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.CONFIG_PATTERN.matcher(config).matches(), (Object)"Parameter config must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                        this.config = config;
                        return this;
                    }

                    @Override
                    public RemoveBitbucketServerConnectedRepository set(String parameterName, Object value) {
                        return (RemoveBitbucketServerConnectedRepository)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, BitbucketServerConfig content) {
                        super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudBuildRequest<ListBitbucketServerConfigsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/bitbucketServerConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudBuild.this, "GET", REST_PATH, null, ListBitbucketServerConfigsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudBuildRequest<BitbucketServerConfig> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudBuild.this, "GET", REST_PATH, null, BitbucketServerConfig.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(CloudBuild.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/bitbucketServerConfigs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudBuildRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/bitbucketServerConfigs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String bitbucketServerConfigId;

                    protected Create(String parent, BitbucketServerConfig content) {
                        super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudBuild.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBitbucketServerConfigId() {
                        return this.bitbucketServerConfigId;
                    }

                    public Create setBitbucketServerConfigId(String bitbucketServerConfigId) {
                        this.bitbucketServerConfigId = bitbucketServerConfigId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class GetDefaultServiceAccount
            extends CloudBuildRequest<DefaultServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetDefaultServiceAccount(String name) {
                    super(CloudBuild.this, "GET", REST_PATH, null, DefaultServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/defaultServiceAccount$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/defaultServiceAccount$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetDefaultServiceAccount set$Xgafv(String $Xgafv) {
                    return (GetDefaultServiceAccount)super.set$Xgafv($Xgafv);
                }

                public GetDefaultServiceAccount setAccessToken(String accessToken) {
                    return (GetDefaultServiceAccount)super.setAccessToken(accessToken);
                }

                public GetDefaultServiceAccount setAlt(String alt) {
                    return (GetDefaultServiceAccount)super.setAlt(alt);
                }

                public GetDefaultServiceAccount setCallback(String callback) {
                    return (GetDefaultServiceAccount)super.setCallback(callback);
                }

                public GetDefaultServiceAccount setFields(String fields) {
                    return (GetDefaultServiceAccount)super.setFields(fields);
                }

                public GetDefaultServiceAccount setKey(String key) {
                    return (GetDefaultServiceAccount)super.setKey(key);
                }

                public GetDefaultServiceAccount setOauthToken(String oauthToken) {
                    return (GetDefaultServiceAccount)super.setOauthToken(oauthToken);
                }

                public GetDefaultServiceAccount setPrettyPrint(Boolean prettyPrint) {
                    return (GetDefaultServiceAccount)super.setPrettyPrint(prettyPrint);
                }

                public GetDefaultServiceAccount setQuotaUser(String quotaUser) {
                    return (GetDefaultServiceAccount)super.setQuotaUser(quotaUser);
                }

                public GetDefaultServiceAccount setUploadType(String uploadType) {
                    return (GetDefaultServiceAccount)super.setUploadType(uploadType);
                }

                public GetDefaultServiceAccount setUploadProtocol(String uploadProtocol) {
                    return (GetDefaultServiceAccount)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetDefaultServiceAccount setName(String name) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/defaultServiceAccount$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetDefaultServiceAccount set(String parameterName, Object value) {
                    return (GetDefaultServiceAccount)super.set(parameterName, value);
                }
            }
        }

        public class GithubEnterpriseConfigs {
            public Create create(String parent, GitHubEnterpriseConfig content) throws IOException {
                Create result = new Create(parent, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, GitHubEnterpriseConfig content) throws IOException {
                Patch result = new Patch(name, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, GitHubEnterpriseConfig content) {
                    super(CloudBuild.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudBuildRequest<ListGithubEnterpriseConfigsResponse> {
                private static final String REST_PATH = "v1/{+parent}/githubEnterpriseConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String projectId;

                protected List(String parent) {
                    super(CloudBuild.this, "GET", REST_PATH, null, ListGithubEnterpriseConfigsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudBuildRequest<GitHubEnterpriseConfig> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String configId;
                @Key
                private String projectId;

                protected Get(String name) {
                    super(CloudBuild.this, "GET", REST_PATH, null, GitHubEnterpriseConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getConfigId() {
                    return this.configId;
                }

                public Get setConfigId(String configId) {
                    this.configId = configId;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String configId;
                @Key
                private String projectId;

                protected Delete(String name) {
                    super(CloudBuild.this, "DELETE", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/githubEnterpriseConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getConfigId() {
                    return this.configId;
                }

                public Delete setConfigId(String configId) {
                    this.configId = configId;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Delete setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/githubEnterpriseConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String gheConfigId;
                @Key
                private String projectId;

                protected Create(String parent, GitHubEnterpriseConfig content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getGheConfigId() {
                    return this.gheConfigId;
                }

                public Create setGheConfigId(String gheConfigId) {
                    this.gheConfigId = gheConfigId;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Builds {
            public Approve approve(String name, ApproveBuildRequest content) throws IOException {
                Approve result = new Approve(name, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Cancel cancel(String projectId, String id, CancelBuildRequest content) throws IOException {
                Cancel result = new Cancel(projectId, id, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String projectId, Build content) throws IOException {
                Create result = new Create(projectId, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String id) throws IOException {
                Get result = new Get(projectId, id);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Retry retry(String projectId, String id, RetryBuildRequest content) throws IOException {
                Retry result = new Retry(projectId, id, content);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Retry
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:retry";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Retry(String projectId, String id, RetryBuildRequest content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Retry set$Xgafv(String $Xgafv) {
                    return (Retry)super.set$Xgafv($Xgafv);
                }

                public Retry setAccessToken(String accessToken) {
                    return (Retry)super.setAccessToken(accessToken);
                }

                public Retry setAlt(String alt) {
                    return (Retry)super.setAlt(alt);
                }

                public Retry setCallback(String callback) {
                    return (Retry)super.setCallback(callback);
                }

                public Retry setFields(String fields) {
                    return (Retry)super.setFields(fields);
                }

                public Retry setKey(String key) {
                    return (Retry)super.setKey(key);
                }

                public Retry setOauthToken(String oauthToken) {
                    return (Retry)super.setOauthToken(oauthToken);
                }

                public Retry setPrettyPrint(Boolean prettyPrint) {
                    return (Retry)super.setPrettyPrint(prettyPrint);
                }

                public Retry setQuotaUser(String quotaUser) {
                    return (Retry)super.setQuotaUser(quotaUser);
                }

                public Retry setUploadType(String uploadType) {
                    return (Retry)super.setUploadType(uploadType);
                }

                public Retry setUploadProtocol(String uploadProtocol) {
                    return (Retry)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Retry setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Retry setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Retry set(String parameterName, Object value) {
                    return (Retry)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudBuildRequest<ListBuildsResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds";
                @Key
                private String projectId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String parent;

                protected List(String projectId) {
                    super(CloudBuild.this, "GET", REST_PATH, null, ListBuildsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    this.parent = parent;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudBuildRequest<Build> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}";
                @Key
                private String projectId;
                @Key
                private String id;
                @Key
                private String name;

                protected Get(String projectId, String id) {
                    super(CloudBuild.this, "GET", REST_PATH, null, Build.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds";
                @Key
                private String projectId;
                @Key
                private String parent;

                protected Create(String projectId, Build content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends CloudBuildRequest<Build> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:cancel";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Cancel(String projectId, String id, CancelBuildRequest content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Build.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Cancel setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Cancel setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }

            public class Approve
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:approve";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Approve(String name, ApproveBuildRequest content) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/builds/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/builds/[^/]+$");
                    }
                }

                public Approve set$Xgafv(String $Xgafv) {
                    return (Approve)super.set$Xgafv($Xgafv);
                }

                public Approve setAccessToken(String accessToken) {
                    return (Approve)super.setAccessToken(accessToken);
                }

                public Approve setAlt(String alt) {
                    return (Approve)super.setAlt(alt);
                }

                public Approve setCallback(String callback) {
                    return (Approve)super.setCallback(callback);
                }

                public Approve setFields(String fields) {
                    return (Approve)super.setFields(fields);
                }

                public Approve setKey(String key) {
                    return (Approve)super.setKey(key);
                }

                public Approve setOauthToken(String oauthToken) {
                    return (Approve)super.setOauthToken(oauthToken);
                }

                public Approve setPrettyPrint(Boolean prettyPrint) {
                    return (Approve)super.setPrettyPrint(prettyPrint);
                }

                public Approve setQuotaUser(String quotaUser) {
                    return (Approve)super.setQuotaUser(quotaUser);
                }

                public Approve setUploadType(String uploadType) {
                    return (Approve)super.setUploadType(uploadType);
                }

                public Approve setUploadProtocol(String uploadProtocol) {
                    return (Approve)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Approve setName(String name) {
                    if (!CloudBuild.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/builds/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Approve set(String parameterName, Object value) {
                    return (Approve)super.set(parameterName, value);
                }
            }
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends CloudBuildRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudBuild.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends CloudBuildRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Locations {
        public RegionalWebhook regionalWebhook(String location, HttpBody content) throws IOException {
            RegionalWebhook result = new RegionalWebhook(location, content);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class RegionalWebhook
        extends CloudBuildRequest<Empty> {
            private static final String REST_PATH = "v1/{+location}/regionalWebhook";
            private final Pattern LOCATION_PATTERN;
            @Key
            private String location;
            @Key
            private String webhookKey;

            protected RegionalWebhook(String location, HttpBody content) {
                super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.LOCATION_PATTERN = Pattern.compile("^locations/[^/]+$");
                this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOCATION_PATTERN.matcher(location).matches(), (Object)"Parameter location must conform to the pattern ^locations/[^/]+$");
                }
            }

            public RegionalWebhook set$Xgafv(String $Xgafv) {
                return (RegionalWebhook)super.set$Xgafv($Xgafv);
            }

            public RegionalWebhook setAccessToken(String accessToken) {
                return (RegionalWebhook)super.setAccessToken(accessToken);
            }

            public RegionalWebhook setAlt(String alt) {
                return (RegionalWebhook)super.setAlt(alt);
            }

            public RegionalWebhook setCallback(String callback) {
                return (RegionalWebhook)super.setCallback(callback);
            }

            public RegionalWebhook setFields(String fields) {
                return (RegionalWebhook)super.setFields(fields);
            }

            public RegionalWebhook setKey(String key) {
                return (RegionalWebhook)super.setKey(key);
            }

            public RegionalWebhook setOauthToken(String oauthToken) {
                return (RegionalWebhook)super.setOauthToken(oauthToken);
            }

            public RegionalWebhook setPrettyPrint(Boolean prettyPrint) {
                return (RegionalWebhook)super.setPrettyPrint(prettyPrint);
            }

            public RegionalWebhook setQuotaUser(String quotaUser) {
                return (RegionalWebhook)super.setQuotaUser(quotaUser);
            }

            public RegionalWebhook setUploadType(String uploadType) {
                return (RegionalWebhook)super.setUploadType(uploadType);
            }

            public RegionalWebhook setUploadProtocol(String uploadProtocol) {
                return (RegionalWebhook)super.setUploadProtocol(uploadProtocol);
            }

            public String getLocation() {
                return this.location;
            }

            public RegionalWebhook setLocation(String location) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOCATION_PATTERN.matcher(location).matches(), (Object)"Parameter location must conform to the pattern ^locations/[^/]+$");
                }
                this.location = location;
                return this;
            }

            public String getWebhookKey() {
                return this.webhookKey;
            }

            public RegionalWebhook setWebhookKey(String webhookKey) {
                this.webhookKey = webhookKey;
                return this;
            }

            @Override
            public RegionalWebhook set(String parameterName, Object value) {
                return (RegionalWebhook)super.set(parameterName, value);
            }
        }
    }

    public class GithubDotComWebhook {
        public Receive receive(HttpBody content) throws IOException {
            Receive result = new Receive(content);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Receive
        extends CloudBuildRequest<Empty> {
            private static final String REST_PATH = "v1/githubDotComWebhook:receive";
            @Key
            private String webhookKey;

            protected Receive(HttpBody content) {
                super(CloudBuild.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public Receive set$Xgafv(String $Xgafv) {
                return (Receive)super.set$Xgafv($Xgafv);
            }

            public Receive setAccessToken(String accessToken) {
                return (Receive)super.setAccessToken(accessToken);
            }

            public Receive setAlt(String alt) {
                return (Receive)super.setAlt(alt);
            }

            public Receive setCallback(String callback) {
                return (Receive)super.setCallback(callback);
            }

            public Receive setFields(String fields) {
                return (Receive)super.setFields(fields);
            }

            public Receive setKey(String key) {
                return (Receive)super.setKey(key);
            }

            public Receive setOauthToken(String oauthToken) {
                return (Receive)super.setOauthToken(oauthToken);
            }

            public Receive setPrettyPrint(Boolean prettyPrint) {
                return (Receive)super.setPrettyPrint(prettyPrint);
            }

            public Receive setQuotaUser(String quotaUser) {
                return (Receive)super.setQuotaUser(quotaUser);
            }

            public Receive setUploadType(String uploadType) {
                return (Receive)super.setUploadType(uploadType);
            }

            public Receive setUploadProtocol(String uploadProtocol) {
                return (Receive)super.setUploadProtocol(uploadProtocol);
            }

            public String getWebhookKey() {
                return this.webhookKey;
            }

            public Receive setWebhookKey(String webhookKey) {
                this.webhookKey = webhookKey;
                return this;
            }

            @Override
            public Receive set(String parameterName, Object value) {
                return (Receive)super.set(parameterName, value);
            }
        }
    }
}

