/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-07 at 05:48:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1;

/**
 * Service definition for CloudBuild (v1).
 *
 * <p>
 * Creates and manages builds on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/cloud-build/docs/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudBuildRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class CloudBuild extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Cloud Build API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://cloudbuild.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public CloudBuild(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  CloudBuild(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
   *   {@code CloudBuild.Operations.List request = cloudbuild.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Starts asynchronous cancellation on a long-running operation.  The server makes a best effort to
     * cancel the operation, but success is not guaranteed.  If the server doesn't support this method,
     * it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or other
     * methods to check whether the cancellation succeeded or whether the operation completed despite
     * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
     * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Create a request for the method "operations.cancel".
     *
     * This request holds the parameters needed by the cloudbuild server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be cancelled.
     * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelOperationRequest}
     * @return the request
     */
    public Cancel cancel(java.lang.String name, com.google.api.services.cloudbuild.v1.model.CancelOperationRequest content) throws java.io.IOException {
      Cancel result = new Cancel(name, content);
      initialize(result);
      return result;
    }

    public class Cancel extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:cancel";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.+$");

      /**
       * Starts asynchronous cancellation on a long-running operation.  The server makes a best effort
       * to cancel the operation, but success is not guaranteed.  If the server doesn't support this
       * method, it returns `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation or
       * other methods to check whether the cancellation succeeded or whether the operation completed
       * despite cancellation. On successful cancellation, the operation is not deleted; instead, it
       * becomes an operation with an Operation.error value with a google.rpc.Status.code of 1,
       * corresponding to `Code.CANCELLED`.
       *
       * Create a request for the method "operations.cancel".
       *
       * This request holds the parameters needed by the the cloudbuild server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be cancelled.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelOperationRequest}
       * @since 1.13
       */
      protected Cancel(java.lang.String name, com.google.api.services.cloudbuild.v1.model.CancelOperationRequest content) {
        super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.+$");
        }
      }

      @Override
      public Cancel set$Xgafv(java.lang.String $Xgafv) {
        return (Cancel) super.set$Xgafv($Xgafv);
      }

      @Override
      public Cancel setAccessToken(java.lang.String accessToken) {
        return (Cancel) super.setAccessToken(accessToken);
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setCallback(java.lang.String callback) {
        return (Cancel) super.setCallback(callback);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUploadType(java.lang.String uploadType) {
        return (Cancel) super.setUploadType(uploadType);
      }

      @Override
      public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
        return (Cancel) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be cancelled. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be cancelled.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be cancelled. */
      public Cancel setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Gets the latest state of a long-running operation.  Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the cloudbuild server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.+$");

      /**
       * Gets the latest state of a long-running operation.  Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the cloudbuild server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists operations that match the specified filter in the request. If the server doesn't support
     * this method, it returns `UNIMPLEMENTED`.
     *
     * NOTE: the `name` binding allows API services to override the binding to use different resource
     * name schemes, such as `users/operations`. To override the binding, API services can add a binding
     * such as `"/v1/{name=users}/operations"` to their service configuration. For backwards
     * compatibility, the default name includes the operations collection id, however overriding users
     * must ensure the name binding is the parent resource, without the operations collection id.
     *
     * Create a request for the method "operations.list".
     *
     * This request holds the parameters needed by the cloudbuild server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation's parent resource.
     * @return the request
     */
    public List list(java.lang.String name) throws java.io.IOException {
      List result = new List(name);
      initialize(result);
      return result;
    }

    public class List extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.ListOperationsResponse> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations$");

      /**
       * Lists operations that match the specified filter in the request. If the server doesn't support
       * this method, it returns `UNIMPLEMENTED`.
       *
       * NOTE: the `name` binding allows API services to override the binding to use different resource
       * name schemes, such as `users/operations`. To override the binding, API services can add a
       * binding such as `"/v1/{name=users}/operations"` to their service configuration. For backwards
       * compatibility, the default name includes the operations collection id, however overriding users
       * must ensure the name binding is the parent resource, without the operations collection id.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the the cloudbuild server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation's parent resource.
       * @since 1.13
       */
      protected List(java.lang.String name) {
        super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.ListOperationsResponse.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation's parent resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation's parent resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation's parent resource. */
      public List setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
        this.name = name;
        return this;
      }

      /** The standard list filter. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** The standard list filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** The standard list filter. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The standard list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The standard list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The standard list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The standard list page size. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The standard list page size.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The standard list page size. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
   *   {@code CloudBuild.Projects.List request = cloudbuild.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Builds collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
     *   {@code CloudBuild.Builds.List request = cloudbuild.builds().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Builds builds() {
      return new Builds();
    }

    /**
     * The "builds" collection of methods.
     */
    public class Builds {

      /**
       * Cancels a build in progress.
       *
       * Create a request for the method "builds.cancel".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param id ID of the build.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelBuildRequest}
       * @return the request
       */
      public Cancel cancel(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.CancelBuildRequest content) throws java.io.IOException {
        Cancel result = new Cancel(projectId, id, content);
        initialize(result);
        return result;
      }

      public class Cancel extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Build> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:cancel";

        /**
         * Cancels a build in progress.
         *
         * Create a request for the method "builds.cancel".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         * <p> {@link
         * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param id ID of the build.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelBuildRequest}
         * @since 1.13
         */
        protected Cancel(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.CancelBuildRequest content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Build.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Cancel set$Xgafv(java.lang.String $Xgafv) {
          return (Cancel) super.set$Xgafv($Xgafv);
        }

        @Override
        public Cancel setAccessToken(java.lang.String accessToken) {
          return (Cancel) super.setAccessToken(accessToken);
        }

        @Override
        public Cancel setAlt(java.lang.String alt) {
          return (Cancel) super.setAlt(alt);
        }

        @Override
        public Cancel setCallback(java.lang.String callback) {
          return (Cancel) super.setCallback(callback);
        }

        @Override
        public Cancel setFields(java.lang.String fields) {
          return (Cancel) super.setFields(fields);
        }

        @Override
        public Cancel setKey(java.lang.String key) {
          return (Cancel) super.setKey(key);
        }

        @Override
        public Cancel setOauthToken(java.lang.String oauthToken) {
          return (Cancel) super.setOauthToken(oauthToken);
        }

        @Override
        public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Cancel) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Cancel setQuotaUser(java.lang.String quotaUser) {
          return (Cancel) super.setQuotaUser(quotaUser);
        }

        @Override
        public Cancel setUploadType(java.lang.String uploadType) {
          return (Cancel) super.setUploadType(uploadType);
        }

        @Override
        public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
          return (Cancel) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Cancel setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the build. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** ID of the build.
         */
        public java.lang.String getId() {
          return id;
        }

        /** ID of the build. */
        public Cancel setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Cancel set(String parameterName, Object value) {
          return (Cancel) super.set(parameterName, value);
        }
      }
      /**
       * Starts a build with the specified configuration.
       *
       * This method returns a long-running `Operation`, which includes the build ID. Pass the build ID to
       * `GetBuild` to determine the build status (such as `SUCCESS` or `FAILURE`).
       *
       * Create a request for the method "builds.create".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.Build}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.Build content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds";

        /**
         * Starts a build with the specified configuration.
         *
         * This method returns a long-running `Operation`, which includes the build ID. Pass the build ID
         * to `GetBuild` to determine the build status (such as `SUCCESS` or `FAILURE`).
         *
         * Create a request for the method "builds.create".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.Build}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.Build content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Operation.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Create setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Returns information about a previously requested build.
       *
       * The `Build` that is returned includes its status (such as `SUCCESS`, `FAILURE`, or `WORKING`),
       * and timing information.
       *
       * Create a request for the method "builds.get".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param id ID of the build.
       * @return the request
       */
      public Get get(java.lang.String projectId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(projectId, id);
        initialize(result);
        return result;
      }

      public class Get extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Build> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}";

        /**
         * Returns information about a previously requested build.
         *
         * The `Build` that is returned includes its status (such as `SUCCESS`, `FAILURE`, or `WORKING`),
         * and timing information.
         *
         * Create a request for the method "builds.get".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param id ID of the build.
         * @since 1.13
         */
        protected Get(java.lang.String projectId, java.lang.String id) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.Build.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the build. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** ID of the build.
         */
        public java.lang.String getId() {
          return id;
        }

        /** ID of the build. */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists previously requested builds.
       *
       * Previously requested builds may still be in-progress, or may have finished successfully or
       * unsuccessfully.
       *
       * Create a request for the method "builds.list".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.ListBuildsResponse> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds";

        /**
         * Lists previously requested builds.
         *
         * Previously requested builds may still be in-progress, or may have finished successfully or
         * unsuccessfully.
         *
         * Create a request for the method "builds.list".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.ListBuildsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public List setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Token to provide to skip to a particular spot in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Token to provide to skip to a particular spot in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Token to provide to skip to a particular spot in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Number of results to return in the list. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Number of results to return in the list.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Number of results to return in the list. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** The raw filter text to constrain the results. */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** The raw filter text to constrain the results.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /** The raw filter text to constrain the results. */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Creates a new build based on the specified build.
       *
       * This method creates a new build using the original build request, which may or may not result in
       * an identical build.
       *
       * For triggered builds:
       *
       * * Triggered builds resolve to a precise revision; therefore a retry of a triggered build will
       * result in a build that uses the same revision.
       *
       * For non-triggered builds that specify `RepoSource`:
       *
       * * If the original build built from the tip of a branch, the retried build will build from the tip
       * of that branch, which may not be the same revision as the original build. * If the original build
       * specified a commit sha or revision ID, the retried build will use the identical source.
       *
       * For builds that specify `StorageSource`:
       *
       * * If the original build pulled source from Google Cloud Storage without specifying the generation
       * of the object, the new build will use the current object, which may be different from the
       * original build source. * If the original build pulled source from Cloud Storage and specified the
       * generation of the object, the new build will attempt to use the same object, which may or may not
       * be available depending on the bucket's lifecycle management settings.
       *
       * Create a request for the method "builds.retry".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Retry#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param id Build ID of the original build.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.RetryBuildRequest}
       * @return the request
       */
      public Retry retry(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.RetryBuildRequest content) throws java.io.IOException {
        Retry result = new Retry(projectId, id, content);
        initialize(result);
        return result;
      }

      public class Retry extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:retry";

        /**
         * Creates a new build based on the specified build.
         *
         * This method creates a new build using the original build request, which may or may not result
         * in an identical build.
         *
         * For triggered builds:
         *
         * * Triggered builds resolve to a precise revision; therefore a retry of a triggered build will
         * result in a build that uses the same revision.
         *
         * For non-triggered builds that specify `RepoSource`:
         *
         * * If the original build built from the tip of a branch, the retried build will build from the
         * tip of that branch, which may not be the same revision as the original build. * If the original
         * build specified a commit sha or revision ID, the retried build will use the identical source.
         *
         * For builds that specify `StorageSource`:
         *
         * * If the original build pulled source from Google Cloud Storage without specifying the
         * generation of the object, the new build will use the current object, which may be different
         * from the original build source. * If the original build pulled source from Cloud Storage and
         * specified the generation of the object, the new build will attempt to use the same object,
         * which may or may not be available depending on the bucket's lifecycle management settings.
         *
         * Create a request for the method "builds.retry".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Retry#execute()} method to invoke the remote operation.
         * <p> {@link
         * Retry#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param id Build ID of the original build.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.RetryBuildRequest}
         * @since 1.13
         */
        protected Retry(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.RetryBuildRequest content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Operation.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Retry set$Xgafv(java.lang.String $Xgafv) {
          return (Retry) super.set$Xgafv($Xgafv);
        }

        @Override
        public Retry setAccessToken(java.lang.String accessToken) {
          return (Retry) super.setAccessToken(accessToken);
        }

        @Override
        public Retry setAlt(java.lang.String alt) {
          return (Retry) super.setAlt(alt);
        }

        @Override
        public Retry setCallback(java.lang.String callback) {
          return (Retry) super.setCallback(callback);
        }

        @Override
        public Retry setFields(java.lang.String fields) {
          return (Retry) super.setFields(fields);
        }

        @Override
        public Retry setKey(java.lang.String key) {
          return (Retry) super.setKey(key);
        }

        @Override
        public Retry setOauthToken(java.lang.String oauthToken) {
          return (Retry) super.setOauthToken(oauthToken);
        }

        @Override
        public Retry setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Retry) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Retry setQuotaUser(java.lang.String quotaUser) {
          return (Retry) super.setQuotaUser(quotaUser);
        }

        @Override
        public Retry setUploadType(java.lang.String uploadType) {
          return (Retry) super.setUploadType(uploadType);
        }

        @Override
        public Retry setUploadProtocol(java.lang.String uploadProtocol) {
          return (Retry) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Retry setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Build ID of the original build. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** Build ID of the original build.
         */
        public java.lang.String getId() {
          return id;
        }

        /** Build ID of the original build. */
        public Retry setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Retry set(String parameterName, Object value) {
          return (Retry) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Triggers collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
     *   {@code CloudBuild.Triggers.List request = cloudbuild.triggers().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Triggers triggers() {
      return new Triggers();
    }

    /**
     * The "triggers" collection of methods.
     */
    public class Triggers {

      /**
       * Creates a new `BuildTrigger`.
       *
       * This API is experimental.
       *
       * Create a request for the method "triggers.create".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project for which to configure automatic builds.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.BuildTrigger}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.BuildTrigger content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.BuildTrigger> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers";

        /**
         * Creates a new `BuildTrigger`.
         *
         * This API is experimental.
         *
         * Create a request for the method "triggers.create".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project for which to configure automatic builds.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.BuildTrigger}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.BuildTrigger content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.BuildTrigger.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project for which to configure automatic builds. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project for which to configure automatic builds.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project for which to configure automatic builds. */
        public Create setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a `BuildTrigger` by its project ID and trigger ID.
       *
       * This API is experimental.
       *
       * Create a request for the method "triggers.delete".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project that owns the trigger.
       * @param triggerId ID of the `BuildTrigger` to delete.
       * @return the request
       */
      public Delete delete(java.lang.String projectId, java.lang.String triggerId) throws java.io.IOException {
        Delete result = new Delete(projectId, triggerId);
        initialize(result);
        return result;
      }

      public class Delete extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Empty> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";

        /**
         * Deletes a `BuildTrigger` by its project ID and trigger ID.
         *
         * This API is experimental.
         *
         * Create a request for the method "triggers.delete".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project that owns the trigger.
         * @param triggerId ID of the `BuildTrigger` to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String projectId, java.lang.String triggerId) {
          super(CloudBuild.this, "DELETE", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.Empty.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.triggerId = com.google.api.client.util.Preconditions.checkNotNull(triggerId, "Required parameter triggerId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project that owns the trigger. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project that owns the trigger.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project that owns the trigger. */
        public Delete setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the `BuildTrigger` to delete. */
        @com.google.api.client.util.Key
        private java.lang.String triggerId;

        /** ID of the `BuildTrigger` to delete.
         */
        public java.lang.String getTriggerId() {
          return triggerId;
        }

        /** ID of the `BuildTrigger` to delete. */
        public Delete setTriggerId(java.lang.String triggerId) {
          this.triggerId = triggerId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns information about a `BuildTrigger`.
       *
       * This API is experimental.
       *
       * Create a request for the method "triggers.get".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project that owns the trigger.
       * @param triggerId ID of the `BuildTrigger` to get.
       * @return the request
       */
      public Get get(java.lang.String projectId, java.lang.String triggerId) throws java.io.IOException {
        Get result = new Get(projectId, triggerId);
        initialize(result);
        return result;
      }

      public class Get extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.BuildTrigger> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";

        /**
         * Returns information about a `BuildTrigger`.
         *
         * This API is experimental.
         *
         * Create a request for the method "triggers.get".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project that owns the trigger.
         * @param triggerId ID of the `BuildTrigger` to get.
         * @since 1.13
         */
        protected Get(java.lang.String projectId, java.lang.String triggerId) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.BuildTrigger.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.triggerId = com.google.api.client.util.Preconditions.checkNotNull(triggerId, "Required parameter triggerId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project that owns the trigger. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project that owns the trigger.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project that owns the trigger. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the `BuildTrigger` to get. */
        @com.google.api.client.util.Key
        private java.lang.String triggerId;

        /** ID of the `BuildTrigger` to get.
         */
        public java.lang.String getTriggerId() {
          return triggerId;
        }

        /** ID of the `BuildTrigger` to get. */
        public Get setTriggerId(java.lang.String triggerId) {
          this.triggerId = triggerId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists existing `BuildTrigger`s.
       *
       * This API is experimental.
       *
       * Create a request for the method "triggers.list".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project for which to list BuildTriggers.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.ListBuildTriggersResponse> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers";

        /**
         * Lists existing `BuildTrigger`s.
         *
         * This API is experimental.
         *
         * Create a request for the method "triggers.list".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project for which to list BuildTriggers.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.ListBuildTriggersResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project for which to list BuildTriggers. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project for which to list BuildTriggers.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project for which to list BuildTriggers. */
        public List setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a `BuildTrigger` by its project ID and trigger ID.
       *
       * This API is experimental.
       *
       * Create a request for the method "triggers.patch".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project that owns the trigger.
       * @param triggerId ID of the `BuildTrigger` to update.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.BuildTrigger}
       * @return the request
       */
      public Patch patch(java.lang.String projectId, java.lang.String triggerId, com.google.api.services.cloudbuild.v1.model.BuildTrigger content) throws java.io.IOException {
        Patch result = new Patch(projectId, triggerId, content);
        initialize(result);
        return result;
      }

      public class Patch extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.BuildTrigger> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";

        /**
         * Updates a `BuildTrigger` by its project ID and trigger ID.
         *
         * This API is experimental.
         *
         * Create a request for the method "triggers.patch".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project that owns the trigger.
         * @param triggerId ID of the `BuildTrigger` to update.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.BuildTrigger}
         * @since 1.13
         */
        protected Patch(java.lang.String projectId, java.lang.String triggerId, com.google.api.services.cloudbuild.v1.model.BuildTrigger content) {
          super(CloudBuild.this, "PATCH", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.BuildTrigger.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.triggerId = com.google.api.client.util.Preconditions.checkNotNull(triggerId, "Required parameter triggerId must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project that owns the trigger. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project that owns the trigger.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project that owns the trigger. */
        public Patch setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the `BuildTrigger` to update. */
        @com.google.api.client.util.Key
        private java.lang.String triggerId;

        /** ID of the `BuildTrigger` to update.
         */
        public java.lang.String getTriggerId() {
          return triggerId;
        }

        /** ID of the `BuildTrigger` to update. */
        public Patch setTriggerId(java.lang.String triggerId) {
          this.triggerId = triggerId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Runs a `BuildTrigger` at a particular source revision.
       *
       * Create a request for the method "triggers.run".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Run#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param triggerId ID of the trigger.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.RepoSource}
       * @return the request
       */
      public Run run(java.lang.String projectId, java.lang.String triggerId, com.google.api.services.cloudbuild.v1.model.RepoSource content) throws java.io.IOException {
        Run result = new Run(projectId, triggerId, content);
        initialize(result);
        return result;
      }

      public class Run extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

        private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}:run";

        /**
         * Runs a `BuildTrigger` at a particular source revision.
         *
         * Create a request for the method "triggers.run".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Run#execute()} method to invoke the remote operation. <p>
         * {@link Run#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param triggerId ID of the trigger.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.RepoSource}
         * @since 1.13
         */
        protected Run(java.lang.String projectId, java.lang.String triggerId, com.google.api.services.cloudbuild.v1.model.RepoSource content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Operation.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.triggerId = com.google.api.client.util.Preconditions.checkNotNull(triggerId, "Required parameter triggerId must be specified.");
        }

        @Override
        public Run set$Xgafv(java.lang.String $Xgafv) {
          return (Run) super.set$Xgafv($Xgafv);
        }

        @Override
        public Run setAccessToken(java.lang.String accessToken) {
          return (Run) super.setAccessToken(accessToken);
        }

        @Override
        public Run setAlt(java.lang.String alt) {
          return (Run) super.setAlt(alt);
        }

        @Override
        public Run setCallback(java.lang.String callback) {
          return (Run) super.setCallback(callback);
        }

        @Override
        public Run setFields(java.lang.String fields) {
          return (Run) super.setFields(fields);
        }

        @Override
        public Run setKey(java.lang.String key) {
          return (Run) super.setKey(key);
        }

        @Override
        public Run setOauthToken(java.lang.String oauthToken) {
          return (Run) super.setOauthToken(oauthToken);
        }

        @Override
        public Run setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Run) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Run setQuotaUser(java.lang.String quotaUser) {
          return (Run) super.setQuotaUser(quotaUser);
        }

        @Override
        public Run setUploadType(java.lang.String uploadType) {
          return (Run) super.setUploadType(uploadType);
        }

        @Override
        public Run setUploadProtocol(java.lang.String uploadProtocol) {
          return (Run) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Run setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the trigger. */
        @com.google.api.client.util.Key
        private java.lang.String triggerId;

        /** ID of the trigger.
         */
        public java.lang.String getTriggerId() {
          return triggerId;
        }

        /** ID of the trigger. */
        public Run setTriggerId(java.lang.String triggerId) {
          this.triggerId = triggerId;
          return this;
        }

        @Override
        public Run set(String parameterName, Object value) {
          return (Run) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link CloudBuild}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link CloudBuild}. */
    @Override
    public CloudBuild build() {
      return new CloudBuild(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CloudBuildRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCloudBuildRequestInitializer(
        CloudBuildRequestInitializer cloudbuildRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(cloudbuildRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
