/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-07 at 05:48:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1.model;

/**
 * Configuration for an automated build in response to source repository changes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Build API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BuildTrigger extends com.google.api.client.json.GenericJson {

  /**
   * Contents of the build template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Build build;

  /**
   * Output only. Time when the trigger was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Human-readable description of this trigger.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * If true, the trigger will never result in a build.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Path, from the source root, to a file whose contents is used for the template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filename;

  /**
   * GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a
   * GitHub event is received.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GitHubEventsConfig github;

  /**
   * Output only. Unique identifier of the trigger.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * ignored_files and included_files are file glob matches using
   * http://godoc/pkg/path/filepath#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are not used to determine whether
   * or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match any of the ignored_file
   * globs. If the change has no files that are outside of the ignored_files globs, then we do not
   * trigger a build.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ignoredFiles;

  /**
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * empty, then as far as this filter is concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * not empty, then we make sure that at least one of those files matches a included_files glob. If
   * not, then we do not trigger a build.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> includedFiles;

  /**
   * Substitutions data for Build resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> substitutions;

  /**
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular expressions. Any branch or
   * tag change that matches that regular expression will trigger a build.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepoSource triggerTemplate;

  /**
   * Contents of the build template.
   * @return value or {@code null} for none
   */
  public Build getBuild() {
    return build;
  }

  /**
   * Contents of the build template.
   * @param build build or {@code null} for none
   */
  public BuildTrigger setBuild(Build build) {
    this.build = build;
    return this;
  }

  /**
   * Output only. Time when the trigger was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when the trigger was created.
   * @param createTime createTime or {@code null} for none
   */
  public BuildTrigger setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Human-readable description of this trigger.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Human-readable description of this trigger.
   * @param description description or {@code null} for none
   */
  public BuildTrigger setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * If true, the trigger will never result in a build.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * If true, the trigger will never result in a build.
   * @param disabled disabled or {@code null} for none
   */
  public BuildTrigger setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Path, from the source root, to a file whose contents is used for the template.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilename() {
    return filename;
  }

  /**
   * Path, from the source root, to a file whose contents is used for the template.
   * @param filename filename or {@code null} for none
   */
  public BuildTrigger setFilename(java.lang.String filename) {
    this.filename = filename;
    return this;
  }

  /**
   * GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a
   * GitHub event is received.
   * @return value or {@code null} for none
   */
  public GitHubEventsConfig getGithub() {
    return github;
  }

  /**
   * GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a
   * GitHub event is received.
   * @param github github or {@code null} for none
   */
  public BuildTrigger setGithub(GitHubEventsConfig github) {
    this.github = github;
    return this;
  }

  /**
   * Output only. Unique identifier of the trigger.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. Unique identifier of the trigger.
   * @param id id or {@code null} for none
   */
  public BuildTrigger setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * ignored_files and included_files are file glob matches using
   * http://godoc/pkg/path/filepath#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are not used to determine whether
   * or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match any of the ignored_file
   * globs. If the change has no files that are outside of the ignored_files globs, then we do not
   * trigger a build.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIgnoredFiles() {
    return ignoredFiles;
  }

  /**
   * ignored_files and included_files are file glob matches using
   * http://godoc/pkg/path/filepath#Match extended with support for "**".
   *
   * If ignored_files and changed files are both empty, then they are not used to determine whether
   * or not to trigger a build.
   *
   * If ignored_files is not empty, then we ignore any files that match any of the ignored_file
   * globs. If the change has no files that are outside of the ignored_files globs, then we do not
   * trigger a build.
   * @param ignoredFiles ignoredFiles or {@code null} for none
   */
  public BuildTrigger setIgnoredFiles(java.util.List<java.lang.String> ignoredFiles) {
    this.ignoredFiles = ignoredFiles;
    return this;
  }

  /**
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * empty, then as far as this filter is concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * not empty, then we make sure that at least one of those files matches a included_files glob. If
   * not, then we do not trigger a build.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIncludedFiles() {
    return includedFiles;
  }

  /**
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * empty, then as far as this filter is concerned, we should trigger the build.
   *
   * If any of the files altered in the commit pass the ignored_files filter and included_files is
   * not empty, then we make sure that at least one of those files matches a included_files glob. If
   * not, then we do not trigger a build.
   * @param includedFiles includedFiles or {@code null} for none
   */
  public BuildTrigger setIncludedFiles(java.util.List<java.lang.String> includedFiles) {
    this.includedFiles = includedFiles;
    return this;
  }

  /**
   * Substitutions data for Build resource.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getSubstitutions() {
    return substitutions;
  }

  /**
   * Substitutions data for Build resource.
   * @param substitutions substitutions or {@code null} for none
   */
  public BuildTrigger setSubstitutions(java.util.Map<String, java.lang.String> substitutions) {
    this.substitutions = substitutions;
    return this;
  }

  /**
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular expressions. Any branch or
   * tag change that matches that regular expression will trigger a build.
   * @return value or {@code null} for none
   */
  public RepoSource getTriggerTemplate() {
    return triggerTemplate;
  }

  /**
   * Template describing the types of source changes to trigger a build.
   *
   * Branch and tag names in trigger templates are interpreted as regular expressions. Any branch or
   * tag change that matches that regular expression will trigger a build.
   * @param triggerTemplate triggerTemplate or {@code null} for none
   */
  public BuildTrigger setTriggerTemplate(RepoSource triggerTemplate) {
    this.triggerTemplate = triggerTemplate;
    return this;
  }

  @Override
  public BuildTrigger set(String fieldName, Object value) {
    return (BuildTrigger) super.set(fieldName, value);
  }

  @Override
  public BuildTrigger clone() {
    return (BuildTrigger) super.clone();
  }

}
