/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-07 at 05:48:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1.model;

/**
 * Volume describes a Docker container volume which is mounted into build steps in order to persist
 * files across build step execution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Build API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Volume extends com.google.api.client.json.GenericJson {

  /**
   * Name of the volume to mount.
   *
   * Volume names must be unique per build step and must be valid names for Docker volumes. Each
   * named volume must be used by at least two build steps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Path at which to mount the volume.
   *
   * Paths must be absolute and cannot conflict with other volume paths on the same build step or
   * with certain reserved volume paths.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Name of the volume to mount.
   *
   * Volume names must be unique per build step and must be valid names for Docker volumes. Each
   * named volume must be used by at least two build steps.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the volume to mount.
   *
   * Volume names must be unique per build step and must be valid names for Docker volumes. Each
   * named volume must be used by at least two build steps.
   * @param name name or {@code null} for none
   */
  public Volume setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Path at which to mount the volume.
   *
   * Paths must be absolute and cannot conflict with other volume paths on the same build step or
   * with certain reserved volume paths.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path at which to mount the volume.
   *
   * Paths must be absolute and cannot conflict with other volume paths on the same build step or
   * with certain reserved volume paths.
   * @param path path or {@code null} for none
   */
  public Volume setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public Volume set(String fieldName, Object value) {
    return (Volume) super.set(fieldName, value);
  }

  @Override
  public Volume clone() {
    return (Volume) super.clone();
  }

}
