/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudbuild.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudbuild.v1.CloudBuildRequest;
import com.google.api.services.cloudbuild.v1.CloudBuildRequestInitializer;
import com.google.api.services.cloudbuild.v1.model.Build;
import com.google.api.services.cloudbuild.v1.model.BuildTrigger;
import com.google.api.services.cloudbuild.v1.model.CancelBuildRequest;
import com.google.api.services.cloudbuild.v1.model.CancelOperationRequest;
import com.google.api.services.cloudbuild.v1.model.Empty;
import com.google.api.services.cloudbuild.v1.model.ListBuildTriggersResponse;
import com.google.api.services.cloudbuild.v1.model.ListBuildsResponse;
import com.google.api.services.cloudbuild.v1.model.ListOperationsResponse;
import com.google.api.services.cloudbuild.v1.model.Operation;
import com.google.api.services.cloudbuild.v1.model.RepoSource;
import com.google.api.services.cloudbuild.v1.model.RetryBuildRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudBuild
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudbuild.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudbuild.googleapis.com/";

    public CloudBuild(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    CloudBuild(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Build API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://cloudbuild.googleapis.com/", CloudBuild.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudBuild.DEFAULT_BATCH_PATH);
        }

        public CloudBuild build() {
            return new CloudBuild(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCloudBuildRequestInitializer(CloudBuildRequestInitializer cloudBuildRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudBuildRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Builds builds() {
            return new Builds();
        }

        public Triggers triggers() {
            return new Triggers();
        }

        public class Triggers {
            public Create create(String string, BuildTrigger buildTrigger) throws IOException {
                Create create = new Create(string, buildTrigger);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, BuildTrigger buildTrigger) throws IOException {
                Patch patch = new Patch(string, string2, buildTrigger);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Run run(String string, String string2, RepoSource repoSource) throws IOException {
                Run run = new Run(string, string2, repoSource);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)run);
                return run;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Run
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}:run";
                @Key
                private String projectId;
                @Key
                private String triggerId;

                protected Run(String string, String string2, RepoSource repoSource) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)repoSource, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter triggerId must be specified.");
                }

                public Run set$Xgafv(String string) {
                    return (Run)super.set$Xgafv(string);
                }

                public Run setAccessToken(String string) {
                    return (Run)super.setAccessToken(string);
                }

                public Run setAlt(String string) {
                    return (Run)super.setAlt(string);
                }

                public Run setCallback(String string) {
                    return (Run)super.setCallback(string);
                }

                public Run setFields(String string) {
                    return (Run)super.setFields(string);
                }

                public Run setKey(String string) {
                    return (Run)super.setKey(string);
                }

                public Run setOauthToken(String string) {
                    return (Run)super.setOauthToken(string);
                }

                public Run setPrettyPrint(Boolean bl) {
                    return (Run)super.setPrettyPrint(bl);
                }

                public Run setQuotaUser(String string) {
                    return (Run)super.setQuotaUser(string);
                }

                public Run setUploadType(String string) {
                    return (Run)super.setUploadType(string);
                }

                public Run setUploadProtocol(String string) {
                    return (Run)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Run setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Run setTriggerId(String string) {
                    this.triggerId = string;
                    return this;
                }

                @Override
                public Run set(String string, Object object) {
                    return (Run)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;

                protected Patch(String string, String string2, BuildTrigger buildTrigger) {
                    super(CloudBuild.this, "PATCH", REST_PATH, (Object)buildTrigger, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter triggerId must be specified.");
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Patch setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Patch setTriggerId(String string) {
                    this.triggerId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends CloudBuildRequest<ListBuildTriggersResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers";
                @Key
                private String projectId;

                protected List(String string) {
                    super(CloudBuild.this, "GET", REST_PATH, null, ListBuildTriggersResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;

                protected Get(String string, String string2) {
                    super(CloudBuild.this, "GET", REST_PATH, null, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter triggerId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Get setTriggerId(String string) {
                    this.triggerId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends CloudBuildRequest<Empty> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers/{triggerId}";
                @Key
                private String projectId;
                @Key
                private String triggerId;

                protected Delete(String string, String string2) {
                    super(CloudBuild.this, "DELETE", REST_PATH, null, Empty.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.triggerId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter triggerId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Delete setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getTriggerId() {
                    return this.triggerId;
                }

                public Delete setTriggerId(String string) {
                    this.triggerId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends CloudBuildRequest<BuildTrigger> {
                private static final String REST_PATH = "v1/projects/{projectId}/triggers";
                @Key
                private String projectId;

                protected Create(String string, BuildTrigger buildTrigger) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)buildTrigger, BuildTrigger.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Builds {
            public Cancel cancel(String string, String string2, CancelBuildRequest cancelBuildRequest) throws IOException {
                Cancel cancel = new Cancel(string, string2, cancelBuildRequest);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                return cancel;
            }

            public Create create(String string, Build build) throws IOException {
                Create create = new Create(string, build);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Retry retry(String string, String string2, RetryBuildRequest retryBuildRequest) throws IOException {
                Retry retry = new Retry(string, string2, retryBuildRequest);
                CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)retry);
                return retry;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Retry
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:retry";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Retry(String string, String string2, RetryBuildRequest retryBuildRequest) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)retryBuildRequest, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Retry set$Xgafv(String string) {
                    return (Retry)super.set$Xgafv(string);
                }

                public Retry setAccessToken(String string) {
                    return (Retry)super.setAccessToken(string);
                }

                public Retry setAlt(String string) {
                    return (Retry)super.setAlt(string);
                }

                public Retry setCallback(String string) {
                    return (Retry)super.setCallback(string);
                }

                public Retry setFields(String string) {
                    return (Retry)super.setFields(string);
                }

                public Retry setKey(String string) {
                    return (Retry)super.setKey(string);
                }

                public Retry setOauthToken(String string) {
                    return (Retry)super.setOauthToken(string);
                }

                public Retry setPrettyPrint(Boolean bl) {
                    return (Retry)super.setPrettyPrint(bl);
                }

                public Retry setQuotaUser(String string) {
                    return (Retry)super.setQuotaUser(string);
                }

                public Retry setUploadType(String string) {
                    return (Retry)super.setUploadType(string);
                }

                public Retry setUploadProtocol(String string) {
                    return (Retry)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Retry setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Retry setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Retry set(String string, Object object) {
                    return (Retry)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends CloudBuildRequest<ListBuildsResponse> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds";
                @Key
                private String projectId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String filter;

                protected List(String string) {
                    super(CloudBuild.this, "GET", REST_PATH, null, ListBuildsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends CloudBuildRequest<Build> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(CloudBuild.this, "GET", REST_PATH, null, Build.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends CloudBuildRequest<Operation> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds";
                @Key
                private String projectId;

                protected Create(String string, Build build) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)build, Operation.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Cancel
            extends CloudBuildRequest<Build> {
                private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:cancel";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Cancel(String string, String string2, CancelBuildRequest cancelBuildRequest) {
                    super(CloudBuild.this, "POST", REST_PATH, (Object)cancelBuildRequest, Build.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Cancel set$Xgafv(String string) {
                    return (Cancel)super.set$Xgafv(string);
                }

                public Cancel setAccessToken(String string) {
                    return (Cancel)super.setAccessToken(string);
                }

                public Cancel setAlt(String string) {
                    return (Cancel)super.setAlt(string);
                }

                public Cancel setCallback(String string) {
                    return (Cancel)super.setCallback(string);
                }

                public Cancel setFields(String string) {
                    return (Cancel)super.setFields(string);
                }

                public Cancel setKey(String string) {
                    return (Cancel)super.setKey(string);
                }

                public Cancel setOauthToken(String string) {
                    return (Cancel)super.setOauthToken(string);
                }

                public Cancel setPrettyPrint(Boolean bl) {
                    return (Cancel)super.setPrettyPrint(bl);
                }

                public Cancel setQuotaUser(String string) {
                    return (Cancel)super.setQuotaUser(string);
                }

                public Cancel setUploadType(String string) {
                    return (Cancel)super.setUploadType(string);
                }

                public Cancel setUploadProtocol(String string) {
                    return (Cancel)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Cancel setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Cancel setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Cancel set(String string, Object object) {
                    return (Cancel)super.set(string, object);
                }
            }
        }
    }

    public class Operations {
        public Cancel cancel(String string, CancelOperationRequest cancelOperationRequest) throws IOException {
            Cancel cancel = new Cancel(string, cancelOperationRequest);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            CloudBuild.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudBuildRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List(String string) {
                super(CloudBuild.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^operations$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
                this.name = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudBuildRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(CloudBuild.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends CloudBuildRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String string, CancelOperationRequest cancelOperationRequest) {
                super(CloudBuild.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public Cancel set$Xgafv(String string) {
                return (Cancel)super.set$Xgafv(string);
            }

            public Cancel setAccessToken(String string) {
                return (Cancel)super.setAccessToken(string);
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setCallback(String string) {
                return (Cancel)super.setCallback(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUploadType(String string) {
                return (Cancel)super.setUploadType(string);
            }

            public Cancel setUploadProtocol(String string) {
                return (Cancel)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String string) {
                if (!CloudBuild.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }
}

