/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.clouddebugger.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.clouddebugger.v2.CloudDebuggerRequest;
import com.google.api.services.clouddebugger.v2.CloudDebuggerRequestInitializer;
import com.google.api.services.clouddebugger.v2.model.Breakpoint;
import com.google.api.services.clouddebugger.v2.model.Empty;
import com.google.api.services.clouddebugger.v2.model.GetBreakpointResponse;
import com.google.api.services.clouddebugger.v2.model.ListActiveBreakpointsResponse;
import com.google.api.services.clouddebugger.v2.model.ListBreakpointsResponse;
import com.google.api.services.clouddebugger.v2.model.ListDebuggeesResponse;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeRequest;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeResponse;
import com.google.api.services.clouddebugger.v2.model.SetBreakpointResponse;
import com.google.api.services.clouddebugger.v2.model.UpdateActiveBreakpointRequest;
import com.google.api.services.clouddebugger.v2.model.UpdateActiveBreakpointResponse;
import java.io.IOException;

public class CloudDebugger
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://clouddebugger.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://clouddebugger.googleapis.com/";

    public CloudDebugger(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudDebugger(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Controller controller() {
        return new Controller();
    }

    public Debugger debugger() {
        return new Debugger();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Cloud Debugger API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://clouddebugger.googleapis.com/", CloudDebugger.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudDebugger.DEFAULT_BATCH_PATH);
        }

        public CloudDebugger build() {
            return new CloudDebugger(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudDebuggerRequestInitializer(CloudDebuggerRequestInitializer clouddebuggerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)clouddebuggerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Debugger {
        public Debuggees debuggees() {
            return new Debuggees();
        }

        public class Debuggees {
            public List list() throws IOException {
                List result = new List();
                CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Breakpoints breakpoints() {
                return new Breakpoints();
            }

            public class Breakpoints {
                public Delete delete(String debuggeeId, String breakpointId) throws IOException {
                    Delete result = new Delete(debuggeeId, breakpointId);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String debuggeeId, String breakpointId) throws IOException {
                    Get result = new Get(debuggeeId, breakpointId);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String debuggeeId) throws IOException {
                    List result = new List(debuggeeId);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Set set(String debuggeeId, Breakpoint content) throws IOException {
                    Set result = new Set(debuggeeId, content);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Set
                extends CloudDebuggerRequest<SetBreakpointResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/set";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String clientVersion;

                    protected Set(String debuggeeId, Breakpoint content) {
                        super(CloudDebugger.this, "POST", REST_PATH, (Object)content, SetBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public Set set$Xgafv(String $Xgafv) {
                        return (Set)super.set$Xgafv($Xgafv);
                    }

                    public Set setAccessToken(String accessToken) {
                        return (Set)super.setAccessToken(accessToken);
                    }

                    public Set setAlt(String alt) {
                        return (Set)super.setAlt(alt);
                    }

                    public Set setCallback(String callback) {
                        return (Set)super.setCallback(callback);
                    }

                    public Set setFields(String fields) {
                        return (Set)super.setFields(fields);
                    }

                    public Set setKey(String key) {
                        return (Set)super.setKey(key);
                    }

                    public Set setOauthToken(String oauthToken) {
                        return (Set)super.setOauthToken(oauthToken);
                    }

                    public Set setPrettyPrint(Boolean prettyPrint) {
                        return (Set)super.setPrettyPrint(prettyPrint);
                    }

                    public Set setQuotaUser(String quotaUser) {
                        return (Set)super.setQuotaUser(quotaUser);
                    }

                    public Set setUploadType(String uploadType) {
                        return (Set)super.setUploadType(uploadType);
                    }

                    public Set setUploadProtocol(String uploadProtocol) {
                        return (Set)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Set setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Set setClientVersion(String clientVersion) {
                        this.clientVersion = clientVersion;
                        return this;
                    }

                    @Override
                    public Set set(String parameterName, Object value) {
                        return (Set)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudDebuggerRequest<ListBreakpointsResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints";
                    @Key
                    private String debuggeeId;
                    @Key(value="action.value")
                    private String actionValue;
                    @Key
                    private String clientVersion;
                    @Key
                    private Boolean includeAllUsers;
                    @Key
                    private Boolean includeInactive;
                    @Key
                    private Boolean stripResults;
                    @Key
                    private String waitToken;

                    protected List(String debuggeeId) {
                        super(CloudDebugger.this, "GET", REST_PATH, null, ListBreakpointsResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public List setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public String getActionValue() {
                        return this.actionValue;
                    }

                    public List setActionValue(String actionValue) {
                        this.actionValue = actionValue;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public List setClientVersion(String clientVersion) {
                        this.clientVersion = clientVersion;
                        return this;
                    }

                    public Boolean getIncludeAllUsers() {
                        return this.includeAllUsers;
                    }

                    public List setIncludeAllUsers(Boolean includeAllUsers) {
                        this.includeAllUsers = includeAllUsers;
                        return this;
                    }

                    public Boolean getIncludeInactive() {
                        return this.includeInactive;
                    }

                    public List setIncludeInactive(Boolean includeInactive) {
                        this.includeInactive = includeInactive;
                        return this;
                    }

                    public Boolean getStripResults() {
                        return this.stripResults;
                    }

                    public List setStripResults(Boolean stripResults) {
                        this.stripResults = stripResults;
                        return this;
                    }

                    public String getWaitToken() {
                        return this.waitToken;
                    }

                    public List setWaitToken(String waitToken) {
                        this.waitToken = waitToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudDebuggerRequest<GetBreakpointResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String breakpointId;
                    @Key
                    private String clientVersion;

                    protected Get(String debuggeeId, String breakpointId) {
                        super(CloudDebugger.this, "GET", REST_PATH, null, GetBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                        this.breakpointId = (String)Preconditions.checkNotNull((Object)breakpointId, (Object)"Required parameter breakpointId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Get setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public String getBreakpointId() {
                        return this.breakpointId;
                    }

                    public Get setBreakpointId(String breakpointId) {
                        this.breakpointId = breakpointId;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Get setClientVersion(String clientVersion) {
                        this.clientVersion = clientVersion;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudDebuggerRequest<Empty> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String breakpointId;
                    @Key
                    private String clientVersion;

                    protected Delete(String debuggeeId, String breakpointId) {
                        super(CloudDebugger.this, "DELETE", REST_PATH, null, Empty.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                        this.breakpointId = (String)Preconditions.checkNotNull((Object)breakpointId, (Object)"Required parameter breakpointId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Delete setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public String getBreakpointId() {
                        return this.breakpointId;
                    }

                    public Delete setBreakpointId(String breakpointId) {
                        this.breakpointId = breakpointId;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Delete setClientVersion(String clientVersion) {
                        this.clientVersion = clientVersion;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends CloudDebuggerRequest<ListDebuggeesResponse> {
                private static final String REST_PATH = "v2/debugger/debuggees";
                @Key
                private String clientVersion;
                @Key
                private Boolean includeInactive;
                @Key
                private String project;

                protected List() {
                    super(CloudDebugger.this, "GET", REST_PATH, null, ListDebuggeesResponse.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getClientVersion() {
                    return this.clientVersion;
                }

                public List setClientVersion(String clientVersion) {
                    this.clientVersion = clientVersion;
                    return this;
                }

                public Boolean getIncludeInactive() {
                    return this.includeInactive;
                }

                public List setIncludeInactive(Boolean includeInactive) {
                    this.includeInactive = includeInactive;
                    return this;
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String project) {
                    this.project = project;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }

    public class Controller {
        public Debuggees debuggees() {
            return new Debuggees();
        }

        public class Debuggees {
            public Register register(RegisterDebuggeeRequest content) throws IOException {
                Register result = new Register(content);
                CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Breakpoints breakpoints() {
                return new Breakpoints();
            }

            public class Breakpoints {
                public List list(String debuggeeId) throws IOException {
                    List result = new List(debuggeeId);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String debuggeeId, String id, UpdateActiveBreakpointRequest content) throws IOException {
                    Update result = new Update(debuggeeId, id, content);
                    CloudDebugger.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Update
                extends CloudDebuggerRequest<UpdateActiveBreakpointResponse> {
                    private static final String REST_PATH = "v2/controller/debuggees/{debuggeeId}/breakpoints/{id}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String id;

                    protected Update(String debuggeeId, String id, UpdateActiveBreakpointRequest content) {
                        super(CloudDebugger.this, "PUT", REST_PATH, (Object)content, UpdateActiveBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Update setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Update setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudDebuggerRequest<ListActiveBreakpointsResponse> {
                    private static final String REST_PATH = "v2/controller/debuggees/{debuggeeId}/breakpoints";
                    @Key
                    private String debuggeeId;
                    @Key
                    private Boolean successOnTimeout;
                    @Key
                    private String waitToken;

                    protected List(String debuggeeId) {
                        super(CloudDebugger.this, "GET", REST_PATH, null, ListActiveBreakpointsResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)debuggeeId, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public List setDebuggeeId(String debuggeeId) {
                        this.debuggeeId = debuggeeId;
                        return this;
                    }

                    public Boolean getSuccessOnTimeout() {
                        return this.successOnTimeout;
                    }

                    public List setSuccessOnTimeout(Boolean successOnTimeout) {
                        this.successOnTimeout = successOnTimeout;
                        return this;
                    }

                    public String getWaitToken() {
                        return this.waitToken;
                    }

                    public List setWaitToken(String waitToken) {
                        this.waitToken = waitToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Register
            extends CloudDebuggerRequest<RegisterDebuggeeResponse> {
                private static final String REST_PATH = "v2/controller/debuggees/register";

                protected Register(RegisterDebuggeeRequest content) {
                    super(CloudDebugger.this, "POST", REST_PATH, (Object)content, RegisterDebuggeeResponse.class);
                }

                public Register set$Xgafv(String $Xgafv) {
                    return (Register)super.set$Xgafv($Xgafv);
                }

                public Register setAccessToken(String accessToken) {
                    return (Register)super.setAccessToken(accessToken);
                }

                public Register setAlt(String alt) {
                    return (Register)super.setAlt(alt);
                }

                public Register setCallback(String callback) {
                    return (Register)super.setCallback(callback);
                }

                public Register setFields(String fields) {
                    return (Register)super.setFields(fields);
                }

                public Register setKey(String key) {
                    return (Register)super.setKey(key);
                }

                public Register setOauthToken(String oauthToken) {
                    return (Register)super.setOauthToken(oauthToken);
                }

                public Register setPrettyPrint(Boolean prettyPrint) {
                    return (Register)super.setPrettyPrint(prettyPrint);
                }

                public Register setQuotaUser(String quotaUser) {
                    return (Register)super.setQuotaUser(quotaUser);
                }

                public Register setUploadType(String uploadType) {
                    return (Register)super.setUploadType(uploadType);
                }

                public Register setUploadProtocol(String uploadProtocol) {
                    return (Register)super.setUploadProtocol(uploadProtocol);
                }

                @Override
                public Register set(String parameterName, Object value) {
                    return (Register)super.set(parameterName, value);
                }
            }
        }
    }
}

