/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * Request to update an active breakpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Debugger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateActiveBreakpointRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Updated breakpoint information. The field `id` must be set. The agent must echo all
   * Breakpoint specification fields in the update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Breakpoint breakpoint;

  /**
   * Required. Updated breakpoint information. The field `id` must be set. The agent must echo all
   * Breakpoint specification fields in the update.
   * @return value or {@code null} for none
   */
  public Breakpoint getBreakpoint() {
    return breakpoint;
  }

  /**
   * Required. Updated breakpoint information. The field `id` must be set. The agent must echo all
   * Breakpoint specification fields in the update.
   * @param breakpoint breakpoint or {@code null} for none
   */
  public UpdateActiveBreakpointRequest setBreakpoint(Breakpoint breakpoint) {
    this.breakpoint = breakpoint;
    return this;
  }

  @Override
  public UpdateActiveBreakpointRequest set(String fieldName, Object value) {
    return (UpdateActiveBreakpointRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateActiveBreakpointRequest clone() {
    return (UpdateActiveBreakpointRequest) super.clone();
  }

}
