/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * An ExtendedSourceContext is a SourceContext combined with additional details describing the
 * context.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Debugger API (Deprecated). For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExtendedSourceContext extends com.google.api.client.json.GenericJson {

  /**
   * Any source context.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SourceContext context;

  /**
   * Labels with user defined metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Any source context.
   * @return value or {@code null} for none
   */
  public SourceContext getContext() {
    return context;
  }

  /**
   * Any source context.
   * @param context context or {@code null} for none
   */
  public ExtendedSourceContext setContext(SourceContext context) {
    this.context = context;
    return this;
  }

  /**
   * Labels with user defined metadata.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels with user defined metadata.
   * @param labels labels or {@code null} for none
   */
  public ExtendedSourceContext setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public ExtendedSourceContext set(String fieldName, Object value) {
    return (ExtendedSourceContext) super.set(fieldName, value);
  }

  @Override
  public ExtendedSourceContext clone() {
    return (ExtendedSourceContext) super.clone();
  }

}
