/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * Response for listing active breakpoints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Debugger API (Deprecated). For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListActiveBreakpointsResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Breakpoint> breakpoints;

  static {
    // hack to force ProGuard to consider Breakpoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Breakpoint.class);
  }

  /**
   * A token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextWaitToken;

  /**
   * If set to `true`, indicates that there is no change to the list of active breakpoints and the
   * server-selected timeout has expired. The `breakpoints` field would be empty and should be
   * ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean waitExpired;

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * @return value or {@code null} for none
   */
  public java.util.List<Breakpoint> getBreakpoints() {
    return breakpoints;
  }

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * @param breakpoints breakpoints or {@code null} for none
   */
  public ListActiveBreakpointsResponse setBreakpoints(java.util.List<Breakpoint> breakpoints) {
    this.breakpoints = breakpoints;
    return this;
  }

  /**
   * A token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextWaitToken() {
    return nextWaitToken;
  }

  /**
   * A token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * @param nextWaitToken nextWaitToken or {@code null} for none
   */
  public ListActiveBreakpointsResponse setNextWaitToken(java.lang.String nextWaitToken) {
    this.nextWaitToken = nextWaitToken;
    return this;
  }

  /**
   * If set to `true`, indicates that there is no change to the list of active breakpoints and the
   * server-selected timeout has expired. The `breakpoints` field would be empty and should be
   * ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWaitExpired() {
    return waitExpired;
  }

  /**
   * If set to `true`, indicates that there is no change to the list of active breakpoints and the
   * server-selected timeout has expired. The `breakpoints` field would be empty and should be
   * ignored.
   * @param waitExpired waitExpired or {@code null} for none
   */
  public ListActiveBreakpointsResponse setWaitExpired(java.lang.Boolean waitExpired) {
    this.waitExpired = waitExpired;
    return this;
  }

  @Override
  public ListActiveBreakpointsResponse set(String fieldName, Object value) {
    return (ListActiveBreakpointsResponse) super.set(fieldName, value);
  }

  @Override
  public ListActiveBreakpointsResponse clone() {
    return (ListActiveBreakpointsResponse) super.clone();
  }

}
